/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler.IMultiblock;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDevices;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnace;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockBlastFurnaceAdvanced implements IMultiblock
{

	public static MultiblockBlastFurnaceAdvanced instance = new MultiblockBlastFurnaceAdvanced();

	static ItemStack[][][] structure = new ItemStack[4][3][3];
	static{
		for(int h=0;h<4;h++)
			for(int l=0;l<3;l++)
				for(int w=0;w<3;w++)
					if(h==3 && w==1 && l==1)
						structure[h][l][w]=new ItemStack(Blocks.field_150438_bZ);
					else if(h<3)
						structure[h][l][w]=new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.BLASTBRICK_REINFORCED.getMeta());
	}
	@Override
	public ItemStack[][][] getStructureManual()
	{
		return structure;
	}

	@Override
	public float getManualScale()
	{
		return 14;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public boolean overwriteBlockRender(ItemStack stack, int iterator)
	{
		return false;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public boolean canRenderFormedStructure()
	{
		return true;
	}
	//@SideOnly(Side.CLIENT)
	static ItemStack renderStack = ItemStack.field_190927_a;

	@Override
	@SideOnly(Side.CLIENT)
	public void renderFormedStructure()
	{
		if(renderStack.func_190926_b())
			renderStack = new ItemStack(IEContent.blockStoneDevice,1,BlockTypes_StoneDecoration.BLASTBRICK_REINFORCED.getMeta());
		GlStateManager.func_179137_b(1.5,1.5,1.5);
		GlStateManager.func_179114_b(-45, 0, 1, 0);
		GlStateManager.func_179114_b(-20, 1, 0, 0);
		GlStateManager.func_179152_a(4, 4, 4);
		ClientUtils.mc().func_175599_af().func_181564_a(renderStack, ItemCameraTransforms.TransformType.GUI);
	}

	@Override
	public String getUniqueName()
	{
		return "IE:BlastFurnaceAdvanced";
	}

	@Override
	public boolean isBlockTrigger(IBlockState state)
	{
		return state.func_177230_c()==IEContent.blockStoneDecoration && (state.func_177230_c().func_176201_c(state)==2);
	}

	@Override
	public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player)
	{
		EnumFacing f = EnumFacing.func_176733_a(player.field_70177_z);
		pos = pos.func_177972_a(f);

		for(int h=-1;h<=2;h++)
			for(int xx=-1;xx<=1;xx++)
				for(int zz=-1;zz<=1;zz++)
					if(h!=2 || (xx==0 && zz==0))
					{
						if(h==2)
						{
							if(!Utils.isBlockAt(world, pos.func_177982_a(xx, h, zz), Blocks.field_150438_bZ, -1))
								return false;
						}
						else
						{
							if(!Utils.isBlockAt(world, pos.func_177982_a(xx, h, zz), IEContent.blockStoneDecoration, BlockTypes_StoneDecoration.BLASTBRICK_REINFORCED.getMeta()))
								return false;
						}
					}

		IBlockState state = IEContent.blockStoneDevice.func_176203_a(BlockTypes_StoneDevices.BLAST_FURNACE_ADVANCED.getMeta());
		state = state.func_177226_a(IEProperties.FACING_HORIZONTAL, f.func_176734_d());
		for(int h=-1;h<=2;h++)
			for(int l=-1;l<=1;l++)
				for(int w=-1;w<=1;w++)
					if(h!=2 || (w==0 && l==0))
					{
						int xx = f==EnumFacing.EAST?l: f==EnumFacing.WEST?-l: f==EnumFacing.NORTH?-w:w;
						int zz = f==EnumFacing.NORTH?l: f==EnumFacing.SOUTH?-l: f==EnumFacing.EAST?w:-w;

						world.func_175656_a(pos.func_177982_a(xx, h, zz), state);
						BlockPos pos2 = pos.func_177982_a(xx, h, zz);
						TileEntity curr = world.func_175625_s(pos2);
						if(curr instanceof TileEntityBlastFurnace)
						{
							TileEntityBlastFurnace currBlast = (TileEntityBlastFurnace) curr;
							currBlast.offset=new int[]{xx,h,zz};
							currBlast.pos = (h+1)*9 + (l+1)*3 + (w+1);
							currBlast.formed=true;
							currBlast.func_70296_d();
							world.func_175641_c(pos2, IEContent.blockStoneDevice, 255, 0);
						}
					}
		return true;
	}

	static final IngredientStack[] materials = new IngredientStack[]{new IngredientStack(new ItemStack(IEContent.blockStoneDecoration, 27, BlockTypes_StoneDecoration.BLASTBRICK_REINFORCED.getMeta())), ApiUtils.createIngredientStack(Blocks.field_150438_bZ)};
	@Override
	public IngredientStack[] getTotalMaterials()
	{
		return materials;
	}
}
