/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.MultiblockHandler.IMultiblock;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsIE;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalMultiblock;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class MultiblockArcFurnace implements IMultiblock
{
	public static MultiblockArcFurnace instance = new MultiblockArcFurnace();
	static ItemStack[][][] structure = new ItemStack[5][5][5];
	static{
		for(int h=0;h<5;h++)
			for(int l=0;l<5;l++)
				for(int w=0;w<5;w++)
				{
					if(h==0)
					{
						if(l==0&&w==2)
							structure[h][l][w] = new ItemStack(Items.field_151066_bu);
						else if(l==2&&(w==0||w==4))
							structure[h][l][w] = new ItemStack(IEContent.blockStorage,1,BlockTypes_MetalsIE.STEEL.getMeta());
						else if(l==0&&w==0)
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration1,1,BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta());
						else if(l==4&& w==2)
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta());
						else if(l==4||(l>2 &&(w==0||w==4)))
							structure[h][l][w] = new ItemStack(IEContent.blockSheetmetal,1,BlockTypes_MetalsAll.STEEL.getMeta());
						else
							structure[h][l][w] = new ItemStack(IEContent.blockSheetmetalSlabs,1,BlockTypes_MetalsAll.STEEL.getMeta());
					}
					else if(h==1)
					{
						if(l==2&&(w==0||w==4))
							structure[h][l][w] = new ItemStack(IEContent.blockStorage,1,BlockTypes_MetalsIE.STEEL.getMeta());
						else if(l==0&&w==0)
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta());
						else if(l==4&&w>0&&w<4)
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta());
						else if((w==0||w==4)&&l>2)
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta());
						else if(l>=2 && w>0&&w<4)
							structure[h][l][w] = new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.BLASTBRICK_REINFORCED.getMeta());
					}
					else if(h==2)
					{
						if(l==2&&(w==0||w==4))
							structure[h][l][w] = new ItemStack(IEContent.blockStorage,1,BlockTypes_MetalsIE.STEEL.getMeta());
						else if(l==4&&w>0&&w<4)
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta());
						else if(l==4)
							structure[h][l][w] = new ItemStack(IEContent.blockSheetmetal,1,BlockTypes_MetalsAll.STEEL.getMeta());
						else if(w>0&&w<4)
							structure[h][l][w] = new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.BLASTBRICK_REINFORCED.getMeta());
					}
					else if(h==3)
					{
						if(l==4&&w==2)
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta());
						else if(l==4&&(w==1||w==3))
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration1,1,BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta());
						else if(l>0&&w>0&&w<4)
							structure[h][l][w] = new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.BLASTBRICK_REINFORCED.getMeta());
					}
					else if(h==4)
					{
						if(l>1&&w==2)
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta());
						else if(l==4&&(w==1||w==3))
							structure[h][l][w] = new ItemStack(IEContent.blockMetalDecoration1,1,BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta());
					}

					if (structure[h][l][w] == null) {
						structure[h][l][w] = ItemStack.field_190927_a;
					}
				}
	}
	@Override
	public ItemStack[][][] getStructureManual()
	{
		return structure;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public boolean overwriteBlockRender(ItemStack stack, int iterator)
	{
		return false;
	}
	@Override
	public IBlockState getBlockstateFromStack(int index, ItemStack stack)
	{
		if(!stack.func_190926_b())
		{
			if(stack.func_77973_b() == Items.field_151066_bu)
				return Blocks.field_150383_bp.func_176223_P();
			else if(stack.func_77973_b() instanceof ItemBlock)
				return ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77952_i());
		}
		return null;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public boolean canRenderFormedStructure()
	{
		return true;
	}
	//@SideOnly(Side.CLIENT)
	static ItemStack renderStack = ItemStack.field_190927_a;
	@Override
	@SideOnly(Side.CLIENT)
	public void renderFormedStructure()
	{
		if(renderStack.func_190926_b())
			renderStack = new ItemStack(IEContent.blockMetalMultiblock,1,BlockTypes_MetalMultiblock.ARC_FURNACE.getMeta());

		GlStateManager.func_179137_b(2.5, 2.25, 2.25);
		GlStateManager.func_179114_b(-45, 0, 1, 0);
		GlStateManager.func_179114_b(-20, 1, 0, 0);
		GlStateManager.func_179139_a(6.5, 6.5, 6.5);

		GlStateManager.func_179129_p();
		ClientUtils.mc().func_175599_af().func_181564_a(renderStack, ItemCameraTransforms.TransformType.GUI);
		GlStateManager.func_179089_o();
	}
	@Override
	public float getManualScale()
	{
		return 12;
	}

	@Override
	public String getUniqueName()
	{
		return "IE:ArcFurnace";
	}

	@Override
	public boolean isBlockTrigger(IBlockState state)
	{
		return state.func_177230_c()==Blocks.field_150383_bp;
	}

	@Override
	public boolean createStructure(World world, BlockPos pos, EnumFacing side, EntityPlayer player)
	{
		if(side==EnumFacing.UP||side==EnumFacing.DOWN)
			side = EnumFacing.func_176733_a(player.field_70177_z);
		BlockPos startPos = pos;
		side = side.func_176734_d();

		if(Utils.isOreBlockAt(world, startPos.func_177982_a(0,-1,0), "scaffoldingSteel")
				&& Utils.isBlockAt(world, startPos.func_177967_a(side,2).func_177982_a(0,-1,0), IEContent.blockMetalDecoration0, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()))
		{
			startPos = startPos.func_177967_a(side,2);
			side = side.func_176734_d();
		}

		boolean mirrored = false;
		boolean b = structureCheck(world,startPos, side, mirrored);
		if(!b)
		{
			mirrored = true;
			b = structureCheck(world,startPos, side, mirrored);
		}

		if(b)
		{
			IBlockState state = IEContent.blockMetalMultiblock.func_176203_a(BlockTypes_MetalMultiblock.ARC_FURNACE.getMeta());
			state = state.func_177226_a(IEProperties.FACING_HORIZONTAL, side);
			for(int l=0;l<5;l++)
				for(int w=-2;w<=2;w++)
					for(int h=0;h<5;h++)
						if(!structure[h][l][w+2].func_190926_b())
						{
							int ww = mirrored?-w:w;
							BlockPos pos2 = startPos.func_177967_a(side, l).func_177967_a(side.func_176746_e(), ww).func_177982_a(0, h, 0);

							world.func_175656_a(pos2, state);
							TileEntity curr = world.func_175625_s(pos2);
							if(curr instanceof TileEntityArcFurnace)
							{
								TileEntityArcFurnace tile = (TileEntityArcFurnace)curr;
								tile.formed=true;
								tile.pos = h*25 + l*5 + (w+2);
								tile.offset = new int[]{(side==EnumFacing.WEST?-l+2: side==EnumFacing.EAST?l-2: side==EnumFacing.NORTH?ww: -ww),h-1,(side==EnumFacing.NORTH?-l+2: side==EnumFacing.SOUTH?l-2: side==EnumFacing.EAST?ww : -ww)};
								tile.mirrored = mirrored;
								tile.func_70296_d();
								world.func_175641_c(pos2, IEContent.blockMetalMultiblock, 255, 0);
							}
						}
		}
		return b;
	}

	boolean structureCheck(World world, BlockPos startPos, EnumFacing dir, boolean mirror)
	{
		for(int l=0;l<5;l++)
			for(int w=-2;w<=2;w++)
				for(int h=0;h<5;h++)
					if(!structure[h][l][w+2].func_190926_b())
					{
						int ww = mirror?-w:w;
						BlockPos pos = startPos.func_177967_a(dir, l).func_177967_a(dir.func_176746_e(), ww).func_177982_a(0, h, 0);

						if(world.func_175623_d(pos))
							return false;
						if(OreDictionary.itemMatches(structure[h][l][w+2], new ItemStack(Items.field_151066_bu), true))
						{
							if(!Utils.isBlockAt(world, pos, Blocks.field_150383_bp, OreDictionary.WILDCARD_VALUE))
								return false;
						}
						else if(OreDictionary.itemMatches(structure[h][l][w+2], new ItemStack(IEContent.blockMetalDecoration1,1,BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta()), true))
						{
							if(!Utils.isOreBlockAt(world, pos, "scaffoldingSteel"))
								return false;
						}
						else if(OreDictionary.itemMatches(structure[h][l][w+2], new ItemStack(IEContent.blockSheetmetal,1,BlockTypes_MetalsAll.STEEL.getMeta()), true))
						{
							if(!Utils.isOreBlockAt(world, pos, "blockSheetmetalSteel"))
								return false;
						}
						else if(OreDictionary.itemMatches(structure[h][l][w+2], new ItemStack(IEContent.blockSheetmetalSlabs,1,BlockTypes_MetalsAll.STEEL.getMeta()), true))
						{
							if(!Utils.isOreBlockAt(world, pos, "slabSheetmetalSteel"))
								return false;
						}
						else if(OreDictionary.itemMatches(structure[h][l][w+2], new ItemStack(IEContent.blockStorage,1,BlockTypes_MetalsIE.STEEL.getMeta()), true))
						{
							if(!Utils.isOreBlockAt(world, pos, "blockSteel"))
								return false;
						}
						else
						{
							Block b = Block.func_149634_a(structure[h][l][w+2].func_77973_b());
							if(b!=null)
								if(!Utils.isBlockAt(world, pos, b,structure[h][l][w+2].func_77952_i()))
									return false;
						}
					}
		return true;
	}

	static final IngredientStack[] materials = new IngredientStack[]{
			new IngredientStack(new ItemStack(Items.field_151066_bu)),
			new IngredientStack("slabSheetmetalSteel", 14),
			new IngredientStack("blockSheetmetalSteel", 8),
			new IngredientStack("blockSteel", 6),
			new IngredientStack("scaffoldingSteel", 5),
			new IngredientStack(new ItemStack(IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta())),
			new IngredientStack(new ItemStack(IEContent.blockMetalDecoration0, 10, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta())),
			new IngredientStack(new ItemStack(IEContent.blockMetalDecoration0, 5, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta())),
			new IngredientStack(new ItemStack(IEContent.blockStoneDecoration, 27, BlockTypes_StoneDecoration.BLASTBRICK_REINFORCED.getMeta()))};
	@Override
	public IngredientStack[] getTotalMaterials()
	{
		return materials;
	}
}
