/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler.ConveyorDirection;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler.IConveyorBelt;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler.IConveyorTile;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import java.util.ArrayList;
import java.util.List;

/**
 * @author BluSunrize - 20.08.2016
 */
public class ConveyorVertical extends ConveyorBasic
{
	@Override
	public boolean renderWall(TileEntity tile, EnumFacing facing, int wall)
	{
		return true;
	}

	@Override
	public boolean changeConveyorDirection()
	{
		return false;
	}

	@Override
	public boolean setConveyorDirection(ConveyorDirection dir)
	{
		return false;
	}


	@Override
	public String getModelCacheKey(TileEntity tile, EnumFacing facing)
	{
		String key = ConveyorHandler.reverseClassRegistry.get(this.getClass()).toString();
		key += "f" + facing.ordinal();
		key += "a" + (isActive(tile) ? 1 : 0);
		key += "b" + (renderBottomBelt(tile, facing)?("1"+(renderBottomWall(tile,facing,0)?"1":"0")+(renderBottomWall(tile,facing,1)?"1":"0")):"000");
		key += "c" + getDyeColour();
		return key;
	}
	boolean renderBottomBelt(TileEntity tile, EnumFacing facing)
	{
		TileEntity te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177982_a(0, -1, 0));
		if(te instanceof IConveyorTile && ((IConveyorTile)te).getConveyorSubtype() != null)
			for(EnumFacing f : ((IConveyorTile)te).getConveyorSubtype().sigTransportDirections(te, ((IConveyorTile)te).getFacing()))
				if(f == EnumFacing.UP)
					return false;
		for(EnumFacing f : EnumFacing.field_176754_o)
			if(f != facing && isInwardConveyor(tile, f))
				return true;
		return false;
	}
	protected boolean isInwardConveyor(TileEntity tile, EnumFacing f)
	{
		TileEntity te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(f));
		if(te instanceof IConveyorTile)
		{
			IConveyorBelt sub = ((IConveyorTile)te).getConveyorSubtype();
			if (sub!=null)
				for(EnumFacing f2 : sub.sigTransportDirections(te, ((IConveyorTile)te).getFacing()))
					if(f == f2.func_176734_d())
						return true;
		}
		te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177982_a(0, -1, 0).func_177972_a(f));
		if(te instanceof IConveyorTile)
		{
			IConveyorBelt sub = ((IConveyorTile)te).getConveyorSubtype();
			if (sub!=null)
			{
				int b = 0;
				for(EnumFacing f2 : sub.sigTransportDirections(te, ((IConveyorTile)te).getFacing()))
				{
					if(f == f2.func_176734_d())
						b++;
					else if(EnumFacing.UP == f2)
						b++;
					if(b == 2)
						return true;
				}
			}
		}
		return false;
	}
	protected boolean renderBottomWall(TileEntity tile, EnumFacing facing, int wall)
	{
		return super.renderWall(tile, facing, wall);
	}

	@Override
	public EnumFacing[] sigTransportDirections(TileEntity conveyorTile, EnumFacing facing)
	{
		return new EnumFacing[]{EnumFacing.UP, facing};
	}

	@Override
	public Vec3d getDirection(TileEntity conveyorTile, Entity entity, EnumFacing facing)
	{
		BlockPos posWall = conveyorTile.func_174877_v().func_177972_a(facing);
		double d = .625 + entity.field_70130_N;
		double distToWall = Math.abs((facing.func_176740_k() == Axis.Z ? posWall.func_177952_p() : posWall.func_177958_n()) + .5 - (facing.func_176740_k() == Axis.Z ? entity.field_70161_v : entity.field_70165_t));
		if(distToWall > d)
			return super.getDirection(conveyorTile, entity, facing);

		double vBase = entity instanceof EntityLivingBase ? 1.5 : 1.15;
		double distY = Math.abs(conveyorTile.func_174877_v().func_177982_a(0, 1, 0).func_177956_o() + .5 - entity.field_70163_u);
		double treshold = .9;
		boolean contact = distY < treshold;

		double vX = entity.field_70159_w;
		double vY = 0.1 * vBase;
		double vZ = entity.field_70179_y;
		if(entity.field_70181_x < 0)
			vY += entity.field_70181_x * .9;

		if(!(entity instanceof EntityPlayer))
		{
			vX = 0.05 * facing.func_82601_c();
			vZ = 0.05 * facing.func_82599_e();
			if(facing == EnumFacing.WEST || facing == EnumFacing.EAST)
			{
				if(entity.field_70161_v > conveyorTile.func_174877_v().func_177952_p() + 0.65D)
					vZ = -0.1D * vBase;
				else if(entity.field_70161_v < conveyorTile.func_174877_v().func_177952_p() + 0.35D)
					vZ = 0.1D * vBase;
			} else if(facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH)
			{
				if(entity.field_70165_t > conveyorTile.func_174877_v().func_177958_n() + 0.65D)
					vX = -0.1D * vBase;
				else if(entity.field_70165_t < conveyorTile.func_174877_v().func_177958_n() + 0.35D)
					vX = 0.1D * vBase;
			}
		}
		//Little boost at the top of a conveyor to help players and minecarts to get off
		BlockPos upForward = conveyorTile.func_174877_v().func_177982_a(0, 1, 0);
		if(contact && !(Utils.getExistingTileEntity(conveyorTile.func_145831_w(), upForward) instanceof IConveyorTile))
			vY *= 2.25;
		return new Vec3d(vX, vY, vZ);
	}

	@Override
	public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing)
	{
		if(!isActive(tile))
			return;

		BlockPos posWall = tile.func_174877_v().func_177972_a(facing);
		double d = .625 + entity.field_70130_N;
		double distToWall = Math.abs((facing.func_176740_k() == Axis.Z ? posWall.func_177952_p() : posWall.func_177958_n()) + .5 - (facing.func_176740_k() == Axis.Z ? entity.field_70161_v : entity.field_70165_t));
		if(distToWall > d)
		{
			super.onEntityCollision(tile, entity, facing);
			return;
		}

		if(entity != null && !entity.field_70128_L && !(entity instanceof EntityPlayer && entity.func_70093_af()))
		{
			double distY = Math.abs(tile.func_174877_v().func_177982_a(0, 1, 0).func_177956_o() + .5 - entity.field_70163_u);
			double treshold = .9;
			boolean contact = distY < treshold;

			entity.field_70122_E = false;
			if(entity.field_70143_R < 3)
				entity.field_70143_R = 0;
			else
				entity.field_70143_R *= .9;
			Vec3d vec = getDirection(tile, entity, facing);
			entity.field_70159_w = vec.field_72450_a;
			entity.field_70181_x = vec.field_72448_b;
			entity.field_70179_y = vec.field_72449_c;

			if(!contact)
				ConveyorHandler.applyMagnetSupression(entity, (IConveyorTile) tile);
			else
			{
				BlockPos posTop = tile.func_174877_v().func_177982_a(0, 1, 0);
				if(!((tile.func_145831_w().func_175625_s(posTop) instanceof IConveyorTile) || (tile.func_145831_w().func_175623_d(posTop) && (tile.func_145831_w().func_175625_s(posTop.func_177972_a(facing)) instanceof IConveyorTile))))
					ConveyorHandler.revertMagnetSupression(entity, (IConveyorTile) tile);
			}

			if(entity instanceof EntityItem)
			{
				((EntityItem) entity).func_174873_u();
				TileEntity inventoryTile;
				inventoryTile = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177982_a(0, 1, 0));
				if(!tile.func_145831_w().field_72995_K)
				{
					if(contact && inventoryTile != null && !(inventoryTile instanceof IConveyorTile))
					{
						ItemStack stack = ((EntityItem) entity).func_92059_d();
						if(!stack.func_190926_b())
						{
							ItemStack ret = Utils.insertStackIntoInventory(inventoryTile, stack, EnumFacing.DOWN);
							if(ret.func_190926_b())
								entity.func_70106_y();
							else if(ret.func_190916_E() < stack.func_190916_E())
								((EntityItem) entity).func_92058_a(ret);
						}
					}
				}
			}
		}
	}

	static final AxisAlignedBB[] verticalBounds = {new AxisAlignedBB(0, 0, 0, 1, 1, .125f), new AxisAlignedBB(0, 0, .875f, 1, 1, 1), new AxisAlignedBB(0, 0, 0, .125f, 1, 1), new AxisAlignedBB(.875f, 0, 0, 1, 1, 1)};

	@Override
	public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing)
	{
		ArrayList list = new ArrayList();
		if(facing.ordinal() > 1)
			list.add(verticalBounds[facing.ordinal() - 2]);
		if(renderBottomBelt(tile, facing) || list.isEmpty())
			list.add(conveyorBounds);
		return list;
	}

	@Override
	public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing)
	{
		ArrayList list = new ArrayList();
		if(facing.ordinal() > 1)
			list.add(verticalBounds[facing.ordinal() - 2]);
		if(renderBottomBelt(tile, facing) || list.isEmpty())
			list.add(conveyorBounds);
		return list;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public Matrix4f modifyBaseRotationMatrix(Matrix4f matrix, TileEntity tile, EnumFacing facing)
	{
		return new Matrix4(matrix).translate(0, 1, 0).rotate(Math.PI / 2, 1, 0, 0).toMatrix4f();
	}

	public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:blocks/conveyor_vertical");
	public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:blocks/conveyor_vertical_off");

	@Override
	public ResourceLocation getActiveTexture()
	{
		return texture_on;
	}

	@Override
	public ResourceLocation getInactiveTexture()
	{
		return texture_off;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing)
	{
		if(tile != null && this.renderBottomBelt(tile, facing))
		{
			TextureAtlasSprite sprite = ClientUtils.getSprite(isActive(tile) ? ConveyorBasic.texture_on : ConveyorBasic.texture_off);
			TextureAtlasSprite spriteColour = ClientUtils.getSprite(getColouredStripesTexture());
			boolean[] walls = {renderBottomWall(tile, facing, 0), renderBottomWall(tile, facing, 1)};
			baseModel.addAll(ModelConveyor.getBaseConveyor(facing, .875f, new Matrix4(facing), ConveyorDirection.HORIZONTAL, sprite, walls, new boolean[]{true, false}, spriteColour, getDyeColour()));
		}
		return baseModel;
	}
}
