/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler.ConveyorDirection;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler.IConveyorTile;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

import javax.annotation.Nullable;
import java.util.List;

/**
 * @author BluSunrize - 20.08.2016
 */
public class ConveyorSplit extends ConveyorBasic
{
	EnumFacing outputFace = EnumFacing.NORTH;

	public ConveyorSplit(EnumFacing startingOutputFace)
	{
		this.outputFace = startingOutputFace.func_176746_e();
	}

	@Override
	public ConveyorDirection getConveyorDirection()
	{
		return ConveyorDirection.HORIZONTAL;
	}

	@Override
	public boolean changeConveyorDirection()
	{
		return false;
	}

	@Override
	public boolean setConveyorDirection(ConveyorDirection dir)
	{
		return false;
	}

	@Override
	public void afterRotation(EnumFacing oldDir, EnumFacing newDir)
	{
		this.outputFace = newDir.func_176746_e();
	}

	@Override
	public void handleInsertion(TileEntity tile, EntityItem entity, EnumFacing facing, ConveyorDirection conDir, double distX, double distZ)
	{
		String nbtKey = "immersiveengineering:conveyorDir"+Integer.toHexString(tile.func_174877_v().hashCode());
		if(entity.getEntityData().func_74764_b(nbtKey))
		{
			EnumFacing redirect = EnumFacing.values()[entity.getEntityData().func_74762_e(nbtKey)];
			BlockPos nextPos = tile.func_174877_v().func_177972_a(redirect);
			double distNext = Math.abs((redirect.func_176740_k() == Axis.Z ? nextPos.func_177952_p() : nextPos.func_177958_n()) + .5 - (redirect.func_176740_k() == Axis.Z ? entity.field_70161_v : entity.field_70165_t));
			if(distNext<.7)
				super.handleInsertion(tile, entity, redirect, conDir, distX, distZ);
		}
	}

	@Override
	public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing)
	{
		if(!isActive(tile))
			return;
		EnumFacing redirect = null;
		if(entity != null && !entity.field_70128_L)
		{
			String nbtKey = "immersiveengineering:conveyorDir"+Integer.toHexString(tile.func_174877_v().hashCode());
			if(entity.getEntityData().func_74764_b(nbtKey))
				redirect = EnumFacing.values()[entity.getEntityData().func_74762_e(nbtKey)];
			else
			{
				redirect = this.outputFace;
				entity.getEntityData().func_74768_a(nbtKey, redirect.ordinal());
				BlockPos nextPos = tile.func_174877_v().func_177972_a(this.outputFace.func_176734_d());
				if(tile.func_145831_w().func_175667_e(nextPos))
				{
					TileEntity nextTile = tile.func_145831_w().func_175625_s(nextPos);
					if(!(nextTile instanceof IConveyorTile))
						this.outputFace = outputFace.func_176734_d();
					else if(((IConveyorTile)nextTile).getFacing() != this.outputFace)
						this.outputFace = outputFace.func_176734_d();
				}
			}
		}
		super.onEntityCollision(tile, entity, facing);
		if(redirect != null)
		{
			String nbtKey = "immersiveengineering:conveyorDir"+Integer.toHexString(tile.func_174877_v().hashCode());
			BlockPos nextPos = tile.func_174877_v().func_177972_a(redirect);
			double distNext = Math.abs((redirect.func_176740_k() == Axis.Z ? nextPos.func_177952_p() : nextPos.func_177958_n()) + .5 - (redirect.func_176740_k() == Axis.Z ? entity.field_70161_v : entity.field_70165_t));
			double treshold = .4;
			boolean contact = distNext < treshold;
			if(contact)
				entity.getEntityData().func_82580_o(nbtKey);
		}
	}

	@Override
	public boolean renderWall(TileEntity tile, EnumFacing facing, int wall)
	{
		return false;
	}

	@Override
	public EnumFacing[] sigTransportDirections(TileEntity conveyorTile, EnumFacing facing)
	{
		return new EnumFacing[]{facing.func_176746_e(), facing.func_176735_f()};
	}

	@Override
	public Vec3d getDirection(TileEntity conveyorTile, Entity entity, EnumFacing facing)
	{
		Vec3d vec = super.getDirection(conveyorTile, entity, facing);
		String nbtKey = "immersiveengineering:conveyorDir"+Integer.toHexString(conveyorTile.func_174877_v().hashCode());
		if(!entity.getEntityData().func_74764_b(nbtKey))
			return vec;
		EnumFacing redirect = EnumFacing.func_82600_a(entity.getEntityData().func_74762_e(nbtKey));
		BlockPos wallPos = conveyorTile.func_174877_v().func_177972_a(facing);
		double distNext = Math.abs((facing.func_176740_k() == Axis.Z ? wallPos.func_177952_p() : wallPos.func_177958_n()) + .5 - (facing.func_176740_k() == Axis.Z ? entity.field_70161_v : entity.field_70165_t));
		if(distNext < 1.33)
		{
			double sideMove = Math.pow(1 + distNext, 0.1) * .2;
			if(distNext < .8)
				vec = new Vec3d(facing.func_176740_k() == Axis.X ? 0 : vec.field_72450_a, vec.field_72448_b, facing.func_176740_k() == Axis.Z ? 0 : vec.field_72449_c);
			vec = vec.func_72441_c(redirect.func_82601_c() * sideMove, 0, redirect.func_82599_e() * sideMove);
		}
		return vec;
	}

	@Override
	public NBTTagCompound writeConveyorNBT()
	{
		NBTTagCompound nbt = super.writeConveyorNBT();
		nbt.func_74768_a("outputFace", outputFace.ordinal());
		return nbt;
	}

	@Override
	public void readConveyorNBT(NBTTagCompound nbt)
	{
		super.readConveyorNBT(nbt);
		outputFace = EnumFacing.values()[nbt.func_74762_e("outputFace")];
	}

	public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:blocks/conveyor_split");
	public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:blocks/conveyor_split_off");
	public static ResourceLocation texture_casing = new ResourceLocation("immersiveengineering:blocks/conveyor_split_wall");

	@Override
	public ResourceLocation getActiveTexture()
	{
		return texture_on;
	}

	@Override
	public ResourceLocation getInactiveTexture()
	{
		return texture_off;
	}


	@Override
	@SideOnly(Side.CLIENT)
	public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing)
	{
		TextureAtlasSprite tex_casing0 = ClientUtils.getSprite(texture_casing);
		Matrix4 matrix = new Matrix4(facing);
		float[] colour = {1, 1, 1, 1};
		Vector3f[] vertices = {new Vector3f(.0625f, .1875f, 0), new Vector3f(.0625f, .1875f, 1), new Vector3f(.9375f, .1875f, 1), new Vector3f(.9375f, .1875f, 0)};
		baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), EnumFacing.UP, tex_casing0, new double[]{1, 16, 15, 0}, colour, false));

		vertices = new Vector3f[]{new Vector3f(.0625f, 0, 0), new Vector3f(.0625f, .1875f, 0), new Vector3f(.9375f, .1875f, 0), new Vector3f(.9375f, 0, 0)};
		baseModel.set(15, ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, ClientUtils.getSprite(ModelConveyor.rl_casing[1]), new double[]{1, 16, 15, 13}, colour, false));

		vertices = new Vector3f[]{new Vector3f(.0625f, .125f, 0), new Vector3f(.0625f, .1875f, 0), new Vector3f(.9375f, .1875f, 0), new Vector3f(.9375f, .125f, 0)};
		Vector3f[] vertices2 = new Vector3f[]{new Vector3f(.5f, .125f, 0), new Vector3f(.5f, .125f, .5f), new Vector3f(.5f, .1875f, .5f), new Vector3f(.5f, .1875f, 0)};
		Vector3f[] vertices3 = new Vector3f[]{new Vector3f(.5f, .125f, 0), new Vector3f(.5f, .125f, .5f), new Vector3f(.5f, .1875f, .5f), new Vector3f(.5f, .1875f, 0)};
		for(int i = 0; i < 8; i++)
		{
			for(int iv = 0; iv < vertices.length; iv++)
			{
				vertices[iv].setZ((i + 1) * .0625f);
				vertices2[iv].setX(vertices2[iv].getX() + .0625f);
				vertices3[iv].setX(vertices3[iv].getX() - .0625f);
			}
			double v = 16 - i;
			baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices), facing, tex_casing0, new double[]{1, v - 1, 15, v}, colour, true));
			if(i < 7)
			{
				double u = 8 - i;
				baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices2), facing, tex_casing0, new double[]{u - 1, 16, u, 8}, colour, true));
				baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertices3), facing, tex_casing0, new double[]{u - 1, 16, u, 8}, colour, false));
			}
		}
		return baseModel;
	}
}
