/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler.ConveyorDirection;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler.IConveyorTile;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

/**
 * @author BluSunrize - 20.08.2016
 */
public class ConveyorDrop extends ConveyorBasic
{
	@Override
	public void handleInsertion(TileEntity tile, EntityItem entity, EnumFacing facing, ConveyorDirection conDir, double distX, double distZ)
	{
		BlockPos posDown = tile.func_174877_v().func_177977_b();
		TileEntity inventoryTile = tile.func_145831_w().func_175625_s(posDown);
		boolean contact = Math.abs(facing.func_176740_k() == Axis.Z ? (tile.func_174877_v().func_177952_p() + .5 - entity.field_70161_v) : (tile.func_174877_v().func_177958_n() + .5 - entity.field_70165_t)) < .2;

		if(contact && inventoryTile != null && !(inventoryTile instanceof IConveyorTile))
		{
			if(!tile.func_145831_w().field_72995_K)
			{
				ItemStack stack = entity.func_92059_d();
				if(!stack.func_190926_b())
				{
					ItemStack ret = ApiUtils.insertStackIntoInventory(inventoryTile, stack, EnumFacing.UP);
					if(ret.func_190926_b())
						entity.func_70106_y();
					else if(ret.func_190916_E() < stack.func_190916_E())
						entity.func_92058_a(ret);
				}
			}
		}
		else if(contact && isEmptySpace(tile.func_145831_w(), posDown, inventoryTile))
		{
			entity.field_70159_w = 0;
			entity.field_70179_y = 0;
			entity.func_70107_b(tile.func_174877_v().func_177958_n() + .5, tile.func_174877_v().func_177956_o() - .5, tile.func_174877_v().func_177952_p() + .5);
			if(!(inventoryTile instanceof IConveyorTile))
				ConveyorHandler.revertMagnetSupression(entity, (IConveyorTile) tile);
		}
		else
			super.handleInsertion(tile,entity,facing,conDir,distX,distZ);
	}

	boolean isEmptySpace(World world, BlockPos pos, TileEntity tile)
	{
		if(world.func_175623_d(pos))
			return true;
		if(tile instanceof IConveyorTile)
			return true;
		IBlockState state = world.func_180495_p(pos);
		if(state.func_177230_c() instanceof BlockTrapDoor)
			return state.func_177229_b(BlockTrapDoor.field_176283_b).booleanValue();
		return false;
	}

	public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:blocks/conveyor_dropper");
	public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:blocks/conveyor_dropper_off");

	@Override
	public ResourceLocation getActiveTexture()
	{
		return texture_on;
	}

	@Override
	public ResourceLocation getInactiveTexture()
	{
		return texture_off;
	}
}
