/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.BulletHandler.IBullet;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.*;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

import javax.annotation.Nullable;

public class TileEntityTurretGun extends TileEntityTurret
{
	public int cycleRender;
	private NonNullList<ItemStack> inventory = NonNullList.func_191197_a(2, ItemStack.field_190927_a);
	public boolean expelCasings = false;

	@Override
	protected double getRange()
	{
		return 16;
	}
	@Override
	protected boolean canActivate()
	{
		return this.energyStorage.getEnergyStored()>= IEConfig.Machines.turret_gun_consumption && !inventory.get(0).func_190926_b();
	}
	@Override
	protected int getChargeupTicks()
	{
		return 5;
	}
	@Override
	protected int getActiveTicks()
	{
		return 5;
	}
	@Override
	protected boolean loopActivation()
	{
		return false;
	}
	@Override
	protected void activate()
	{
		int energy = IEConfig.Machines.turret_gun_consumption;
		ItemStack bulletStack = inventory.get(0);
		if(!bulletStack.func_190926_b() && this.energyStorage.extractEnergy(energy,true)==energy)
		{
			String key = ItemNBTHelper.getString(bulletStack, "bullet");
			IBullet bullet = BulletHandler.getBullet(key);
			if(bullet!=null&&bullet.isValidForTurret())
			{
				ItemStack casing = bullet.getCasing(bulletStack);
				if(expelCasings||casing.func_190926_b()|| inventory.get(1).func_190926_b()||(OreDictionary.itemMatches(casing, inventory.get(1), false)&& inventory.get(1).func_190916_E() + casing.func_190916_E() <= inventory.get(1).func_77976_d()))
				{
					this.energyStorage.extractEnergy(energy,false);
					this.sendRenderPacket();

					double dX = target.field_70165_t-(func_174877_v().func_177958_n()+.5);
					double dY = target.field_70163_u-(func_174877_v().func_177956_o()+.5);
					double dZ = target.field_70161_v-(func_174877_v().func_177952_p()+.5);
					Vec3d vec = new Vec3d(dX, dY, dZ).func_72432_b();

					int count = bullet.getProjectileCount(null);
					if(count==1)
					{
						Entity entBullet = getBulletEntity(field_145850_b, vec, bullet);
						field_145850_b.func_72838_d(bullet.getProjectile(null, bulletStack, entBullet, false));
					} else
						for(int i = 0; i < count; i++)
						{
							Vec3d vecDir = vec.func_72441_c(Utils.RAND.nextGaussian()*.1, Utils.RAND.nextGaussian()*.1, Utils.RAND.nextGaussian()*.1);
							Entity entBullet = getBulletEntity(field_145850_b, vecDir, bullet);
							field_145850_b.func_72838_d(bullet.getProjectile(null, bulletStack, entBullet, false));
						}
					bulletStack.func_190918_g(1);
					if(bulletStack.func_190916_E() <= 0)
						inventory.set(0, ItemStack.field_190927_a);
					if(!casing.func_190926_b())
					{
						if(expelCasings)
						{
							double cX = func_174877_v().func_177958_n()+.5;
							double cY = func_174877_v().func_177956_o()+1.375;
							double cZ = func_174877_v().func_177952_p()+.5;
							Vec3d vCasing = vec.func_178785_b(-1.57f);
							field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, cX+vCasing.field_72450_a, cY+vCasing.field_72448_b, cZ+vCasing.field_72449_c, 0,0,0, 1,0);
							EntityItem entCasing = new EntityItem(field_145850_b, cX+vCasing.field_72450_a, cY+vCasing.field_72448_b, cZ+vCasing.field_72449_c, casing.func_77946_l());
							entCasing.field_70159_w = 0;
							entCasing.field_70181_x = -0.01;
							entCasing.field_70179_y = 0;
							field_145850_b.func_72838_d(entCasing);
						} else
						{
							if(inventory.get(1).func_190926_b())
								inventory.set(1, casing.func_77946_l());
							else
								inventory.get(1).func_190917_f(casing.func_190916_E());
						}
					}
					SoundEvent sound = bullet.getSound();
					if(sound==null)
						sound = IESounds.revolverFire;
					field_145850_b.func_184133_a(null, func_174877_v(), sound, SoundCategory.BLOCKS, 1,1);
				}
			}
		}
	}

	protected void sendRenderPacket()
	{
		NBTTagCompound tag = new NBTTagCompound();
		tag.func_74757_a("cycle", true);
		ImmersiveEngineering.packetHandler.sendToAll(new MessageTileSync(this, tag));
	}

	EntityRevolvershot getBulletEntity(World world, Vec3d vecDir, IBullet type)
	{
		EntityRevolvershot bullet = new EntityRevolvershot(world, func_174877_v().func_177958_n()+.5+vecDir.field_72450_a,func_174877_v().func_177956_o()+1.375+vecDir.field_72448_b,func_174877_v().func_177952_p()+.5+vecDir.field_72449_c, 0,0,0, type);
		bullet.field_70159_w = vecDir.field_72450_a;
		bullet.field_70181_x = vecDir.field_72448_b;
		bullet.field_70179_y = vecDir.field_72449_c;
		return bullet;
	}

	@Override
	public NonNullList<ItemStack> getInventory()
	{
		return inventory;
	}
	@Override
	public boolean isStackValid(int slot, ItemStack stack)
	{
		return true;
	}

	@Override
	public void func_73660_a()
	{
		if(field_145850_b.field_72995_K&&!dummy&&cycleRender>0)
			cycleRender--;
		super.func_73660_a();
	}

	@Override
	public void receiveMessageFromServer(NBTTagCompound message)
	{
		if(message.func_74764_b("cycle"))
			cycleRender = 5;
	}
	@Override
	public void receiveMessageFromClient(NBTTagCompound message)
	{
		super.receiveMessageFromClient(message);
		if(message.func_74764_b("expelCasings"))
			expelCasings = message.func_74767_n("expelCasings");
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		expelCasings = nbt.func_74767_n("expelCasings");
		if(!descPacket)
			inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 2);
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		nbt.func_74757_a("expelCasings", expelCasings);
		if(!descPacket)
			nbt.func_74782_a("inventory", Utils.writeInventory(inventory));
	}

	IItemHandler itemHandler = new IEInventoryHandler(2,this, 0, new boolean[]{true,false},new boolean[]{false,true});
	@Override
	public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing)
	{
		if(!dummy && capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing==null||facing==EnumFacing.DOWN||facing==this.facing.func_176734_d()))
			return true;
		return super.hasCapability(capability, facing);
	}
	@Override
	public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing)
	{
		if(!dummy && capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing==null||facing==EnumFacing.DOWN||facing==this.facing.func_176734_d()))
			return (T)itemHandler;
		return super.getCapability(capability, facing);
	}
}
