/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

import javax.annotation.Nullable;

public class TileEntityTurretChem extends TileEntityTurret
{
	public FluidTank tank = new FluidTank(4000);
	public boolean ignite = false;

	@Override
	protected double getRange()
	{
		return 8;
	}
	@Override
	protected boolean canActivate()
	{
		return tank.getFluidAmount()>0 && this.energyStorage.getEnergyStored()>= IEConfig.Machines.turret_chem_consumption;
	}
	@Override
	protected int getChargeupTicks()
	{
		return 10;
	}
	@Override
	protected int getActiveTicks()
	{
		return 1;
	}
	@Override
	protected boolean loopActivation()
	{
		return true;
	}
	@Override
	protected void activate()
	{
		FluidStack fs = this.tank.getFluid();
		if(fs!=null && fs.getFluid()!=null)
		{
			int consumed = IEConfig.Tools.chemthrower_consumption;
			int energy = IEConfig.Machines.turret_chem_consumption;
			if(consumed<=fs.amount && this.energyStorage.extractEnergy(energy, true)>=energy)
			{
				tank.drain(consumed, true);
				this.energyStorage.extractEnergy(energy, false);
				double dX = target.field_70165_t-(func_174877_v().func_177958_n()+.5);
				double dY = target.field_70163_u-(func_174877_v().func_177956_o()+.5);
				double dZ = target.field_70161_v-(func_174877_v().func_177952_p()+.5);
				Vec3d v = new Vec3d(dX,dY,dZ).func_72432_b();

				int split = 8;
				boolean isGas = fs.getFluid().isGaseous()||ChemthrowerHandler.isGas(fs.getFluid());

				float scatter = isGas?.15f: .05f;
				float range = isGas?.5f: 1f;
//				if(getUpgrades(stack).getBoolean("focus"))
//				{
//					range += .25f;
//					scatter -= .025f;
//				}
				boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid())&&this.ignite;
				for(int i = 0; i < split; i++)
				{
					Vec3d vecDir = v.func_72441_c(Utils.RAND.nextGaussian()*scatter, Utils.RAND.nextGaussian()*scatter, Utils.RAND.nextGaussian()*scatter);
					EntityChemthrowerShot chem = new EntityChemthrowerShot(field_145850_b, func_174877_v().func_177958_n()+.5+v.field_72450_a*0.875,func_174877_v().func_177956_o()+1.5+v.field_72448_b*0.875,func_174877_v().func_177952_p()+.5+v.field_72449_c*0.875, 0,0,0, fs);
					chem.field_70159_w = vecDir.field_72450_a*range;
					chem.field_70181_x = vecDir.field_72448_b*range;
					chem.field_70179_y = vecDir.field_72449_c*range;
					if(ignite)
						chem.func_70015_d(10);
					if(!field_145850_b.field_72995_K)
						field_145850_b.func_72838_d(chem);
				}
				if(tick%4==0)
					if(ignite)
						field_145850_b.func_184133_a(null, func_174877_v(), IESounds.sprayFire, SoundCategory.BLOCKS, .5F,1.5F);
					else
						field_145850_b.func_184133_a(null, func_174877_v(), IESounds.spray, SoundCategory.BLOCKS, .5F,.75F);
			}
		}
	}


	@Override
	public void receiveMessageFromClient(NBTTagCompound message)
	{
		super.receiveMessageFromClient(message);
		if(message.func_74764_b("ignite"))
			ignite = message.func_74767_n("ignite");
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		tank.readFromNBT(nbt.func_74775_l("tank"));
		ignite = nbt.func_74767_n("ignite");
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		nbt.func_74782_a("tank", tank.writeToNBT(new NBTTagCompound()));
		nbt.func_74757_a("ignite", ignite);
	}

	@Override
	public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing)
	{
		if(!dummy && capability==CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing==null||facing==EnumFacing.DOWN||facing==this.facing.func_176734_d()))
			return true;
		return super.hasCapability(capability, facing);
	}
	@Override
	public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing)
	{
		if(!dummy && capability==CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing==null||facing==EnumFacing.DOWN||facing==this.facing.func_176734_d()))
			return (T)tank;
		return super.getCapability(capability, facing);
	}
}
