/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums.SideConfig;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.*;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper.IEForgeEnergyWrapper;
import blusunrize.immersiveengineering.common.util.EnergyHelper.IIEInternalFluxHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public abstract class TileEntityTurret extends TileEntityIEBase implements ITickable, IIEInternalFluxHandler, IIEInventory, IHasDummyBlocks, ITileDrop, IDirectionalTile, IBlockBounds, IGuiTile, IEntityProof, IHammerInteraction, IHasObjProperty
{
	public boolean dummy = false;
	public FluxStorage energyStorage = new FluxStorage(16000);
	public boolean redstoneControlInverted = false;
	public EnumFacing facing = EnumFacing.NORTH;

	public String owner;
	public List<String> targetList = new ArrayList<>();
	public boolean whitelist = false;
	public boolean attackAnimals = false;
	public boolean attackPlayers = false;
	public boolean attackNeutrals = false;

	protected int tick = 0;
	protected EntityLivingBase target;
	public float rotationYaw;
	public float rotationPitch;

	private UUID targetId;

	@Override
	public void func_73660_a()
	{
		ApiUtils.checkForNeedlessTicking(this);
		if(dummy)
			return;
		double range = getRange();
		if (targetId!=null)
		{
			AxisAlignedBB validBox = Block.field_185505_j.func_186670_a(field_174879_c).func_186662_g(range);
			List<EntityLivingBase> entities = field_145850_b.func_72872_a(EntityLivingBase.class, validBox);
			for (EntityLivingBase entity:entities)
				if (entity.func_110124_au().equals(targetId)&&isValidTarget(entity))
				{
					target = entity;
					break;
				}
			targetId = null;
		}

		if(target!=null)
		{
			double dX = target.field_70165_t-(func_174877_v().func_177958_n()+.5);
			double dY = target.field_70163_u-(func_174877_v().func_177956_o()+.5);
			double dZ = target.field_70161_v-(func_174877_v().func_177952_p()+.5);
			double dSq = dX*dX+dY*dY+dZ*dZ;
			if(dSq > range*range)
				this.target=null;
			else
			if(field_145850_b.field_72995_K)
			{
				float facingYaw = facing==EnumFacing.NORTH?180: facing==EnumFacing.WEST?-90: facing==EnumFacing.EAST?90: 0;
				double yaw = (MathHelper.func_181159_b(dX, dZ)*(180/Math.PI))-facingYaw;
				this.rotationPitch = (float)(Math.atan2(Math.sqrt(dZ*dZ+dX*dX), dY)*(180/Math.PI))-90;
				if(this.rotationYaw==0)//moving from default
					this.rotationYaw = (float)(yaw*.5);
				else
					this.rotationYaw = (float)yaw;
			}
		}
		else if(field_145850_b.field_72995_K)
		{
			this.rotationYaw*=.75;
			if(Math.abs(rotationYaw)<10)
				this.rotationYaw = 0;
			this.rotationPitch*=.75;
			if(Math.abs(rotationPitch)<10)
				this.rotationPitch = 0;
		}


		if(field_145850_b.field_72995_K)
			return;
		if(field_145850_b.func_82737_E()%64==((func_174877_v().func_177958_n()^func_174877_v().func_177952_p())&63))
			markContainingBlockForUpdate(null);

		int energy = IEConfig.Machines.turret_consumption;
		if(field_145850_b.func_175687_A(func_174877_v())>0^redstoneControlInverted)
		{
			if(energyStorage.extractEnergy(energy, true)==energy)
			{
				energyStorage.extractEnergy(energy, false);
				if(target==null||target.field_70128_L||field_145850_b.func_73045_a(target.func_145782_y())==null||target.func_110143_aJ() <= 0||!canSeeEntity(target))
				{
					target = getTarget();
					if(target!=null)
					{
						this.func_70296_d();
						markContainingBlockForUpdate(null);
					}
				}

				//has target, Redstone control check and has power+ammo
				if(target!=null&&canActivate())
				{
					tick++;
					int chargeup = getChargeupTicks();
					if(tick==chargeup)
						this.activate();
					else if(tick > chargeup)
					{
						if(loopActivation())
							this.activate();
						else if(tick==chargeup+getActiveTicks())
							tick = 0;
					}
				} else
					tick = 0;
			}
		}
		else if(target!=null)
			target=null;
	}

	private boolean canSeeEntity(EntityLivingBase entity)
	{
		return Utils.rayTraceForFirst(new Vec3d(func_174877_v().func_177958_n()+.5, func_174877_v().func_177956_o()+1.375, func_174877_v().func_177952_p()+.5), new Vec3d(entity.field_70165_t, entity.field_70163_u+entity.func_70047_e(), entity.field_70161_v), field_145850_b, Collections.singleton(func_174877_v().func_177984_a()))==null;
//		return this.world.rayTraceBlocks(, false, true, false)==null;
	}

	private EntityLivingBase getTarget()
	{
		double range = getRange();
		List<EntityLivingBase> list = field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(func_174877_v().func_177958_n()-range,func_174877_v().func_177956_o(),func_174877_v().func_177952_p()-range, func_174877_v().func_177958_n()+range,func_174877_v().func_177956_o()+3,func_174877_v().func_177952_p()+range));
		if(list.isEmpty())
			return null;
		for(EntityLivingBase entity : list)
			if (isValidTarget(entity))
				return entity;
		return null;
	}
	public boolean isValidTarget(EntityLivingBase entity)
	{
		if(entity==null || entity.field_70128_L || entity.func_110143_aJ()<=0 || !canSeeEntity(entity))
			return false;
		//Continue if blacklist and name is in list, or whitelist and name is not in list
		if(whitelist ^ isListedName(targetList, entity.func_70005_c_()))
			return false;
		//Same as above but for the owner of the pet, to prevent shooting wolves
		if(entity instanceof IEntityOwnable)
		{
			Entity entityOwner = ((IEntityOwnable)entity).func_70902_q();
			if(entityOwner!=null&&(whitelist ^ isListedName(targetList, entityOwner.func_70005_c_())))
				return false;
		}

		if(entity instanceof EntityAnimal && !attackAnimals)
			return false;
		if(entity instanceof EntityPlayer && !attackPlayers)
			return false;
		if(!(entity instanceof EntityPlayer) && !(entity instanceof EntityAnimal) && !entity.isCreatureType(EnumCreatureType.MONSTER, false) && !attackNeutrals)
			return false;

		return target==null || entity.func_174818_b(func_174877_v())<target.func_174818_b(func_174877_v());
	}
	private boolean isListedName(List<String> list, String name)
	{
		for(String s : list)
			if(s!=null && s.equalsIgnoreCase(name))
				return true;
		return false;
	}

	protected abstract double getRange();
	protected abstract boolean canActivate();
	protected abstract int getChargeupTicks();
	protected abstract int getActiveTicks();
	protected abstract boolean loopActivation();
	protected abstract void activate();

	protected boolean hasOwnerRights(EntityPlayer player)
	{
		if(player.field_71075_bZ.field_75098_d || owner==null || owner.isEmpty())
			return true;
		return owner.equalsIgnoreCase(player.func_70005_c_());
	}

	@Override
	public void receiveMessageFromClient(NBTTagCompound message)
	{
		if(message.func_74764_b("add"))
			targetList.add(message.func_74779_i("add"));
		if(message.func_74764_b("remove"))
			targetList.remove(message.func_74762_e("remove"));
		if(message.func_74764_b("whitelist"))
			whitelist = message.func_74767_n("whitelist");
		if(message.func_74764_b("attackAnimals"))
			attackAnimals = message.func_74767_n("attackAnimals");
		if(message.func_74764_b("attackPlayers"))
			attackPlayers = message.func_74767_n("attackPlayers");
		if(message.func_74764_b("attackNeutrals"))
			attackNeutrals = message.func_74767_n("attackNeutrals");
		this.func_70296_d();
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		dummy = nbt.func_74767_n("dummy");
		redstoneControlInverted = nbt.func_74767_n("redstoneInverted");
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
		energyStorage.readFromNBT(nbt);

		if(nbt.func_74764_b("owner"))
			owner = nbt.func_74779_i("owner");
		NBTTagList list = nbt.func_150295_c("targetList", 8);
		targetList.clear();
		for(int i=0; i<list.func_74745_c(); i++)
			targetList.add(list.func_150307_f(i));
		whitelist = nbt.func_74767_n("whitelist");
		attackAnimals = nbt.func_74767_n("attackAnimals");
		attackPlayers = nbt.func_74767_n("attackPlayers");
		attackNeutrals = nbt.func_74767_n("attackNeutrals");

		target = null;
		if(nbt.func_150297_b("target", 8))
			targetId = UUID.fromString(nbt.func_74779_i("target"));
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74757_a("dummy", dummy);
		nbt.func_74757_a("redstoneInverted", redstoneControlInverted);
		if(facing!=null)
			nbt.func_74768_a("facing", facing.ordinal());
		energyStorage.writeToNBT(nbt);

		if(owner!=null)
			nbt.func_74778_a("owner", owner);
		NBTTagList list = new NBTTagList();
		for(String s : targetList)
			list.func_74742_a(new NBTTagString(s));
		nbt.func_74782_a("targetList", list);
		nbt.func_74757_a("whitelist",whitelist);
		nbt.func_74757_a("attackAnimals",attackAnimals);
		nbt.func_74757_a("attackPlayers",attackPlayers);
		nbt.func_74757_a("attackNeutrals",attackNeutrals);

		if(target!=null)
			nbt.func_74778_a("target", target.func_110124_au().toString());
	}

	@Override
	public float[] getBlockBounds()
	{
		if(!dummy)
			return null;
		switch(facing)
		{
			case NORTH:
				return new float[]{.125f,.0625f,.125f, .875f,.875f,1};
			case SOUTH:
				return new float[]{.125f,.0625f,0, .875f,.875f,.875f};
			case WEST:
				return new float[]{.125f,.0625f,.125f, 1,.875f,.875f};
			case EAST:
				return new float[]{0,.0625f,.125f, .875f,.875f,.875f};
		}
		return null;
	}

	AxisAlignedBB renderBB;
	@Override
	@SideOnly(Side.CLIENT)
	public AxisAlignedBB getRenderBoundingBox()
	{
		if(renderBB==null)
			renderBB = new AxisAlignedBB(func_174877_v().func_177982_a(-8,-8,-8),func_174877_v().func_177982_a(8,8,8));
		return renderBB;
	}

	@Override
	public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ)
	{
		if(dummy)
		{
			TileEntity te = field_145850_b.func_175625_s(func_174877_v().func_177977_b());
			if(te instanceof TileEntityTurret)
				return ((TileEntityTurret)te).hammerUseSide(side, player, hitX, hitY, hitZ);
			return false;
		}
		if(player.func_70093_af())
		{
			redstoneControlInverted = !redstoneControlInverted;
			ChatUtils.sendServerNoSpamMessages(player, new TextComponentTranslation(Lib.CHAT_INFO+"rsControl."+(redstoneControlInverted?"invertedOn":"invertedOff")));
			func_70296_d();
			this.markContainingBlockForUpdate(null);
		}
		return true;
	}

	@Override
	public NonNullList<ItemStack> getInventory()
	{
		return NonNullList.func_191196_a();
	}
	@Override
	public boolean isStackValid(int slot, ItemStack stack)
	{
		return true;
	}
	@Override
	public int getSlotLimit(int slot)
	{
		return 64;
	}
	@Override
	public void doGraphicalUpdates(int slot)
	{
	}

	@Override
	public boolean canOpenGui(EntityPlayer player)
	{
		if(hasOwnerRights(player))
			return true;
		ChatUtils.sendServerNoSpamMessages(player, new TextComponentTranslation(Lib.CHAT_INFO+"notOwner", owner));
		return false;
	}
	@Override
	public boolean canOpenGui()
	{
		return false;
	}
	@Override
	public int getGuiID()
	{
		return Lib.GUIID_Turret;
	}
	@Override
	public TileEntity getGuiMaster()
	{
		if(!dummy)
			return this;
		TileEntity te = field_145850_b.func_175625_s(func_174877_v().func_177977_b());
		if(te instanceof TileEntityTurret)
			return te;
		return null;
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}
	@Override
	public int getFacingLimitation()
	{
		return 2;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return false;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return false;
	}

	@Override
	public boolean canEntityDestroy(Entity entity)
	{
		if(dummy)
		{
			TileEntity te = field_145850_b.func_175625_s(func_174877_v().func_177977_b());
			if(te instanceof TileEntityTurret)
				return ((TileEntityTurret)te).canEntityDestroy(entity);
		}
		if(entity instanceof EntityPlayer)
			return hasOwnerRights((EntityPlayer)entity);
		return true;
	}

	@Override
	public boolean isDummy()
	{
		return dummy;
	}
	@Override
	public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		field_145850_b.func_175656_a(pos.func_177984_a(), state);
		((TileEntityTurret)field_145850_b.func_175625_s(pos.func_177984_a())).dummy = true;
		((TileEntityTurret)field_145850_b.func_175625_s(pos.func_177984_a())).facing = facing;
	}
	@Override
	public void breakDummies(BlockPos pos, IBlockState state)
	{
		if(field_145850_b.func_175625_s(dummy?func_174877_v().func_177977_b():func_174877_v().func_177984_a()) instanceof TileEntityTurret)
			field_145850_b.func_175698_g(dummy?func_174877_v().func_177977_b():func_174877_v().func_177984_a());
	}

	@Override
	public ItemStack getTileDrop(EntityPlayer player, IBlockState state)
	{
		ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
		TileEntityTurret turret = this;
		if(dummy)
		{
			TileEntity t = field_145850_b.func_175625_s(func_174877_v().func_177977_b());
			if(t instanceof TileEntityTurret)
				turret = (TileEntityTurret)t;
			else
				return stack;
		}

		NBTTagCompound tag = new NBTTagCompound();
		//Only writing values when they are different from defaults
		if(turret.owner!=null && (player==null || !player.func_70005_c_().equalsIgnoreCase(turret.owner)))
			tag.func_74778_a("owner", turret.owner);
		if(turret.targetList.size()!=1 || !isListedName(turret.targetList, turret.owner))
		{
			NBTTagList list = new NBTTagList();
			for(String s : turret.targetList)
				list.func_74742_a(new NBTTagString(s));
			tag.func_74782_a("targetList",list);
		}
		if(turret.whitelist)
			tag.func_74757_a("whitelist",turret.whitelist);
		if(turret.attackAnimals)
			tag.func_74757_a("attackAnimals",turret.attackAnimals);
		if(!turret.attackPlayers)
			tag.func_74757_a("attackPlayers",turret.attackPlayers);
		if(turret.attackNeutrals)
			tag.func_74757_a("attackNeutrals",turret.attackNeutrals);
		if(turret.redstoneControlInverted)
			tag.func_74757_a("redstoneControlInverted",turret.redstoneControlInverted);

		if(!tag.func_82582_d())
			stack.func_77982_d(tag);
		return stack;
	}
	@Override
	public void readOnPlacement(@Nullable EntityLivingBase placer, ItemStack stack)
	{
		if(stack.func_77942_o())
		{
			NBTTagCompound tag = stack.func_77978_p();
			if(tag.func_74764_b("owner"))
				this.owner = tag.func_74779_i("owner");
			else if(placer!=null)
				this.owner = placer.func_70005_c_();
			if(tag.func_74764_b("targetList"))
			{
				NBTTagList list = tag.func_150295_c("targetList", 8);
				targetList.clear();
				for(int i=0; i<list.func_74745_c(); i++)
					targetList.add(list.func_150307_f(i));
			}
			else if(owner!=null)
				targetList.add(owner);
			if(tag.func_74764_b("whitelist"))
				whitelist = tag.func_74767_n("whitelist");
			if(tag.func_74764_b("attackAnimals"))
				attackAnimals = tag.func_74767_n("attackAnimals");
			if(tag.func_74764_b("attackPlayers"))
				attackPlayers = tag.func_74767_n("attackPlayers");
			if(tag.func_74764_b("attackNeutrals"))
				attackNeutrals = tag.func_74767_n("attackNeutrals");
			if(tag.func_74764_b("redstoneControlInverted"))
				redstoneControlInverted = tag.func_74767_n("redstoneControlInverted");
		}
		else if(placer!=null)
		{
			this.owner = placer.func_70005_c_();
			targetList.add(owner);
		}
	}

	@Nonnull
	@Override
	public FluxStorage getFluxStorage()
	{
		if(dummy)
		{
			TileEntity te = field_145850_b.func_175625_s(func_174877_v().func_177977_b());
			if(te instanceof TileEntityTurret)
				return ((TileEntityTurret)te).getFluxStorage();
		}
		return energyStorage;
	}
	@Nonnull
	@Override
	public SideConfig getEnergySideConfig(EnumFacing facing)
	{
		return !dummy?SideConfig.INPUT:SideConfig.NONE;
	}
	IEForgeEnergyWrapper[] wrappers = IEForgeEnergyWrapper.getDefaultWrapperArray(this);
	@Override
	public IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing)
	{
		if(!dummy)
			return wrappers[facing==null?0:facing.ordinal()];
		return null;
	}

	static ArrayList<String> displayList = Lists.newArrayList("base");
	@Override
	public ArrayList<String> compileDisplayList()
	{
		return displayList;
	}
}
