/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums.SideConfig;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IBlockBounds;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IDirectionalTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IHammerInteraction;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IHasDummyBlocks;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.*;
import blusunrize.immersiveengineering.common.util.EnergyHelper.IEForgeEnergyWrapper;
import blusunrize.immersiveengineering.common.util.EnergyHelper.IIEInternalFluxHandler;
import blusunrize.immersiveengineering.common.util.IEDamageSources.TeslaDamageSource;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.ArrayListMultimap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class TileEntityTeslaCoil extends TileEntityIEBase implements ITickable, IIEInternalFluxHandler, IHasDummyBlocks, IDirectionalTile, IBlockBounds, IHammerInteraction
{
	public boolean dummy = false;
	public FluxStorage energyStorage = new FluxStorage(48000);
	public boolean redstoneControlInverted = false;
	public EnumFacing facing = EnumFacing.UP;
	public boolean lowPower = false;
	private Vec3d soundPos = null;
	@SideOnly(Side.CLIENT)
	public static ArrayListMultimap<BlockPos,LightningAnimation> effectMap;

	@Override
	public void func_73660_a()
	{
		ApiUtils.checkForNeedlessTicking(this);
		if(dummy)
			return;
		synchronized (this)
		{
			if (field_145850_b.field_72995_K && soundPos!=null)
			{
				field_145850_b.func_184134_a(soundPos.field_72450_a,soundPos.field_72448_b,soundPos.field_72449_c, IESounds.tesla, SoundCategory.BLOCKS, 2.5F,0.5F+ Utils.RAND.nextFloat(), true);
				soundPos = null;
			}
		}
		if (field_145850_b.field_72995_K && effectMap.containsKey(field_174879_c))
			effectMap.get(field_174879_c).removeIf(LightningAnimation::tick);

		int timeKey = func_174877_v().func_177958_n()^func_174877_v().func_177952_p();
		int energyDrain = IEConfig.Machines.teslacoil_consumption;
		if (lowPower)
			energyDrain/=2;
		if(field_145850_b.func_82737_E()%32==(timeKey&31) && canRun(energyDrain))
		{
			if(!field_145850_b.field_72995_K)
				this.energyStorage.extractEnergy(energyDrain,false);

			double radius = 6;
			if (lowPower)
				radius/=2;
			AxisAlignedBB aabbSmall = new AxisAlignedBB(func_174877_v().func_177958_n()+.5-radius,func_174877_v().func_177956_o()+.5-radius,func_174877_v().func_177952_p()+.5-radius, func_174877_v().func_177958_n()+.5+radius,func_174877_v().func_177956_o()+.5+radius,func_174877_v().func_177952_p()+.5+radius);
			AxisAlignedBB aabb = aabbSmall.func_186662_g(radius/2);
			List<Entity> targetsAll = field_145850_b.func_72872_a(Entity.class, aabb);
			if (!field_145850_b.field_72995_K)
				for (Entity e:targetsAll)
					if (e instanceof ITeslaEntity)
						((ITeslaEntity) e).onHit(this, lowPower);
			List<Entity> targets = targetsAll.stream().filter((e)->(e instanceof EntityLivingBase&&aabbSmall.func_72326_a(e.func_174813_aQ()))).collect(Collectors.toList());
			if(!targets.isEmpty())
			{
				TeslaDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(IEConfig.Machines.teslacoil_damage, lowPower);
				int randomTarget = Utils.RAND.nextInt(targets.size());
				EntityLivingBase target = (EntityLivingBase) targets.get(randomTarget);
				if(target!=null)
				{
					if(!field_145850_b.field_72995_K)
					{
						energyDrain = IEConfig.Machines.teslacoil_consumption_active;
						if (lowPower)
							energyDrain/=2;
						if(energyStorage.extractEnergy(energyDrain,true)==energyDrain)
						{
							energyStorage.extractEnergy(energyDrain,false);
							if (dmgsrc.apply(target))
							{
								int prevFire = target.field_190534_ay;
								target.field_190534_ay = 1;
								target.func_70690_d(new PotionEffect(IEPotions.stunned,128));
								target.field_190534_ay = prevFire;
							}
							this.sendRenderPacket(target);
						}
					}
				}
			}
			else if(!field_145850_b.field_72995_K && field_145850_b.func_82737_E()%128==(timeKey&127))
			{
				//target up to 4 blocks away
				double tV = (Utils.RAND.nextDouble()-.5)*8;
				double tH = (Utils.RAND.nextDouble()-.5)*8;
				if (lowPower)
				{
					tV/=2;
					tH/=2;
				}
				//Minimal distance to the coil is 2 blocks
				tV += tV<0?-2:2;
				tH += tH<0?-2:2;

				BlockPos targetBlock = func_174877_v().func_177963_a(facing.func_176740_k()==Axis.X?0:tH, facing.func_176740_k()==Axis.Y?0:tV, facing.func_176740_k()==Axis.Y?tV:facing.func_176740_k()==Axis.X?tH:0);
				double tL=0;
				boolean targetFound = false;
				if(!field_145850_b.func_175623_d(targetBlock))
				{
					IBlockState state = field_145850_b.func_180495_p(targetBlock);
					AxisAlignedBB blockBounds = state.func_185900_c(field_145850_b, targetBlock);
					//					ty = (blockY-getPos().getY())+state.getBlock().getBlockBoundsMaxY();
					if(facing==EnumFacing.UP)
						tL = targetBlock.func_177956_o()-func_174877_v().func_177956_o() + blockBounds.field_72337_e;
					else if(facing==EnumFacing.DOWN)
						tL = targetBlock.func_177956_o()-func_174877_v().func_177956_o() + blockBounds.field_72338_b;
					else if(facing==EnumFacing.NORTH)
						tL = targetBlock.func_177952_p()-func_174877_v().func_177952_p() + blockBounds.field_72339_c;
					else if(facing==EnumFacing.SOUTH)
						tL = targetBlock.func_177952_p()-func_174877_v().func_177952_p() + blockBounds.field_72334_f;
					else if(facing==EnumFacing.WEST)
						tL = targetBlock.func_177958_n()-func_174877_v().func_177958_n() + blockBounds.field_72340_a;
					else
						tL = targetBlock.func_177958_n()-func_174877_v().func_177958_n() + blockBounds.field_72336_d;
					targetFound = true;
				}
				else
				{
					boolean positiveFirst = Utils.RAND.nextBoolean();
					for(int i=0; i<2; i++)
					{
						for(int ll=0;ll<=6;ll++)
						{
							BlockPos targetBlock2 = targetBlock.func_177967_a(positiveFirst?facing:facing.func_176734_d(), ll);
							if(!field_145850_b.func_175623_d(targetBlock2))
							{
								IBlockState state = field_145850_b.func_180495_p(targetBlock2);
								AxisAlignedBB blockBounds = state.func_185900_c(field_145850_b, targetBlock2);
								tL = facing.func_176740_k()==Axis.Y?(targetBlock2.func_177956_o()-func_174877_v().func_177956_o()): facing.func_176740_k()==Axis.Z?(targetBlock2.func_177952_p()-func_174877_v().func_177952_p()): (targetBlock2.func_177952_p()-func_174877_v().func_177952_p());
								EnumFacing tempF = positiveFirst?facing:facing.func_176734_d();
								if(tempF==EnumFacing.UP)
									tL += blockBounds.field_72337_e;
								else if(tempF==EnumFacing.DOWN)
									tL += blockBounds.field_72338_b;
								else if(tempF==EnumFacing.NORTH)
									tL += blockBounds.field_72339_c;
								else if(tempF==EnumFacing.SOUTH)
									tL += blockBounds.field_72334_f;
								else if(tempF==EnumFacing.WEST)
									tL += blockBounds.field_72340_a;
								else
									tL += blockBounds.field_72336_d;
								targetFound = true;
								break;
							}
						}
						if(targetFound)
							break;
						positiveFirst = !positiveFirst;
					}
				}
				if (targetFound)
					sendFreePacket(tL, tH, tV);
			}
			this.func_70296_d();
		}
	}

	protected void sendRenderPacket(Entity target)
	{
		NBTTagCompound tag = new NBTTagCompound();
		tag.func_74768_a("targetEntity", target.func_145782_y());
		ImmersiveEngineering.packetHandler.sendToAll(new MessageTileSync(this, tag));
	}

	protected void sendFreePacket(double tL, double tH, double tV)
	{
		NBTTagCompound tag = new NBTTagCompound();
		tag.func_74780_a("tL", tL);
		tag.func_74780_a("tV", tV);
		tag.func_74780_a("tH", tH);
		ImmersiveEngineering.packetHandler.sendToAll(new MessageTileSync(this, tag));
	}

	@Override
	public void receiveMessageFromServer(NBTTagCompound message)
	{
		if(message.func_74764_b("targetEntity"))
		{
			Entity target = field_145850_b.func_73045_a(message.func_74762_e("targetEntity"));
			if(target instanceof EntityLivingBase)
			{
				double dx = target.field_70165_t-func_174877_v().func_177958_n();
				double dy = target.field_70163_u-func_174877_v().func_177956_o();
				double dz = target.field_70161_v-func_174877_v().func_177952_p();

				EnumFacing f = null;
				if(facing.func_176740_k()==Axis.Y)
				{
					if(Math.abs(dz)>Math.abs(dx))
						f = dz<0?EnumFacing.NORTH:EnumFacing.SOUTH;
					else 
						f = dx<0?EnumFacing.WEST:EnumFacing.EAST;
				}
				else if(facing.func_176740_k()==Axis.Z)
				{
					if(Math.abs(dy)>Math.abs(dx))
						f = dy<0?EnumFacing.DOWN:EnumFacing.UP;
					else 
						f = dx<0?EnumFacing.WEST:EnumFacing.EAST;
				}
				else
				{
					if(Math.abs(dy)>Math.abs(dz))
						f = dy<0?EnumFacing.DOWN:EnumFacing.UP;
					else 
						f = dz<0?EnumFacing.NORTH:EnumFacing.SOUTH;
				}
				double verticalOffset = 1+Utils.RAND.nextDouble()*.25;
				Vec3d coilPos = new Vec3d(func_174877_v()).func_72441_c(.5,.5,.5);
				//Vertical offset
				coilPos = coilPos.func_72441_c(facing.func_82601_c()*verticalOffset, facing.func_96559_d()*verticalOffset, facing.func_82599_e()*verticalOffset);
				//offset to direction
				if(f!=null)
				{
					coilPos = coilPos.func_72441_c(f.func_82601_c()*.375, f.func_96559_d()*.375, f.func_82599_e()*.375);
					//random side offset
					f = f.func_176732_a(facing.func_176740_k());
					double dShift = (Utils.RAND.nextDouble()-.5)*.75;
					coilPos = coilPos.func_72441_c(f.func_82601_c()*dShift, f.func_96559_d()*dShift, f.func_82599_e()*dShift);
				}

				addAnimation(new LightningAnimation(coilPos,(EntityLivingBase)target));
				synchronized (this)
				{
					soundPos = coilPos;
				}
			}
		} else if (message.func_74764_b("tL"))
			initFreeStreamer(message.func_74769_h("tL"), message.func_74769_h("tV"), message.func_74769_h("tH"));
	}

	public void initFreeStreamer(double tL, double tV, double tH) {
		double tx = facing.func_176740_k()==Axis.X?tL:tH;
		double ty = facing.func_176740_k()==Axis.Y?tL:tV;
		double tz = facing.func_176740_k()==Axis.Y?tV:facing.func_176740_k()==Axis.X?tH:tL;

		EnumFacing f = null;
		if(facing.func_176740_k()==Axis.Y)
		{
			if(Math.abs(tz)>Math.abs(tx))
				f = tz<0?EnumFacing.NORTH:EnumFacing.SOUTH;
			else
				f = tx<0?EnumFacing.WEST:EnumFacing.EAST;
		}
		else if(facing.func_176740_k()==Axis.Z)
		{
			if(Math.abs(ty)>Math.abs(tx))
				f = ty<0?EnumFacing.DOWN:EnumFacing.UP;
			else
				f = tx<0?EnumFacing.WEST:EnumFacing.EAST;
		}
		else
		{
			if(Math.abs(ty)>Math.abs(tz))
				f = ty<0?EnumFacing.DOWN:EnumFacing.UP;
			else
				f = tz<0?EnumFacing.NORTH:EnumFacing.SOUTH;
		}

		double verticalOffset = 1+Utils.RAND.nextDouble()*.25;
		Vec3d coilPos = new Vec3d(func_174877_v()).func_72441_c(.5,.5,.5);
		//Vertical offset
		coilPos = coilPos.func_72441_c(facing.func_82601_c()*verticalOffset, facing.func_96559_d()*verticalOffset, facing.func_82599_e()*verticalOffset);
		//offset to direction
		coilPos = coilPos.func_72441_c(f.func_82601_c()*.375, f.func_96559_d()*.375, f.func_82599_e()*.375);
		//random side offset
		f = f.func_176732_a(facing.func_176740_k());
		double dShift = (Utils.RAND.nextDouble()-.5)*.75;
		coilPos = coilPos.func_72441_c(f.func_82601_c()*dShift, f.func_96559_d()*dShift, f.func_82599_e()*dShift);
		addAnimation(new LightningAnimation(coilPos, new Vec3d(func_174877_v()).func_72441_c(tx,ty,tz)));
//		world.playSound(null, getPos(), IESounds.tesla, SoundCategory.BLOCKS,2.5f, .5f + Utils.RAND.nextFloat());
		field_145850_b.func_184134_a(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p(), IESounds.tesla, SoundCategory.BLOCKS, 2.5F,0.5F+ Utils.RAND.nextFloat(), true);
	}

	private void addAnimation(LightningAnimation ani)
	{
		Minecraft.func_71410_x().func_152343_a(()->effectMap.put(func_174877_v(),ani));
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		dummy = nbt.func_74767_n("dummy");
		redstoneControlInverted = nbt.func_74767_n("redstoneInverted");
		lowPower = nbt.func_74767_n("lowPower");
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
		energyStorage.readFromNBT(nbt);
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74757_a("dummy", dummy);
		nbt.func_74757_a("redstoneInverted", redstoneControlInverted);
		nbt.func_74757_a("lowPower", lowPower);
		if(facing!=null)
			nbt.func_74768_a("facing", facing.ordinal());
		energyStorage.writeToNBT(nbt);
	}

	@Override
	public float[] getBlockBounds()
	{
		if(!dummy)
			return null;
		switch(facing)
		{
		case DOWN:
			return new float[]{.125f,.125f,.125f, .875f,1,.875f};
		case UP:
			return new float[]{.125f,0,.125f, .875f,.875f,.875f};
		case NORTH:
			return new float[]{.125f,.125f,.125f, .875f,.875f,1};
		case SOUTH:
			return new float[]{.125f,.125f,0, .875f,.875f,.875f};
		case WEST:
			return new float[]{.125f,.125f,.125f, 1,.875f,.875f};
		case EAST:
			return new float[]{0,.125f,.125f, .875f,.875f,.875f};
		}
		return null;
	}

	AxisAlignedBB renderBB;
	@Override
	@SideOnly(Side.CLIENT)
	public AxisAlignedBB getRenderBoundingBox()
	{
		if(renderBB==null)
			renderBB = new AxisAlignedBB(func_174877_v().func_177982_a(-8,-8,-8),func_174877_v().func_177982_a(8,8,8));
		return renderBB;
	}

	@Override
	public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ)
	{
		if(dummy)
		{
			TileEntity te = field_145850_b.func_175625_s(func_174877_v().func_177967_a(facing,-1));
			if(te instanceof TileEntityTeslaCoil)
				return ((TileEntityTeslaCoil)te).hammerUseSide(side, player, hitX, hitY, hitZ);
			return false;
		}
		if (player.func_70093_af())
		{
			int energyDrain = IEConfig.Machines.teslacoil_consumption;
			if (lowPower)
				energyDrain/=2;
			if (canRun(energyDrain))
				player.func_70097_a(IEDamageSources.causeTeslaPrimaryDamage(), Float.MAX_VALUE);
			else
			{
				lowPower = !lowPower;
				ChatUtils.sendServerNoSpamMessages(player, new TextComponentTranslation(Lib.CHAT_INFO+"tesla."+(lowPower?"lowPower":"highPower")));
				func_70296_d();
			}
		}
		else
		{
			redstoneControlInverted = !redstoneControlInverted;
			ChatUtils.sendServerNoSpamMessages(player, new TextComponentTranslation(Lib.CHAT_INFO+"rsControl."+(redstoneControlInverted?"invertedOn":"invertedOff")));
			func_70296_d();
			this.markContainingBlockForUpdate(null);
		}
		return true;
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}
	@Override
	public int getFacingLimitation()
	{
		return 0;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return false;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return false;
	}

	@Override
	public boolean isDummy()
	{
		return dummy;
	}
	@Override
	public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		field_145850_b.func_175656_a(pos.func_177972_a(facing), state);
		((TileEntityTeslaCoil)field_145850_b.func_175625_s(pos.func_177972_a(facing))).dummy = true;
		((TileEntityTeslaCoil)field_145850_b.func_175625_s(pos.func_177972_a(facing))).facing = facing;
	}
	@Override
	public void breakDummies(BlockPos pos, IBlockState state)
	{
		for(int i=0; i<=1; i++)
			if(field_145850_b.func_175625_s(func_174877_v().func_177967_a(facing, dummy?-1:0).func_177967_a(facing, i)) instanceof TileEntityTeslaCoil)
				field_145850_b.func_175698_g(func_174877_v().func_177967_a(facing, dummy?-1:0).func_177967_a(facing, i));
	}

	@Nonnull
	@Override
	public FluxStorage getFluxStorage()
	{
		if(dummy)
		{
			TileEntity te = field_145850_b.func_175625_s(func_174877_v().func_177967_a(facing,-1));
			if(te instanceof TileEntityTeslaCoil)
				return ((TileEntityTeslaCoil)te).getFluxStorage();
		}
		return energyStorage;
	}
	@Nonnull
	@Override
	public SideConfig getEnergySideConfig(EnumFacing facing)
	{
		return !dummy?SideConfig.INPUT:SideConfig.NONE;
	}
	IEForgeEnergyWrapper[] wrappers = IEForgeEnergyWrapper.getDefaultWrapperArray(this);
	@Override
	public IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing)
	{
		if(!dummy)
			return wrappers[facing==null?0:facing.ordinal()];
		return null;
	}

	public boolean canRun(int energyDrain)
	{
		return (field_145850_b.func_175687_A(func_174877_v())>0^redstoneControlInverted) && energyStorage.getEnergyStored()>=energyDrain;
	}

	public static class LightningAnimation
	{
		public Vec3d startPos;
		public EntityLivingBase targetEntity;
		public Vec3d targetPos;
		private int lifeTimer = 20;
		private final int ANIMATION_MAX = 4;
		private int animationTimer = ANIMATION_MAX;

		public List<Vec3d> subPoints = new ArrayList<>();
		private Vec3d prevTarget;

		public LightningAnimation(Vec3d startPos, EntityLivingBase targetEntity)
		{
			this.startPos = startPos;
			this.targetEntity = targetEntity;
		}
		public LightningAnimation(Vec3d startPos, Vec3d targetPos)
		{
			this.startPos = startPos;
			this.targetPos = targetPos;
		}

		public boolean shoudlRecalculateLightning()
		{
			if (subPoints.isEmpty() || animationTimer == 0)
				return true;
			boolean b = false;
			Vec3d end = targetEntity!=null?targetEntity.func_174791_d():targetPos;
			if(prevTarget!=null)
				b = prevTarget.func_72438_d(end)>1;
			prevTarget = end;
			return b;
		}

		public void createLightning(Random rand)
		{
			subPoints.clear();
			Vec3d end = targetEntity!=null?targetEntity.func_174791_d():targetPos;
			Vec3d dist = end.func_178788_d(startPos);
			double points = 12;
			for(int i=0; i<points; i++)
			{
				Vec3d sub = startPos.func_72441_c(dist.field_72450_a/points*i, dist.field_72448_b/points*i, dist.field_72449_c/points*i);
				//distance to the middle point and by that, distance from the start and end. -1 is start, 1 is end
				double fixPointDist=  (i-points/2)/(points/2);
				//Randomization modifier, closer to start/end means smaller divergence
				double mod = 1-.75*Math.abs(fixPointDist);
				double offX = (rand.nextDouble()-.5)*mod;
				double offY = (rand.nextDouble()-.5)*mod;
				double offZ = (rand.nextDouble()-.5)*mod;
				if(fixPointDist<0)
				{
					offY+=.75*mod*(.75+fixPointDist);//Closer to the coil should arc upwards
					offX = (sub.field_72450_a-startPos.field_72450_a)<0?-Math.abs(offX):Math.abs(offX);
					offZ = (sub.field_72449_c-startPos.field_72449_c)<0?-Math.abs(offZ):Math.abs(offZ);
				}
				else 
				{
					offY = Math.min(end.field_72448_b+1*(1-fixPointDist)*-Math.signum(dist.field_72448_b), offY);//final points should be higher/lower than end, depending on if lightning goes up or down
					offX = Math.abs(offX)*(end.field_72450_a-sub.field_72450_a);
					offZ = Math.abs(offZ)*(end.field_72449_c-sub.field_72449_c);
				}
				subPoints.add(sub.func_72441_c(offX,offY,offZ));
			}
			animationTimer = ANIMATION_MAX+Utils.RAND.nextInt(5)-2;
		}
		public boolean tick() {
			animationTimer--;
			lifeTimer--;
			return lifeTimer<=0;
		}
	}
}
