/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IComparatorOverride;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntitySilo extends TileEntityMultiblockPart<TileEntitySilo> implements IComparatorOverride //IDeepStorageUnit
{
	public ItemStack identStack = ItemStack.field_190927_a;
	public int storageAmount = 0;
	static int maxStorage = 41472;
	//	ItemStack inputStack;
//	ItemStack outputStack;
//	ItemStack prevInputStack;
//	ItemStack prevOutputStack;
	boolean lockItem = false;
	private int[] oldComps = new int[6];
	private int masterCompOld;
	private boolean forceUpdate = false;

	private static final int[] size = {7, 3, 3};
	public TileEntitySilo() {
		super(size);
	}
	@Override
	public void func_73660_a()
	{
		ApiUtils.checkForNeedlessTicking(this);

		if(pos==4 && !field_145850_b.field_72995_K && !this.identStack.func_190926_b() && storageAmount>0 && field_145850_b.func_175687_A(func_174877_v())>0 && field_145850_b.func_82737_E()%8==0)
		{
			updateComparatorValuesPart1();
			for(EnumFacing f : EnumFacing.values())
				if(f!=EnumFacing.UP)
				{
					TileEntity inventory = Utils.getExistingTileEntity(field_145850_b, func_174877_v().func_177972_a(f));
					ItemStack stack = Utils.copyStackWithAmount(identStack,1);
					stack = Utils.insertStackIntoInventory(inventory, stack, f.func_176734_d());
					if(stack.func_190926_b())
					{
						storageAmount--;
						if(storageAmount<=0)
							identStack = ItemStack.field_190927_a;
						this.func_70296_d();
						markContainingBlockForUpdate(null);
						if(storageAmount<=0)
							break;
					}
				}
			updateComparatorValuesPart2();
		}
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		if(nbt.func_74764_b("identStack"))
		{
			NBTTagCompound t = nbt.func_74775_l("identStack");
			this.identStack = new ItemStack(t);
		}
		else
			this.identStack = ItemStack.field_190927_a;
		storageAmount = nbt.func_74762_e("storageAmount");
		lockItem = nbt.func_74767_n("lockItem");
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		if(!this.identStack.func_190926_b())
		{
			NBTTagCompound t = this.identStack.func_77955_b(new NBTTagCompound());
			nbt.func_74782_a("identStack", t);
		}
		nbt.func_74768_a("storageAmount", storageAmount);
		nbt.func_74757_a("lockItem", lockItem);
	}

	@Override
	protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side)
	{
		return new FluidTank[0];
	}
	@Override
	protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources)
	{
		return false;
	}
	@Override
	protected boolean canDrainTankFrom(int iTank, EnumFacing side)
	{
		return false;
	}

	@Override
	public float[] getBlockBounds()
	{
		if(pos==0||pos==2||pos==6||pos==8)
		{
			float xMin = (facing.func_176740_k() == Axis.X ? (pos > 2 ^ facing == EnumFacing.EAST) : (pos % 3 == 2 ^ facing == EnumFacing.SOUTH)) ? .75f : 0;
			float xMax = (facing.func_176740_k() == Axis.X ? (pos < 3 ^ facing == EnumFacing.EAST) : (pos % 3 == 0 ^ facing == EnumFacing.SOUTH)) ? .25f : 1;
			float zMin = (facing.func_176740_k() == Axis.X ? (pos % 3 == 2 ^ facing == EnumFacing.EAST) : (pos < 3 ^ facing == EnumFacing.SOUTH)) ? .75f : 0;
			float zMax = (facing.func_176740_k() == Axis.X ? (pos % 3 == 0 ^ facing == EnumFacing.EAST) : (pos > 2 ^ facing == EnumFacing.SOUTH)) ? .25f : 1;
			return new float[]{xMin, 0, zMin, xMax, 1, zMax};
		}
		return new float[]{0,0,0,1,1,1};
	}

	@Override
	public ItemStack getOriginalBlock()
	{
		return pos==0||pos==2||pos==6||pos==8?new ItemStack(IEContent.blockWoodenDecoration,1,BlockTypes_WoodenDecoration.FENCE.getMeta()):new ItemStack(IEContent.blockSheetmetal,1,BlockTypes_MetalsAll.IRON.getMeta());
	}

	@Override
	public BlockPos getOrigin()
	{
		return func_174877_v().func_177982_a(-offset[0], -offset[1], -offset[2]).func_177972_a(facing.func_176735_f()).func_177972_a(facing.func_176734_d());
	}
	@SideOnly(Side.CLIENT)
	private AxisAlignedBB renderAABB;
	@Override
	@SideOnly(Side.CLIENT)
	public AxisAlignedBB getRenderBoundingBox()
	{
		if(renderAABB==null)
			if(pos==4)
				renderAABB = new AxisAlignedBB(func_174877_v().func_177982_a(-1,0,-1), func_174877_v().func_177982_a(2,7,2));
			else
				renderAABB = new AxisAlignedBB(func_174877_v(),func_174877_v());
		return renderAABB;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public double func_145833_n()
	{
		return super.func_145833_n()* IEConfig.increasedTileRenderdistance;
	}

	/*
	//DEEP STORAGE
	@Override
	public ItemStack getStoredItemType()
	{
		TileEntitySilo mast = master();
		if (mast!=null)
			return mast.getStoredItemType();
		if(this.identStack != null)
			return Utils.copyStackWithAmount(identStack, storageAmount);
		return null;
	}

	@Override
	public void setStoredItemCount(int amount)
	{
		TileEntitySilo mast = master();
		if (mast!=null)
		{
			mast.setStoredItemCount(amount);
			return;
		}
		updateComparatorValuesPart1();
		if(amount > maxStorage)
			amount = maxStorage;
		this.storageAmount = amount;
		this.forceUpdate = true;
		this.markDirty();
		updateComparatorValuesPart2();
	}

	@Override
	public void setStoredItemType(ItemStack type, int amount)
	{
		TileEntitySilo mast = master();
		if (mast!=null)
		{
			mast.setStoredItemType(type, amount);
			return;
		}
		updateComparatorValuesPart1();
		this.identStack = Utils.copyStackWithAmount(type, 0);
		if(amount > maxStorage)
			amount = maxStorage;
		this.storageAmount = amount;
		this.forceUpdate = true;
		this.markDirty();
		updateComparatorValuesPart2();
	}

	@Override
	public int getMaxStoredCount()
	{
		return maxStorage;
	}
	 */


	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		if((pos==4||pos==58) && capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
			return true;
		//		if(pos>30&&pos<44 && pos%5>0&&pos%5<4 )
		//			return true;
		return super.hasCapability(capability, facing);
	}
	IItemHandler insertionHandler = new SiloInventoryHandler(this);
	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if((pos==4||pos==58) && capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
			return (T)insertionHandler;
		return super.getCapability(capability, facing);
	}

	public static class SiloInventoryHandler implements IItemHandler
	{
		TileEntitySilo silo;
		public SiloInventoryHandler(TileEntitySilo silo)
		{
			this.silo = silo;
		}

		@Override
		public int getSlots()
		{
			return 2;
		}
		@Override
		public ItemStack getStackInSlot(int slot)
		{
			if (slot==0)
				return ItemStack.field_190927_a;
			else
			{
				int maxSize = Math.min(silo.storageAmount, silo.identStack.func_77976_d());
				return ApiUtils.copyStackWithAmount(silo.identStack, maxSize);
			}
		}

		@Override
		public ItemStack insertItem(int slot, ItemStack stack, boolean simulate)
		{
			stack = stack.func_77946_l();
			TileEntitySilo silo = this.silo.master();
			int space = maxStorage-silo.storageAmount;
			if(slot!=0 || space<1 || stack.func_190926_b() || (!silo.identStack.func_190926_b() && !ItemHandlerHelper.canItemStacksStack(silo.identStack,stack)))
				return stack;
			int accepted = Math.min(space, stack.func_190916_E());
			if(!simulate)
			{
				silo.updateComparatorValuesPart1();
				silo.storageAmount += accepted;
				if(silo.identStack.func_190926_b())
					silo.identStack = stack.func_77946_l();
				silo.func_70296_d();
				silo.markContainingBlockForUpdate(null);
				silo.updateComparatorValuesPart2();
			}
			stack.func_190918_g(accepted);
			if(stack.func_190916_E() < 1)
				stack = ItemStack.field_190927_a;
			return stack;
		}

		@Override
		public ItemStack extractItem(int slot, int amount, boolean simulate)
		{
			TileEntitySilo silo = this.silo.master();
			if(slot!=1 || silo.storageAmount<1 || amount<1 || silo.identStack.func_190926_b())
				return ItemStack.field_190927_a;
			ItemStack out;
			if(silo.storageAmount >= amount)
				out = Utils.copyStackWithAmount(silo.identStack, amount);
			else
				out = Utils.copyStackWithAmount(silo.identStack, silo.storageAmount);
			if(!simulate)
			{
				silo.updateComparatorValuesPart1();
				silo.storageAmount -= out.func_190916_E();
				if(silo.storageAmount<=0 && !silo.lockItem)
					silo.identStack = ItemStack.field_190927_a;
				silo.func_70296_d();
				silo.markContainingBlockForUpdate(null);
				silo.updateComparatorValuesPart2();
			}
			return out;
		}

		@Override
		public int getSlotLimit(int slot)
		{
			return 64;
		}
	}

	@Override
	public int getComparatorInputOverride()
	{
		if(pos==4)
			return (15*storageAmount)/maxStorage;
		TileEntitySilo master = master();
		if (offset[1]>=1&&offset[1]<=6&&master!=null) //6 layers of storage
		{
			int layer = offset[1]-1;
			int vol = maxStorage/6;
			int filled = master.storageAmount-layer*vol;
			int ret = Math.min(15, Math.max(0, (15*filled)/vol));
			return ret;
		}
		return 0;
	}
	private void updateComparatorValuesPart1()
	{
		int vol = maxStorage / 6;
		for(int i=0; i<6; i++)
		{
			int filled = storageAmount - i * vol;
			oldComps[i] = Math.min(15, Math.max((15*filled)/vol, 0));
		}
		masterCompOld = (15*storageAmount)/maxStorage;
	}
	private void updateComparatorValuesPart2()
	{
		int vol = maxStorage / 6;
		if((15*storageAmount)/maxStorage!=masterCompOld)
			field_145850_b.func_175685_c(func_174877_v(), func_145838_q(), true);
		for(int i=0; i<6; i++)
		{
			int filled = storageAmount - i * vol;
			int now = Math.min(15, Math.max((15*filled)/vol, 0));
			if(now!=oldComps[i])
			{
				for(int x=-1; x<=1; x++)
					for(int z=-1; z<=1; z++)
					{
						BlockPos pos = func_174877_v().func_177982_a(-offset[0]+x, -offset[1]+i+1, -offset[2]+z);
						field_145850_b.func_175685_c(pos, field_145850_b.func_180495_p(pos).func_177230_c(), true);
					}
			}
		}
	}
}
