/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IDirectionalTile;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Plane;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityLadder extends TileEntityIEBase implements IDirectionalTile
{
	public EnumFacing facing = EnumFacing.NORTH;

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74768_a("facing",facing.ordinal());
	}

	@Override
	public EnumFacing getFacingForPlacement(EntityLivingBase placer, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		World world = placer.func_130014_f_();
		IBlockState state = world.func_180495_p(pos);
		if(state.func_177230_c() instanceof BlockMetalLadder)
		{
			BlockMetalLadder ladder = (BlockMetalLadder)state.func_177230_c();
			if(side.func_176740_k().func_176722_c()&&ladder.canAttachTo(world, pos.func_177972_a(side.func_176734_d()), facing))
				return side;
			else if(ladder.func_176201_c(state)>0)
				return placer.func_184172_bi().func_176734_d();
			else
			{
				for(EnumFacing enumfacing : Plane.HORIZONTAL)
					if(ladder.canAttachTo(world, pos.func_177972_a(enumfacing.func_176734_d()), enumfacing))
						return enumfacing;
			}
		}
		return EnumFacing.NORTH;
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}
	@Override
	public int getFacingLimitation()
	{
		return -1;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return true;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return true;
	}
}
