/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums.SideConfig;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IBlockOverlayText;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IConfigurableSides;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.*;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

import javax.annotation.Nullable;
import java.util.*;

public class TileEntityFluidPlacer extends TileEntityIEBase implements ITickable, IConfigurableSides, IBlockOverlayText
{
	public int[] sideConfig = new int[] {1,0,1,1,1,1};
	public FluidTank tank = new FluidTank(4000);

	private int tickCount = 0;

	HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
	TreeMap<Integer, Queue<BlockPos>> layeredPlacementQueue = new TreeMap<Integer, Queue<BlockPos>>();
	HashSet<BlockPos> tempFluids = new HashSet<BlockPos>();

	@Override
	public void func_73660_a()
	{
		if(func_145831_w().field_72995_K || func_145831_w().func_175687_A(func_174877_v())!=0)
			return;

		if(tickCount%16==0)
		{
			if(tickCount%512==0)//Initial placement
				prepareAreaCheck();
			if(tank.getFluidAmount()>=Fluid.BUCKET_VOLUME && tank.getFluid().getFluid().getBlock()!=null && !layeredPlacementQueue.isEmpty())
			{
				Queue<BlockPos> lowestLayer = layeredPlacementQueue.firstEntry().getValue();
				if(lowestLayer==null || lowestLayer.isEmpty())
					layeredPlacementQueue.pollFirstEntry();
				else
				{
					BlockPos targetPos = lowestLayer.poll();
					IBlockState state = func_145831_w().func_180495_p(targetPos);
					if((state.func_177230_c().isAir(state,func_145831_w(),targetPos) || !state.func_185904_a().func_76220_a()) && !isFullFluidBlock(targetPos, state))
					if(tryPlaceFluid(null, func_145831_w(), tank.getFluid(), targetPos))
					{
						tank.drain(Fluid.BUCKET_VOLUME, true);
						addConnectedSpaces(targetPos);
						handleTempFluids();
					}
				}
			}
		}
		tickCount++;
	}

	//FIXME: Blatantly stolen from Forge. I'm going to do a PR to return this method back to forge, but for now...
	//Forge changed this method to require an ItemStack which isn't appropriate here.
	//Mezz reported he was doing further work in this space for us, we should be able to remove this soon.
	public static boolean tryPlaceFluid(@Nullable EntityPlayer player, World worldIn, FluidStack fluidStack, BlockPos pos)
	{
		if (worldIn == null || fluidStack == null || pos == null)
		{
			return false;
		}

		Fluid fluid = fluidStack.getFluid();
		if (fluid == null || !fluid.canBePlacedInWorld())
		{
			return false;
		}

		// check that we can place the fluid at the destination
		IBlockState destBlockState = worldIn.func_180495_p(pos);
		Material destMaterial = destBlockState.func_185904_a();
		boolean isDestNonSolid = !destMaterial.func_76220_a();
		boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f(worldIn, pos);
		if (!worldIn.func_175623_d(pos) && !isDestNonSolid && !isDestReplaceable)
		{
			return false; // Non-air, solid, unreplacable block. We can't put fluid here.
		}

		if (worldIn.field_73011_w.func_177500_n() && fluid.doesVaporize(fluidStack))
		{
			fluid.vaporize(player, worldIn, pos, fluidStack);
		}
		else
		{
			if (!worldIn.field_72995_K && (isDestNonSolid || isDestReplaceable) && !destMaterial.func_76224_d())
			{
				worldIn.func_175655_b(pos, true);
			}

			SoundEvent soundevent = fluid.getEmptySound(fluidStack);
			worldIn.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0F, 1.0F);

			IBlockState fluidBlockState = fluid.getBlock().func_176223_P();
			worldIn.func_180501_a(pos, fluidBlockState, 11);
		}
		return true;
	}

	private void prepareAreaCheck()
	{
		checkedPositions.clear();
		layeredPlacementQueue.clear();
		tempFluids.clear();

		addConnectedSpaces(func_174877_v());
		handleTempFluids();
	}

	private Queue<BlockPos> getQueueForYLevel(int yLevel)
	{
		Queue<BlockPos> queue = layeredPlacementQueue.get(yLevel);
		if(queue==null)
		{
			queue = new LinkedList<BlockPos>();
			layeredPlacementQueue.put(yLevel, queue);
		}
		return queue;
	}

	private void addConnectedSpaces(BlockPos pos)
	{
		for(EnumFacing facing : EnumFacing.values())
			if(facing!=EnumFacing.UP && (pos!=func_174877_v()||sideConfig[facing.ordinal()]==1))
				addToQueue(pos.func_177972_a(facing));
	}

	private void addToQueue(BlockPos pos)
	{
		if(pos.func_177956_o()>=0 && pos.func_177956_o()<=255)//Within world borders
			if(checkedPositions.add(pos))//Don't add checked positions
				if(pos.func_177951_i(func_174877_v())<64*64)//Within max range
					if(func_145831_w().func_175667_e(pos))
					{
						IBlockState state = func_145831_w().func_180495_p(pos);
						if(tank.getFluid()!=null && tank.getFluid().getFluid()==FluidRegistry.lookupFluidForBlock(state.func_177230_c()))
							tempFluids.add(pos);
						if((state.func_177230_c().isAir(state,func_145831_w(),pos) || !state.func_185904_a().func_76220_a()) && !isFullFluidBlock(pos, state))
							getQueueForYLevel(pos.func_177956_o()).add(pos);
					}
	}

	private void handleTempFluids()
	{
		Set<BlockPos> tempFluidsCopy = tempFluids;//preventing CMEs >_>
		tempFluids = new HashSet<>();
		for(BlockPos pos : tempFluidsCopy)
			addConnectedSpaces(pos);
	}

	private boolean isFullFluidBlock(BlockPos pos, IBlockState state)
	{
		if(state.func_177230_c() instanceof IFluidBlock)
			return Math.abs(((IFluidBlock)state.func_177230_c()).getFilledPercentage(func_145831_w(),pos))==1;
		else if(state.func_177230_c() instanceof BlockLiquid)
			return state.func_177230_c().func_176201_c(state)==0;
		return false;
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		sideConfig = nbt.func_74759_k("sideConfig");
		if(sideConfig==null || sideConfig.length!=6)
			sideConfig = new int[]{1,0,1,1,1,1};
		tank.readFromNBT(nbt.func_74775_l("tank"));
		if(descPacket)
			this.markContainingBlockForUpdate(null);
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74783_a("sideConfig", sideConfig);
		nbt.func_74782_a("tank", tank.writeToNBT(new NBTTagCompound()));
	}

	@Override
	public SideConfig getSideConfig(int side)
	{
		return (side>=0&&side<6)?SideConfig.values()[this.sideConfig[side]+1]: SideConfig.NONE;
	}
	@Override
	public boolean toggleSide(int side, EntityPlayer p)
	{
		sideConfig[side]++;
		if(sideConfig[side]>1)
			sideConfig[side]=-1;
		prepareAreaCheck();
		this.func_70296_d();
		this.markContainingBlockForUpdate(null);
		func_145831_w().func_175641_c(func_174877_v(), this.func_145838_q(), 0, 0);
		return true;
	}

	@Override
	public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing)
	{
		if(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing==null||sideConfig[facing.ordinal()]==0) )
			return true;
		return super.hasCapability(capability, facing);
	}
	@Override
	public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing)
	{
		if(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing==null||sideConfig[facing.ordinal()]==0) )
			return (T)tank;
		return super.getCapability(capability, facing);
	}

	@Override
	public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer)
	{
		if(hammer && IEConfig.colourblindSupport)
		{
			int i = sideConfig[Math.min(sideConfig.length-1, mop.field_178784_b.ordinal())];
			int j = sideConfig[Math.min(sideConfig.length-1, mop.field_178784_b.func_176734_d().ordinal())];
			return new String[]{
					I18n.func_135052_a(Lib.DESC_INFO+"blockSide.facing")
							+": "+ I18n.func_135052_a(Lib.DESC_INFO+"blockSide.connectFluid."+i),
					I18n.func_135052_a(Lib.DESC_INFO+"blockSide.opposite")
							+": "+ I18n.func_135052_a(Lib.DESC_INFO+"blockSide.connectFluid."+j)
			};
		}
		return null;
	}
	@Override
	public boolean useNixieFont(EntityPlayer player, RayTraceResult mop)
	{
		return false;
	}
}
