package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.*;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.*;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Set;

import static blusunrize.immersiveengineering.ImmersiveEngineering.MODID;
import static blusunrize.immersiveengineering.api.energy.wires.WireApi.INFOS;
import static blusunrize.immersiveengineering.api.energy.wires.WireApi.registerFeedthroughForWiretype;
import static blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector.*;

public class TileEntityFeedthrough extends TileEntityImmersiveConnectable implements ITileDrop, IDirectionalTile,
		IHasDummyBlocks, IPropertyPassthrough, IBlockBounds, ICacheData
{
	public static final String WIRE = "wire";
	private static final String POSITIVE_CON_X = "posConnX";
	private static final String POSITIVE_CON_Y = "posConnY";
	private static final String POSITIVE_CON_Z = "posConnZ";
	private static final String HAS_NEGATIVE = "hasNeg";
	private static final String FACING = "facing";
	private static final String OFFSET = "offset";
	public static final String MIDDLE_STATE = "middle";

	@Nonnull
	public WireType reference = WireType.COPPER;
	@Nonnull
	public IBlockState stateForMiddle = Blocks.field_150346_d.func_176223_P();
	@Nonnull
	EnumFacing facing = EnumFacing.NORTH;
	public int offset = 0;
	@Nullable
	private BlockPos connPositive = null;
	private boolean hasNegative = false;

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		nbt.func_74778_a(WIRE, reference.getUniqueName());
		if (connPositive!=null)
		{
			nbt.func_74768_a(POSITIVE_CON_X, connPositive.func_177958_n());
			nbt.func_74768_a(POSITIVE_CON_Y, connPositive.func_177956_o());
			nbt.func_74768_a(POSITIVE_CON_Z, connPositive.func_177952_p());
		}
		nbt.func_74757_a(HAS_NEGATIVE, hasNegative);
		nbt.func_74768_a(FACING, facing.func_176745_a());
		nbt.func_74768_a(OFFSET, offset);
		NBTTagCompound stateNbt = new NBTTagCompound();
		Utils.stateToNBT(stateNbt, stateForMiddle);
		nbt.func_74782_a(MIDDLE_STATE, stateNbt);
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		reference = WireType.getValue(nbt.func_74779_i(WIRE));
		if (nbt.func_74764_b(POSITIVE_CON_X))
			connPositive = new BlockPos(
					nbt.func_74762_e(POSITIVE_CON_X),
					nbt.func_74762_e(POSITIVE_CON_Y),
					nbt.func_74762_e(POSITIVE_CON_Z));
		hasNegative = nbt.func_74767_n(HAS_NEGATIVE);
		facing = EnumFacing.field_82609_l[nbt.func_74762_e(FACING)];
		offset = nbt.func_74762_e(OFFSET);
		stateForMiddle = Utils.stateFromNBT(nbt.func_74775_l(MIDDLE_STATE));
	}

	@Override
	public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con)
	{
		return getOffset(con.start.equals(connPositive)||con.end.equals(connPositive));
	}

	private boolean isPositive(Vec3i offset)
	{
		return offset.func_177958_n()*facing.func_82601_c()+
				offset.func_177956_o()*facing.func_96559_d()+
				offset.func_177952_p()*facing.func_82599_e()>0;
	}

	@Override
	public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, TargetingInfo target, Vec3i offsetLink)
	{
		return getOffset(isPositive(offsetLink));
	}

	private Vec3d getOffset(boolean positive)
	{
		double l = INFOS.get(reference).connOffset;
		int factor = positive?1:-1;
		return new Vec3d(.5+(.5+l)*facing.func_82601_c()*factor, .5+(.5+l)*facing.func_96559_d()*factor,
				.5+(.5+l)*facing.func_82599_e()*factor);
	}

	@Override
	public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset)
	{
		if (!WireApi.canMix(reference, cableType))
			return false;
		boolean positive = isPositive(offset);
		if (positive)
			return connPositive==null;
		else
			return !hasNegative;
	}

	@Override
	public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other, @Nullable Vec3i offset)
	{
		if (offset!=null)
		{
			if (isPositive(offset))
				connPositive = ApiUtils.toBlockPos(other);
			else
				hasNegative = true;
		}
	}

	@Override
	public void removeCable(ImmersiveNetHandler.Connection connection)
	{
		if (connection==null)
		{
			connPositive = null;
			hasNegative = false;
		}
		else
		{
			if (connection.end.equals(connPositive)||connection.start.equals(connPositive))
				connPositive = null;
			else
				hasNegative = false;
		}
	}

	@Override
	public WireType getCableLimiter(TargetingInfo target)
	{
		return reference;
	}

	@Override
	public Set<BlockPos> getIgnored(IImmersiveConnectable other)
	{
		return ImmutableSet.of(field_174879_c.func_177967_a(facing, 1), field_174879_c.func_177967_a(facing, -1));
	}

	@Override
	public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target)
	{
		return field_174879_c.func_177967_a(facing, -offset);
	}

	@Override
	public ItemStack getTileDrop(@Nullable EntityPlayer player, IBlockState state)
	{
		ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
		stack.func_77983_a(WIRE, new NBTTagString(reference.getUniqueName()));
		NBTTagCompound stateNbt = new NBTTagCompound();
		Utils.stateToNBT(stateNbt, stateForMiddle);
		stack.func_77983_a(MIDDLE_STATE, stateNbt);
		return stack;
	}

	@Override
	public void readOnPlacement(@Nullable EntityLivingBase placer, ItemStack stack)
	{
		reference = WireType.getValue(ItemNBTHelper.getString(stack, WIRE));
		stateForMiddle = Utils.stateFromNBT(ItemNBTHelper.getTagCompound(stack, MIDDLE_STATE));
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}

	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}

	@Override
	public int getFacingLimitation()
	{
		return 1;
	}

	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}

	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return false;
	}

	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return false;
	}

	//Called after setFacing
	@Override
	public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		for (int i = -1;i<=1;i+=2)
		{
			BlockPos tmp = pos.func_177967_a(facing, i);
			field_145850_b.func_175656_a(tmp, state);
			TileEntity te = field_145850_b.func_175625_s(tmp);
			if (te instanceof TileEntityFeedthrough)
			{
				((TileEntityFeedthrough) te).facing = facing;
				((TileEntityFeedthrough) te).offset = i;
				((TileEntityFeedthrough) te).reference = reference;
				((TileEntityFeedthrough) te).stateForMiddle = stateForMiddle;
				field_145850_b.func_175664_x(tmp);
			}
		}
	}

	@Override
	public void breakDummies(BlockPos pos, IBlockState state)
	{
		for (int i = -1-offset;i<=1-offset;i++)
			field_145850_b.func_175698_g(pos.func_177967_a(facing, i));
	}

	@Override
	public boolean isDummy()
	{
		return false;//Every block has a model
	}

	private static float[] FULL_BLOCK = {0, 0, 0, 1, 1, 1};
	private float[] aabb;
	@Override
	public float[] getBlockBounds()
	{
		if (offset==0)
			return FULL_BLOCK;
		if (aabb==null)
		{
			float[] tmp = {
					5F/16, 0, 5F/16,
					11F/16, (float) INFOS.get(reference).connLength, 11F/16
			};
			aabb = Utils.rotateToFacing(tmp, offset>0?facing:facing.func_176734_d());
		}
		return aabb;
	}

	@Override
	public Object[] getCacheData()
	{
		return new Object[] {
				stateForMiddle, reference, facing
		};
	}

	@Override
	public float getDamageAmount(Entity e, ImmersiveNetHandler.Connection c)
	{
		return INFOS.get(reference).postProcessDmg.apply(super.getDamageAmount(e, c));
	}

	@Override
	protected float getBaseDamage(ImmersiveNetHandler.Connection c)
	{
		return INFOS.get(reference).dmgPerEnergy;
	}

	@Override
	protected float getMaxDamage(ImmersiveNetHandler.Connection c)
	{
		return INFOS.get(reference).maxDmg;
	}
}
