/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler.MineralWorldInfo;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IAdvancedCollisionBounds;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IAdvancedSelectionBounds;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockExcavator;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

import java.util.ArrayList;
import java.util.List;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal.MultiblockProcess;

public class TileEntityExcavator extends TileEntityMultiblockMetal<TileEntityExcavator,IMultiblockRecipe> implements IAdvancedSelectionBounds,IAdvancedCollisionBounds
{
	public TileEntityExcavator()
	{
		super(MultiblockExcavator.instance, new int[]{3,6,3}, 64000, true);
	}

	public boolean active = false;


	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
	}

	@Override
	public int getComparatorInputOverride()
	{
		if(!this.isRedstonePos())
			return 0;
		BlockPos wheelPos = this.getBlockPosForPos(31);
		if(field_145850_b.func_175667_e(wheelPos) && field_145850_b.func_175625_s(wheelPos) instanceof TileEntityBucketWheel)
		{
			MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(field_145850_b, wheelPos.func_177958_n()>>4, wheelPos.func_177952_p()>>4);
			float remain = (ExcavatorHandler.mineralVeinCapacity-info.depletion)/(float)ExcavatorHandler.mineralVeinCapacity;
			return MathHelper.func_76141_d(Math.max(remain,0)*15);
		}
		return 0;
	}

	@Override
	public void func_73660_a()
	{
		super.func_73660_a();
		if(isDummy())
			return;
		BlockPos wheelPos = this.getBlockPosForPos(31);
		if(!field_145850_b.field_72995_K && field_145850_b.func_175667_e(wheelPos))
		{
			TileEntity center = field_145850_b.func_175625_s(wheelPos);

			if(center instanceof TileEntityBucketWheel)
			{
				float rot = 0;
				int target = -1;
				TileEntityBucketWheel wheel = ((TileEntityBucketWheel) center);
				EnumFacing fRot = this.facing.func_176735_f();
				if(wheel.facing==fRot)
				{
					if(active!=wheel.active)
						field_145850_b.func_175641_c(wheel.func_174877_v(), wheel.func_145838_q(), 0, active? 1: 0);
					rot = wheel.rotation;
					if(rot%45>40)
						target = Math.round(rot/360f*8)%8;
				}

				if(wheel.facing!=fRot || wheel.mirrored!=this.mirrored)
				{
					for(int h = -3; h <= 3; h++)
						for(int w = -3; w <= 3; w++)
						{
							TileEntity te = field_145850_b.func_175625_s(wheelPos.func_177982_a(0, h, 0).func_177967_a(facing, w));
							if(te instanceof TileEntityBucketWheel)
							{
								((TileEntityBucketWheel)te).facing = fRot;
								((TileEntityBucketWheel)te).mirrored = this.mirrored;
								te.func_70296_d();
								((TileEntityBucketWheel)te).markContainingBlockForUpdate(null);
								field_145850_b.func_175641_c(te.func_174877_v(), te.func_145838_q(), 255, 0);
							}
						}
					}

				if(!isRSDisabled())
				{
					ExcavatorHandler.MineralMix mineral = ExcavatorHandler.getRandomMineral(field_145850_b, wheelPos.func_177958_n()>>4, wheelPos.func_177952_p()>>4);

					int consumed = IEConfig.Machines.excavator_consumption;
					int extracted = energyStorage.extractEnergy(consumed, true);
					if(extracted>=consumed)
					{
						energyStorage.extractEnergy(consumed, false);
						active = true;

						if(target>=0 && target<8)
						{
							int targetDown = (target + 4) % 8;
							NBTTagCompound packet = new NBTTagCompound();
							if(wheel.digStacks.get(targetDown).func_190926_b())
							{
								ItemStack blocking = this.digBlocksInTheWay(wheel);
								BlockPos lowGroundPos = wheelPos.func_177982_a(0,-5,0);
								if(!blocking.func_190926_b())
								{
									wheel.digStacks.set(targetDown, blocking);
									wheel.func_70296_d();
									this.markContainingBlockForUpdate(null);
								} else if(mineral != null
										&& !field_145850_b.func_175623_d(lowGroundPos.func_177967_a(facing, -2))
										&& !field_145850_b.func_175623_d(lowGroundPos.func_177967_a(facing, 2))
										&& !field_145850_b.func_175623_d(lowGroundPos.func_177967_a(facing, -1))
										&& !field_145850_b.func_175623_d(lowGroundPos.func_177967_a(facing, 1))
										&& !field_145850_b.func_175623_d(lowGroundPos))
								{
									ItemStack ore = mineral.getRandomOre(Utils.RAND);
									float configChance = Utils.RAND.nextFloat();
									float failChance = Utils.RAND.nextFloat();
									if(!ore.func_190926_b() && configChance> IEConfig.Machines.excavator_fail_chance && failChance>mineral.failChance)
									{
										wheel.digStacks.set(targetDown, ore);
										wheel.func_70296_d();
										this.markContainingBlockForUpdate(null);
									}
									ExcavatorHandler.depleteMinerals(field_145850_b, wheelPos.func_177958_n()>>4, wheelPos.func_177952_p()>>4);
								}
								if(!wheel.digStacks.get(targetDown).func_190926_b())
								{
									packet.func_74768_a("fill", targetDown);
									packet.func_74782_a("fillStack", wheel.digStacks.get(targetDown).func_77955_b(new NBTTagCompound()));
								}
							}
							if(!wheel.digStacks.get(target).func_190926_b())
							{
								this.doProcessOutput(wheel.digStacks.get(target).func_77946_l());
								Block b = Block.func_149634_a(wheel.digStacks.get(target).func_77973_b());
								if(b!=null&&b!=Blocks.field_150350_a)
									wheel.particleStack = wheel.digStacks.get(target).func_77946_l();
								wheel.digStacks.set(target, ItemStack.field_190927_a);
								wheel.func_70296_d();
								this.markContainingBlockForUpdate(null);
								packet.func_74768_a("empty", target);
							}
							if(!packet.func_82582_d())
								ImmersiveEngineering.packetHandler.sendToAll(new MessageTileSync(wheel, packet));
						}
					}
					else if(active)
						active=false;
				}
				else if(active)
				{
					active=false;
//					update = true;
				}
//				if(update)
//				{
//					this.markDirty();
//					world.markBlockForUpdate(xCoord, yCoord, zCoord);
//				}
			}
		}
	}

	ItemStack digBlocksInTheWay(TileEntityBucketWheel wheel)
	{
		BlockPos pos = wheel.func_174877_v().func_177982_a(0,-4,0);
		ItemStack s = digBlock(pos);
		if(!s.func_190926_b())
			return s;
		//Backward 1
		s = digBlock(pos.func_177967_a(facing,-1));
		if(!s.func_190926_b())
			return s;
		//Backward 2
		s = digBlock(pos.func_177967_a(facing,-2));
		if(!s.func_190926_b())
			return s;
		//Forward 1
		s = digBlock(pos.func_177967_a(facing,1));
		if(!s.func_190926_b())
			return s;
		//Forward 2
		s = digBlock(pos.func_177967_a(facing,2));
		if(!s.func_190926_b())
			return s;

		//Backward+Sides
		s = digBlock(pos.func_177967_a(facing,-1).func_177972_a(facing.func_176746_e()));
		if(!s.func_190926_b())
			return s;
		s = digBlock(pos.func_177967_a(facing,-1).func_177972_a(facing.func_176735_f()));
		if(!s.func_190926_b())
			return s;
		//Center Sides
		s = digBlock(pos.func_177972_a(facing.func_176746_e()));
		if(!s.func_190926_b())
			return s;
		s = digBlock(pos.func_177972_a(facing.func_176735_f()));
		if(!s.func_190926_b())
			return s;
		//Forward+Sides
		s = digBlock(pos.func_177967_a(facing,1).func_177972_a(facing.func_176746_e()));
		if(!s.func_190926_b())
			return s;
		s = digBlock(pos.func_177967_a(facing,1).func_177972_a(facing.func_176735_f()));
		if(!s.func_190926_b())
			return s;
		return ItemStack.field_190927_a;
	}


	ItemStack digBlock(BlockPos pos)
	{
		if(!(field_145850_b instanceof WorldServer))
			return ItemStack.field_190927_a;
		FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer((WorldServer) field_145850_b);
		IBlockState blockstate = field_145850_b.func_180495_p(pos);
		Block block = blockstate.func_177230_c();
		if(block!=null && !field_145850_b.func_175623_d(pos) && blockstate.func_185903_a(fakePlayer, field_145850_b, pos)!=0)
		{
			if(!block.canHarvestBlock(field_145850_b, pos, fakePlayer))
				return ItemStack.field_190927_a;
			block.func_176208_a(field_145850_b, pos, blockstate, fakePlayer);
			if(block.removedByPlayer(blockstate, field_145850_b, pos, fakePlayer, true))
			{
				block.func_176206_d( field_145850_b, pos, blockstate);
				if(block.canSilkHarvest(field_145850_b, pos, blockstate, fakePlayer))
				{
					ArrayList<ItemStack> items = new ArrayList<ItemStack>();
					Item bitem = Item.func_150898_a(block);
					if(bitem== Items.field_190931_a)
						return ItemStack.field_190927_a;
					ItemStack itemstack = new ItemStack(bitem, 1, block.func_176201_c(blockstate));
					if (!itemstack.func_190926_b())
						items.add(itemstack);

					ForgeEventFactory.fireBlockHarvesting(items, field_145850_b, pos, blockstate, 0, 1.0f, true, fakePlayer);

					for(int i=0; i<items.size(); i++)
						if(i!=0)
						{
							EntityItem ei = new EntityItem(field_145850_b, pos.func_177958_n()+.5,pos.func_177956_o()+.5,pos.func_177952_p()+.5, items.get(i).func_77946_l());
							this.field_145850_b.func_72838_d(ei);
						}
					field_145850_b.func_175718_b(2001, pos, Block.func_176210_f(blockstate));
					if(items.size()>0)
						return items.get(0);
				}
				else
				{
					block.func_180657_a(field_145850_b, fakePlayer, pos, blockstate, field_145850_b.func_175625_s(pos), ItemStack.field_190927_a);
					field_145850_b.func_175718_b(2001, pos, Block.func_176210_f(blockstate));
				}
			}
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public float[] getBlockBounds()
	{
		EnumFacing fl = facing;
		EnumFacing fw = facing.func_176746_e();
		if(mirrored)
			fw = fw.func_176734_d();

		if(pos==45)
			return new float[]{fl==EnumFacing.EAST?.5f:0,0,fl==EnumFacing.SOUTH?.5f:0, fl==EnumFacing.WEST?.5f:1,.5f,fl==EnumFacing.NORTH?.5f:1};
		if(pos==48)
			return new float[]{0,0,0, 1,.5f,1};
		if(pos==51)
			return new float[]{fl==EnumFacing.WEST?.5f:0,0,fl==EnumFacing.NORTH?.5f:0, fl==EnumFacing.EAST?.5f:1,.5f,fl==EnumFacing.SOUTH?.5f:1};

		if(pos==47)
			return new float[]{fl==EnumFacing.EAST?.5f:fl==EnumFacing.WEST?.375f:0,0,fl==EnumFacing.SOUTH?.5f:fl==EnumFacing.NORTH?.375f:0, fl==EnumFacing.WEST?.5f:fl==EnumFacing.EAST?.625f:1,1,fl==EnumFacing.NORTH?.5f:fl==EnumFacing.SOUTH?.625f:1};
		if(pos==50)
			return new float[]{fw==EnumFacing.EAST?.875f:0,0,fw==EnumFacing.SOUTH?.875f:0, fw==EnumFacing.WEST?.125f:1,1,fw==EnumFacing.NORTH?.125f:1};
		if(pos==53)
			return new float[]{fl==EnumFacing.WEST?.5f:fl==EnumFacing.EAST?.375f:0,0,fl==EnumFacing.NORTH?.5f:fl==EnumFacing.SOUTH?.375f:0, fl==EnumFacing.EAST?.5f:fl==EnumFacing.WEST?.625f:1,1,fl==EnumFacing.SOUTH?.5f:fl==EnumFacing.NORTH?.625f:1};

		if(pos==5||pos==23||pos==41)
			return new float[]{fw==EnumFacing.WEST?.5f:0,0,fw==EnumFacing.NORTH?.5f:0, fw==EnumFacing.EAST?.5f:1,1,fw==EnumFacing.SOUTH?.5f:1};
		if(pos==9||pos==12||pos==15)
			return new float[]{fw==EnumFacing.EAST?.5f:0,0,fw==EnumFacing.SOUTH?.5f:0, fw==EnumFacing.WEST?.5f:1,1,fw==EnumFacing.NORTH?.5f:1};
		if(pos==11||pos==14||pos==17)
			return new float[]{fw==EnumFacing.WEST?.5f:0,0,fw==EnumFacing.NORTH?.5f:0, fw==EnumFacing.EAST?.5f:1,1,fw==EnumFacing.SOUTH?.5f:1};




		return new float[]{0,0,0, 1,1,1};
	}
	@Override
	public List<AxisAlignedBB> getAdvancedSelectionBounds()
	{
		EnumFacing fl = facing;
		EnumFacing fw = facing.func_176746_e();
		if(mirrored)
			fw = fw.func_176734_d();

		if(pos==5||pos==23||pos==41)
		{
			List list = Lists.newArrayList(new AxisAlignedBB(fw==EnumFacing.WEST?.5f:0,0,fw==EnumFacing.NORTH?.5f:0, fw==EnumFacing.EAST?.5f:1,1,fw==EnumFacing.SOUTH?.5f:1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			list.add(new AxisAlignedBB(fw==EnumFacing.EAST?.5f:fw==EnumFacing.WEST?0:.25f,.25f,fw==EnumFacing.SOUTH?.5f:fw==EnumFacing.NORTH?0:.25f, fw==EnumFacing.WEST?.5f:fw==EnumFacing.EAST?1:.75f,.75f,fw==EnumFacing.NORTH?.5f:fw==EnumFacing.SOUTH?1:.75f).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			return list;
		}
		else if(pos==9||pos==12||pos==15)
		{
			List list = Lists.newArrayList(new AxisAlignedBB(fw==EnumFacing.EAST?.5f:0,0,fw==EnumFacing.SOUTH?.5f:0, fw==EnumFacing.WEST?.5f:1,1,fw==EnumFacing.NORTH?.5f:1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			if(pos==9)
				list.add(new AxisAlignedBB(fw==EnumFacing.WEST||fl==EnumFacing.EAST?.5f:0,.5f,fw==EnumFacing.NORTH||fl==EnumFacing.SOUTH?.5f:0, fw==EnumFacing.EAST||fl==EnumFacing.WEST?.5f:1,1,fw==EnumFacing.SOUTH||fl==EnumFacing.NORTH?.5f:1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			else if(pos==12)
				list.add(new AxisAlignedBB(fw==EnumFacing.WEST?.5f:0,.5f,fw==EnumFacing.NORTH?.5f:0, fw==EnumFacing.EAST?.5f:1,1,fw==EnumFacing.SOUTH?.5f:1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			else
				list.add(new AxisAlignedBB(fw==EnumFacing.WEST||fl==EnumFacing.WEST?.5f:0,.5f,fw==EnumFacing.NORTH||fl==EnumFacing.NORTH?.5f:0, fw==EnumFacing.EAST||fl==EnumFacing.EAST?.5f:1,1,fw==EnumFacing.SOUTH||fl==EnumFacing.SOUTH?.5f:1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			return list;
		}
		else if(pos==47)
		{
			List list = Lists.newArrayList(new AxisAlignedBB(fl==EnumFacing.EAST?.5f:fl==EnumFacing.WEST?.375f:0,0,fl==EnumFacing.SOUTH?.5f:fl==EnumFacing.NORTH?.375f:0, fl==EnumFacing.WEST?.5f:fl==EnumFacing.EAST?.625f:1,1,fl==EnumFacing.NORTH?.5f:fl==EnumFacing.SOUTH?.625f:1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			list.add(new AxisAlignedBB(fl==EnumFacing.EAST?.625f:fw==EnumFacing.EAST?.875f:0,0,fl==EnumFacing.SOUTH?.625f:fw==EnumFacing.SOUTH?.875f:0, fl==EnumFacing.WEST?.375f:fw==EnumFacing.WEST?.125f:1,1,fl==EnumFacing.NORTH?.375f:fw==EnumFacing.NORTH?.125f:1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			return list;
		}
		else if(pos==53)
		{
			List list = Lists.newArrayList(new AxisAlignedBB(fl==EnumFacing.WEST?.5f:fl==EnumFacing.EAST?.375f:0,0,fl==EnumFacing.NORTH?.5f:fl==EnumFacing.SOUTH?.375f:0, fl==EnumFacing.EAST?.5f:fl==EnumFacing.WEST?.625f:1,1,fl==EnumFacing.SOUTH?.5f:fl==EnumFacing.NORTH?.625f:1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			list.add(new AxisAlignedBB(fl==EnumFacing.WEST?.625f:fw==EnumFacing.EAST?.875f:0,0,fl==EnumFacing.NORTH?.625f:fw==EnumFacing.SOUTH?.875f:0, fl==EnumFacing.EAST?.375f:fw==EnumFacing.WEST?.125f:1,1,fl==EnumFacing.SOUTH?.375f:fw==EnumFacing.NORTH?.125f:1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			return list;
		}
		return null;
	}
	@Override
	public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list)
	{
		return false;
	}
	@Override
	public List<AxisAlignedBB> getAdvancedColisionBounds()
	{
		return getAdvancedSelectionBounds();
	}

	@Override
	public int[] getEnergyPos()
	{
		return new int[]{5,23,41};
	}
	@Override
	public int[] getRedstonePos()
	{
		return new int[]{18};
	}

	@Override
	public boolean isInWorldProcessingMachine()
	{
		return false;
	}
	@Override
	public boolean additionalCanProcessCheck(MultiblockProcess<IMultiblockRecipe> process)
	{
		return false;
	}
	@Override
	public void doProcessOutput(ItemStack output)
	{
		BlockPos pos = func_174877_v().func_177967_a(facing,-1);
		TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
		if(inventoryTile!=null)
			output = Utils.insertStackIntoInventory(inventoryTile, output, facing.func_176734_d());
		if(!output.func_190926_b())
			Utils.dropStackAtPos(field_145850_b, pos, output, facing);
	}
	@Override
	public void doProcessFluidOutput(FluidStack output)
	{
	}
	@Override
	public void onProcessFinish(MultiblockProcess<IMultiblockRecipe> process)
	{
	}
	@Override
	public int getMaxProcessPerTick()
	{
		return 0;
	}
	@Override
	public int getProcessQueueMaxLength()
	{
		return 0;
	}
	@Override
	public float getMinProcessDistance(MultiblockProcess<IMultiblockRecipe> process)
	{
		return 0;
	}


	@Override
	public NonNullList<ItemStack> getInventory()
	{
		return null;
	}
	@Override
	public boolean isStackValid(int slot, ItemStack stack)
	{
		return false;
	}
	@Override
	public int getSlotLimit(int slot)
	{
		return 0;
	}
	@Override
	public int[] getOutputSlots()
	{
		return new int[0];
	}
	@Override
	public int[] getOutputTanks()
	{
		return new int[0];
	}
	@Override
	public IFluidTank[] getInternalTanks()
	{
		return null;
	}
	@Override
	protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side)
	{
		return new IFluidTank[0];
	}
	@Override
	protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources)
	{
		return false;
	}
	@Override
	protected boolean canDrainTankFrom(int iTank, EnumFacing side)
	{
		return false;
	}
	@Override
	public void doGraphicalUpdates(int slot)
	{
		this.func_70296_d();
		this.markContainingBlockForUpdate(null);
	}


	@Override
	public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting)
	{
		return null;
	}
	@Override
	protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag)
	{
		return null;
	}
	@Override
	public void disassemble() {
		super.disassemble();
		BlockPos wheelPos = this.getBlockPosForPos(31);
		TileEntity center = field_145850_b.func_175625_s(wheelPos);
		if (center instanceof TileEntityBucketWheel)
			field_145850_b.func_175641_c(center.func_174877_v(), center.func_145838_q(), 0, 0);
	}
}
