/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.*;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler.Connection;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.*;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.*;
import net.minecraft.util.text.TextComponentTranslation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TileEntityEnergyMeter extends TileEntityImmersiveConnectable implements ITickable, IDirectionalTile, IHasDummyBlocks, IAdvancedCollisionBounds,IAdvancedSelectionBounds, IPlayerInteraction, IComparatorOverride
{
	public EnumFacing facing = EnumFacing.NORTH;
	public double lastEnergyPassed = 0;
	public final ArrayList<Double> lastPackets = new ArrayList<>(25);
	public boolean lower=true;
	private int compVal = -1;

	@Override
	protected boolean canTakeLV()
	{
		return true;
	}
	@Override
	protected boolean canTakeMV()
	{
		return true;
	}
	@Override
	protected boolean canTakeHV()
	{
		return true;
	}

	@Override
	protected boolean isRelay()
	{
		return true;
	}

	@Override
	public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ)
	{
		if (!heldItem.func_190926_b()&&heldItem.func_77973_b() instanceof IWireCoil)
			return false;
		int transfer = getAveragePower();
		int packets = lastPackets.size();
		if(lower)
		{
			TileEntity above = field_145850_b.func_175625_s(func_174877_v().func_177982_a(0,1,0));
			if(above instanceof TileEntityEnergyMeter)
				packets = ((TileEntityEnergyMeter)above).lastPackets.size();
		}
		String transferred = "0";
		if(transfer>0)
			transferred = Utils.formatDouble(transfer, "0.###");
		ChatUtils.sendServerNoSpamMessages(player, new TextComponentTranslation(Lib.CHAT_INFO+"energyTransfered",packets,transferred));
		return true;
	}

	@Override
	public void func_73660_a()
	{
		ApiUtils.checkForNeedlessTicking(this);
		if(lower || field_145850_b.field_72995_K)
			return;
		if (((field_145850_b.func_82737_E()&31)==(field_174879_c.func_177986_g()&31)||compVal<0))
			updateComparatorValues();
		//Yes, this might tick in between different connectors sending power, but since this is a block for statistical evaluation over a tick, that is irrelevant.
		lastPackets.add(lastEnergyPassed);
		if(lastPackets.size()>20)
			lastPackets.remove(0);
		lastEnergyPassed = 0;
	}

	@Override
	public boolean canConnect()
	{
		return true;
	}

	@Override
	public void onEnergyPassthrough(double amount)
	{
		lastEnergyPassed += amount;
	}

	@Override
	public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset)
	{
		if(lower)
		{
			TileEntity above = field_145850_b.func_175625_s(func_174877_v().func_177982_a(0,1,0));
			if(above instanceof TileEntityEnergyMeter)
				return ((TileEntityEnergyMeter)above).canConnectCable(cableType, target, offset);
			return false;
		}
		return super.canConnectCable(cableType, target, offset);
	}
	@Override
	public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other)
	{
		if(lower)
		{
			TileEntity above = field_145850_b.func_175625_s(func_174877_v().func_177982_a(0,1,0));
			if(above instanceof TileEntityEnergyMeter)
				((TileEntityEnergyMeter) above).connectCable(cableType, target, other);
		}
		else
			super.connectCable(cableType, target, other);
	}

	@Override
	public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target)
	{
		if (lower)
			return field_174879_c.func_177984_a();
		else
			return field_174879_c;
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		nbt.func_74768_a("facing", facing.ordinal());
		nbt.func_74757_a("dummy", lower);
	}
	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		facing = EnumFacing.values()[nbt.func_74762_e("facing")];
		lower = nbt.func_74767_n("dummy");
	}

	@Override
	public Vec3d getConnectionOffset(Connection con)
	{
		int xDif = (con==null||con.start==null||con.end==null)?0: (con.start.equals(Utils.toCC(this))&&con.end!=null)? con.end.func_177958_n()-func_174877_v().func_177958_n(): (con.end.equals(Utils.toCC(this))&& con.start!=null)?con.start.func_177958_n()-func_174877_v().func_177958_n(): 0;
		int zDif = (con==null||con.start==null||con.end==null)?0: (con.start.equals(Utils.toCC(this))&&con.end!=null)? con.end.func_177952_p()-func_174877_v().func_177952_p(): (con.end.equals(Utils.toCC(this))&& con.start!=null)?con.start.func_177952_p()-func_174877_v().func_177952_p(): 0;
		if(facing.func_176740_k()==Axis.X)
			return new Vec3d(.5,.4375,zDif>0?.8125:.1875);
		else
			return new Vec3d(xDif>0?.8125:.1875,.4375,.5);
	}

	@Override
	public boolean isDummy()
	{
		return !lower;
	}

	@Override
	public boolean isLogicDummy()
	{
		return lower;
	}

	@Override
	public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		field_145850_b.func_175656_a(pos.func_177982_a(0,1,0), state);
		((TileEntityEnergyMeter)field_145850_b.func_175625_s(pos.func_177982_a(0,1,0))).lower = false;
		((TileEntityEnergyMeter)field_145850_b.func_175625_s(pos.func_177982_a(0,1,0))).facing = this.facing;
	}
	@Override
	public void breakDummies(BlockPos pos, IBlockState state)
	{
		for(int i=0; i<=1; i++)
			if(field_145850_b.func_175625_s(func_174877_v().func_177982_a(0,!lower?-1:0,0).func_177982_a(0,i,0)) instanceof TileEntityEnergyMeter)
				field_145850_b.func_175698_g(func_174877_v().func_177982_a(0,!lower?-1:0,0).func_177982_a(0,i,0));
	}

	public int getAveragePower()
	{
		TileEntityEnergyMeter te = this;
		if(te.lower)
		{
			TileEntity tmp = field_145850_b.func_175625_s(func_174877_v().func_177982_a(0,1,0));
			if(!(tmp instanceof TileEntityEnergyMeter))
				return -1;
			te = (TileEntityEnergyMeter) tmp;
		}
		if(te.lastPackets.size()==0)
			return 0;
		double sum = 0;
		synchronized (te.lastPackets)
		{
			for(double transfer: te.lastPackets)
				sum += transfer;
		}
		return (int) Math.round(sum/te.lastPackets.size());
	}

	@Override
	public float[] getBlockBounds()
	{
//		return new float[]{0,0,0,1,1,1};
		return null;
	}
	@Override
	public List<AxisAlignedBB> getAdvancedSelectionBounds()
	{
		List<AxisAlignedBB> list = Lists.newArrayList(new AxisAlignedBB(.1875f,-.625f,.1875f, .8125f,.8125f,.8125f).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
		if(lower)
		{
			list.set(0, list.get(0).func_72317_d(0,1,0));
			list.add(new AxisAlignedBB(0,0,0, 1,.375f,1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
		}
		return list;
	}
	@Override
	public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list)
	{
		return false;
	}
	@Override
	public List<AxisAlignedBB> getAdvancedColisionBounds()
	{
		return getAdvancedSelectionBounds();
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}
	@Override
	public int getFacingLimitation()
	{
		return 2;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return false;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return false;
	}
	private void updateComparatorValues()
	{
		int oldVal = compVal;
		int maxTrans = 0;
		Set<Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(field_145850_b, field_174879_c);
		if (conns==null)
			compVal = 0;
		else
		{
			for (Connection c : conns)
				maxTrans += c.cableType.getTransferRate();
			maxTrans /= 2;
			double val = getAveragePower() / (double) maxTrans;
			compVal = (int) Math.ceil(15 * val);
			TileEntity te = field_145850_b.func_175625_s(field_174879_c.func_177977_b());
			if (te instanceof TileEntityEnergyMeter)
				((TileEntityEnergyMeter) te).compVal = compVal;
		}
		if (oldVal!=compVal)
		{
			field_145850_b.func_175666_e(field_174879_c, func_145838_q());
			field_145850_b.func_175666_e(field_174879_c.func_177977_b(), func_145838_q());
		}
	}
	@Override
	public int getComparatorInputOverride()
	{
		return compVal;
	}
}
