/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

import java.util.List;

public class TileEntityConveyorVertical extends TileEntityConveyorBelt
{
	@Override
	public void onEntityCollision(World world, Entity entity)
	{
		if(entity!=null && !entity.field_70128_L)
		{
			if(world.func_175687_A(field_174879_c)>0)
				return;

			double vBase = entity instanceof EntityLivingBase?1.5:1.15;
			double distY = Math.abs(func_174877_v().func_177982_a(0,1,0).func_177956_o()+.5-entity.field_70163_u);
			double treshold = .9;
			boolean contact = distY<treshold;

			double vX = entity.field_70159_w;
			double vY = 0.1 * vBase;
			double vZ = entity.field_70179_y;
			if (entity.field_70181_x<0)
				vY+=entity.field_70181_x*.9;

			if(!(entity instanceof EntityPlayer))
			{
				vX = 0.05 * this.facing.func_82601_c();
				vZ = 0.05 * this.facing.func_82599_e();
				if(facing==EnumFacing.WEST || facing==EnumFacing.EAST)
				{
					if(entity.field_70161_v > func_174877_v().func_177952_p()+0.65D)
						vZ = -0.1D * vBase;
					else if(entity.field_70161_v < func_174877_v().func_177952_p()+0.35D)
						vZ = 0.1D * vBase;
				}
				else if(facing==EnumFacing.NORTH || facing==EnumFacing.SOUTH)
				{
					if(entity.field_70165_t > func_174877_v().func_177958_n()+0.65D)
						vX = -0.1D * vBase;
					else if(entity.field_70165_t < func_174877_v().func_177958_n()+0.35D)
						vX = 0.1D * vBase;
				}
			}
			//Little boost at the top of a conveyor to help players and minecarts to get off
			if(contact && !(world.func_175625_s(func_174877_v().func_177982_a(0,1,0)) instanceof TileEntityConveyorVertical))
				vY *= 2.25;
			entity.field_70122_E = false;
			if (entity.field_70143_R<3)
				entity.field_70143_R = 0;
			else
				entity.field_70143_R*=.9;
			entity.field_70159_w = vX;
			entity.field_70181_x = vY;
			entity.field_70179_y = vZ;
			if(entity instanceof EntityItem)
			{
				((EntityItem)entity).func_174873_u();
				TileEntity inventoryTile;
				inventoryTile = world.func_175625_s(func_174877_v().func_177982_a(0,1,0));
				if(!world.field_72995_K)
				{
					if(contact && inventoryTile!=null && !(inventoryTile instanceof TileEntityConveyorBelt))
					{
						ItemStack stack = ((EntityItem)entity).func_92059_d();
						if(!stack.func_190926_b())
						{
							ItemStack ret = Utils.insertStackIntoInventory(inventoryTile, stack, EnumFacing.DOWN);
							if(ret.func_190926_b())
								entity.func_70106_y();
							else if(ret.func_190916_E()<stack.func_190916_E())
								((EntityItem)entity).func_92058_a(ret);
						}
					}
				}
			}
		}
	}

	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return true;
	}

	@Override
	public float[] getBlockBounds()
	{
		float minX = facing==EnumFacing.EAST?.875f:0;
		float maxX = facing==EnumFacing.WEST?.125f:1;
		float minZ = facing==EnumFacing.SOUTH?.875f:0;
		float maxZ = facing==EnumFacing.NORTH?.125f:1;
		return new float[]{minX,0,minZ,maxX,1,maxZ};
	}
	@Override
	public List<AxisAlignedBB> getAdvancedColisionBounds()
	{
		return null;
	}
}
