/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler.Connection;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.energy.wires.redstone.RedstoneWireNetwork;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.*;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import static blusunrize.immersiveengineering.api.energy.wires.WireType.REDSTONE_CATEGORY;

public class TileEntityConnectorRedstone extends TileEntityImmersiveConnectable implements ITickable, IDirectionalTile, IRedstoneOutput, IHammerInteraction, IBlockBounds, IBlockOverlayText, IOBJModelCallback<IBlockState>, IRedstoneConnector
{
	public EnumFacing facing = EnumFacing.DOWN;
	public int ioMode = 0; // 0 - input, 1 -output
	public int redstoneChannel = 0;
	public boolean rsDirty = false;

	protected RedstoneWireNetwork wireNetwork = new RedstoneWireNetwork().add(this);
	private boolean loaded = false;
	// ONLY EVER USE THIS ON THE CLIENT! I don't want to sync the entire network...
	private int outputClient = -1;

	@Override
	public void func_73660_a()
	{
		if(func_145830_o() && !field_145850_b.field_72995_K && !loaded)
		{
			loaded = true;
			wireNetwork.removeFromNetwork(null);
		}
		if (func_145830_o() && !field_145850_b.field_72995_K && rsDirty)
			wireNetwork.updateValues();
	}

	@Override
	public int getStrongRSOutput(IBlockState state, EnumFacing side)
	{
		if(!isRSOutput() || side != this.facing.func_176734_d())
			return 0;
		if (field_145850_b.field_72995_K)
			return outputClient;
		return wireNetwork != null ? wireNetwork.getPowerOutput(redstoneChannel) : 0;
	}

	@Override
	public int getWeakRSOutput(IBlockState state, EnumFacing side)
	{
		if(!isRSOutput())
			return 0;
		if (field_145850_b.field_72995_K)
			return outputClient;
		return wireNetwork != null ? wireNetwork.getPowerOutput(redstoneChannel) : 0;
	}

	@Override
	public boolean canConnectRedstone(IBlockState state, EnumFacing side)
	{
		return true;
	}

	@Override
	public void setNetwork(RedstoneWireNetwork net)
	{
		wireNetwork = net;
	}

	@Override
	public RedstoneWireNetwork getNetwork()
	{
		return wireNetwork;
	}

	@Override
	public void onChange()
	{
		if (!func_145837_r() && isRSOutput())
		{
			func_70296_d();
			markContainingBlockForUpdate(null);
			markBlockForUpdate(field_174879_c.func_177972_a(facing), null);
		}
	}

	@Override
	public World getConnectorWorld()
	{
		return func_145831_w();
	}

	public boolean isRSInput()
	{
		return ioMode == 0;
	}

	@Override
	public void updateInput(byte[] signals)
	{
		if (isRSInput())
			signals[redstoneChannel] = (byte) Math.max(getLocalRS(), signals[redstoneChannel]);
		rsDirty = false;
	}
	protected int getLocalRS()
	{
		int val = field_145850_b.func_175687_A(field_174879_c);
		if (val == 0)
		{
			for (EnumFacing f:EnumFacing.field_176754_o)
			{
				IBlockState state = field_145850_b.func_180495_p(field_174879_c.func_177972_a(f));
				if (state.func_177230_c()== Blocks.field_150488_af&&state.func_177229_b(BlockRedstoneWire.field_176351_O)>val)
					val = state.func_177229_b(BlockRedstoneWire.field_176351_O);
			}
		}
		return val;
	}

	public boolean isRSOutput()
	{
		return ioMode == 1;
	}

	@Override
	public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ)
	{
		//Sneaking iterates through colours, normal hammerign toggles in and out
		if(player.func_70093_af())
			redstoneChannel = (redstoneChannel + 1) % 16;
		else
			ioMode = ioMode == 0 ? 1 : 0;
		func_70296_d();
		wireNetwork.updateValues();
		onChange();
		this.markContainingBlockForUpdate(null);
		field_145850_b.func_175641_c(func_174877_v(), this.func_145838_q(), 254, 0);
		return true;
	}

	@Override
	public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset)
	{
		if(!REDSTONE_CATEGORY.equals(cableType.getCategory()))
			return false;
		return limitType == null || limitType == cableType;
	}

	@Override
	public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other)
	{
		super.connectCable(cableType, target, other);
		if(other instanceof IRedstoneConnector)
			if(((IRedstoneConnector) other).getNetwork() != wireNetwork)
				wireNetwork.mergeNetwork(((IRedstoneConnector) other).getNetwork());
	}

	@Override
	public void removeCable(ImmersiveNetHandler.Connection connection)
	{
		super.removeCable(connection);
		wireNetwork.removeFromNetwork(this);
	}

	@Override
	public EnumFacing getFacing()
	{
		return this.facing;
	}

	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}

	@Override
	public int getFacingLimitation()
	{
		return 0;
	}

	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return true;
	}

	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return false;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return false;
	}


	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		nbt.func_74768_a("facing", facing.ordinal());
		nbt.func_74768_a("ioMode", ioMode);
		nbt.func_74768_a("redstoneChannel", redstoneChannel);
		nbt.func_74768_a("output", wireNetwork != null ? wireNetwork.getPowerOutput(redstoneChannel) : 0);
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
		ioMode = nbt.func_74762_e("ioMode");
		redstoneChannel = nbt.func_74762_e("redstoneChannel");
		outputClient = nbt.func_74762_e("output");
	}

	@Override
	public Vec3d getConnectionOffset(Connection con)
	{
		EnumFacing side = facing.func_176734_d();
		double conRadius = con.cableType.getRenderDiameter() / 2;
		return new Vec3d(.5 - conRadius * side.func_82601_c(), .5 - conRadius * side.func_96559_d(), .5 - conRadius * side.func_82599_e());
	}

	@SideOnly(Side.CLIENT)
	private AxisAlignedBB renderAABB;

	@SideOnly(Side.CLIENT)
	@Override
	public AxisAlignedBB getRenderBoundingBox()
	{
		int inc = getRenderRadiusIncrease();
		return new AxisAlignedBB(this.field_174879_c.func_177958_n() - inc, this.field_174879_c.func_177956_o() - inc, this.field_174879_c.func_177952_p() - inc, this.field_174879_c.func_177958_n() + inc + 1, this.field_174879_c.func_177956_o() + inc + 1, this.field_174879_c.func_177952_p() + inc + 1);
	}

	int getRenderRadiusIncrease()
	{
		return WireType.REDSTONE.getMaxLength();
	}

	@Override
	public float[] getBlockBounds()
	{
		float length = .625f;
		float wMin = .3125f;
		float wMax = .6875f;
		switch(facing.func_176734_d())
		{
			case UP:
				return new float[]{wMin, 0, wMin, wMax, length, wMax};
			case DOWN:
				return new float[]{wMin, 1 - length, wMin, wMax, 1, wMax};
			case SOUTH:
				return new float[]{wMin, wMin, 0, wMax, wMax, length};
			case NORTH:
				return new float[]{wMin, wMin, 1 - length, wMax, wMax, 1};
			case EAST:
				return new float[]{0, wMin, wMin, length, wMax, wMax};
			case WEST:
				return new float[]{1 - length, wMin, wMin, 1, wMax, wMax};
		}
		return new float[]{0, 0, 0, 1, 1, 1};
	}

	@SideOnly(Side.CLIENT)
	@Override
	public boolean shouldRenderGroup(IBlockState object, String group)
	{
		if("io_out".equals(group))
			return this.ioMode == 1;
		else if("io_in".equals(group))
			return this.ioMode == 0;
		return true;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public int getRenderColour(IBlockState object, String group)
	{
		if("coloured".equals(group))
			return 0xff000000|EnumDyeColor.func_176764_b(this.redstoneChannel).func_193350_e();
		return 0xffffffff;
	}
	
	@Override
	public String getCacheKey(IBlockState object)
	{
		return redstoneChannel+";"+ioMode;
	}

	@Override
	public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer)
	{
		if(!hammer)
			return null;
		return new String[]{
				I18n.func_135052_a(Lib.DESC_INFO + "redstoneChannel", I18n.func_135052_a("item.fireworksCharge." + EnumDyeColor.func_176764_b(redstoneChannel).func_176762_d())),
				I18n.func_135052_a(Lib.DESC_INFO + "blockSide.io." + this.ioMode)
		};
	}

	@Override
	public boolean useNixieFont(EntityPlayer player, RayTraceResult mop)
	{
		return false;
	}

	}
