/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler.Connection;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

public class TileEntityConnectorProbe extends TileEntityConnectorRedstone
{
	private int redstoneChannelSending = 0;
	private int lastOutput = 0;

	@Override
	public void func_73660_a()
	{
		if(!field_145850_b.field_72995_K && field_145850_b.func_82737_E() % 8 != ((func_174877_v().func_177958_n() ^ func_174877_v().func_177952_p()) & 8))
		{
			int out = getComparatorSignal();
			if(out!=lastOutput)
			{
				this.lastOutput = out;
				this.rsDirty = true;
			}
		}
		super.func_73660_a();
	}

	@Override
	public boolean isRSInput()
	{
		return true;
	}

	@Override
	public boolean isRSOutput()
	{
		return true;
	}

	private int getComparatorSignal()
	{
		BlockPos pos = this.func_174877_v().func_177972_a(facing);
		IBlockState state = field_145850_b.func_180495_p(pos);
		if(state.func_185912_n())
			return state.func_185888_a(field_145850_b, pos);
		else if(state.func_185915_l())
		{
			pos = pos.func_177972_a(facing);
			state = field_145850_b.func_180495_p(pos);
			if(state.func_185912_n())
				return state.func_185888_a(field_145850_b, pos);
			else if(state.func_185904_a() == Material.field_151579_a)
			{
				EntityItemFrame entityitemframe = this.findItemFrame(field_145850_b, facing, pos);
				if(entityitemframe != null)
					return entityitemframe.func_174866_q();
			}
		}
		return 0;
	}
	private EntityItemFrame findItemFrame(World world, final EnumFacing facing, BlockPos pos)
	{
		List<EntityItemFrame> list = world.func_175647_a(EntityItemFrame.class, new AxisAlignedBB(pos), entity -> entity!=null && entity.func_174811_aO()==facing);
		return list.size()==1 ? list.get(0) : null;
	}

	@Override
	public void updateInput(byte[] signals)
	{
		signals[redstoneChannelSending] = (byte) Math.max(lastOutput, signals[redstoneChannelSending]);
		rsDirty = false;
	}

	@Override
	public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ)
	{
		if(player.func_70093_af())
			redstoneChannel = (redstoneChannel + 1) % 16;
		else
			redstoneChannelSending = (redstoneChannelSending + 1) % 16;
		func_70296_d();
		wireNetwork.updateValues();
		onChange();
		this.markContainingBlockForUpdate(null);
		field_145850_b.func_175641_c(func_174877_v(), this.func_145838_q(), 254, 0);
		return true;
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		nbt.func_74768_a("redstoneChannelSending", redstoneChannelSending);
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		redstoneChannelSending = nbt.func_74762_e("redstoneChannelSending");
	}

	@Override
	public Vec3d getConnectionOffset(Connection con)
	{
		EnumFacing side = facing.func_176734_d();
		double conRadius = con.cableType.getRenderDiameter() / 2;
		return new Vec3d(.5 + side.func_82601_c()*(.375-conRadius), .5 + side.func_96559_d()*(.375-conRadius), .5 + side.func_82599_e()*(.375-conRadius));
	}

	@Override
	public float[] getBlockBounds()
	{
		float wMin = .28125f;
		float wMax = .71875f;
		switch(facing.func_176734_d())
		{
			case UP:
			case DOWN:
				return new float[]{wMin, 0, wMin, wMax, 1, wMax};
			case SOUTH:
			case NORTH:
				return new float[]{wMin, wMin, 0, wMax, wMax, 1};
			case EAST:
			case WEST:
				return new float[]{0, wMin, wMin, 1, wMax, wMax};
		}
		return new float[]{0, 0, 0, 1, 1, 1};
	}

	@SideOnly(Side.CLIENT)
	@Override
	public boolean shouldRenderGroup(IBlockState object, String group)
	{
		if(MinecraftForgeClient.getRenderLayer()== BlockRenderLayer.SOLID)
			return false;
		if("glass".equals(group))
			return MinecraftForgeClient.getRenderLayer()== BlockRenderLayer.TRANSLUCENT;
		return MinecraftForgeClient.getRenderLayer()== BlockRenderLayer.CUTOUT;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public int getRenderColour(IBlockState object, String group)
	{
		if("colour_in".equals(group))
			return 0xff000000|EnumDyeColor.func_176764_b(this.redstoneChannel).func_193350_e();
		else if("colour_out".equals(group))
			return 0xff000000|EnumDyeColor.func_176764_b(this.redstoneChannelSending).func_193350_e();
		return 0xffffffff;
	}

	@Override
	public String getCacheKey(IBlockState object)
	{
		return redstoneChannel+";"+redstoneChannelSending;
	}

	@Override
	public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer)
	{
		if(!hammer)
			return null;
		return new String[]{
				I18n.func_135052_a(Lib.DESC_INFO + "redstoneChannel.rec", I18n.func_135052_a("item.fireworksCharge." + EnumDyeColor.func_176764_b(redstoneChannel).func_176762_d())),
				I18n.func_135052_a(Lib.DESC_INFO + "redstoneChannel.send", I18n.func_135052_a("item.fireworksCharge." + EnumDyeColor.func_176764_b(redstoneChannelSending).func_176762_d()))
		};
	}

	@Override
	public boolean useNixieFont(EntityPlayer player, RayTraceResult mop)
	{
		return false;
	}
}
