/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEEnums.SideConfig;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IBlockOverlayText;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IComparatorOverride;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IConfigurableSides;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.ITileDrop;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.EnergyHelper.IEForgeEnergyWrapper;
import blusunrize.immersiveengineering.common.util.EnergyHelper.IIEInternalFluxHandler;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

import javax.annotation.Nonnull;

public class TileEntityCapacitorLV extends TileEntityIEBase implements ITickable, IIEInternalFluxHandler, IBlockOverlayText, IConfigurableSides, IComparatorOverride, ITileDrop
{
	public SideConfig[] sideConfig={SideConfig.NONE,SideConfig.INPUT,SideConfig.NONE,SideConfig.NONE,SideConfig.NONE,SideConfig.NONE};
	FluxStorage energyStorage = new FluxStorage(getMaxStorage(),getMaxInput(),getMaxOutput());

	public int comparatorOutput=0;

	@Override
	public void func_73660_a()
	{
		if(!field_145850_b.field_72995_K)
		{
			for(int i=0; i<6; i++)
				this.transferEnergy(i);

			if(field_145850_b.func_82737_E()%32==((func_174877_v().func_177958_n()^func_174877_v().func_177952_p())&31))
			{
				int i = scaleStoredEnergyTo(15);
				if(i!=this.comparatorOutput)
				{
					this.comparatorOutput=i;
					field_145850_b.func_175666_e(func_174877_v(), func_145838_q());
				}
			}
		}
	}
	public int scaleStoredEnergyTo(int scale)
	{
		return (int)(scale*(energyStorage.getEnergyStored()/(float)energyStorage.getMaxEnergyStored()));
	}

	protected void transferEnergy(int side)
	{
		if(this.sideConfig[side] != SideConfig.OUTPUT)
			return;
		EnumFacing fd = EnumFacing.func_82600_a(side);
		BlockPos outPos = func_174877_v().func_177972_a(fd);
		TileEntity tileEntity = Utils.getExistingTileEntity(field_145850_b, outPos);
		int out = Math.min(getMaxOutput(), this.energyStorage.getEnergyStored());
		this.energyStorage.modifyEnergyStored(-EnergyHelper.insertFlux(tileEntity, fd.func_176734_d(), out, false));
	}
	@Override
	public IEEnums.SideConfig getSideConfig(int side)
	{
		return this.sideConfig[side];
	}
	@Override
	public boolean toggleSide(int side, EntityPlayer player)
	{
		sideConfig[side] = SideConfig.next(sideConfig[side]);
		this.func_70296_d();
		this.markContainingBlockForUpdate(null);
		field_145850_b.func_175641_c(func_174877_v(), this.func_145838_q(), 0, 0);
		return true;
	}
	@Override
	public boolean func_145842_c(int id, int arg)
	{
		if(id==0)
		{
			this.markContainingBlockForUpdate(null);
			return true;
		}
		return false;
	}

	public int getMaxStorage()
	{
		return IEConfig.Machines.capacitorLV_storage;
	}
	public int getMaxInput()
	{
		return IEConfig.Machines.capacitorLV_input;
	}
	public int getMaxOutput()
	{
		return IEConfig.Machines.capacitorLV_output;
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		for(int i=0; i<6; i++)
			nbt.func_74768_a("sideConfig_"+i, sideConfig[i].ordinal());
		energyStorage.writeToNBT(nbt);
	}
	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		if(nbt.func_74764_b("sideConfig"))//old NBT style
		{
			int[] old = nbt.func_74759_k("sideConfig");
			for(int i=0; i<old.length; i++)
				sideConfig[i] = SideConfig.values()[old[i]+1];
		}
		else
			for(int i=0; i<6; i++)
				sideConfig[i] = SideConfig.values()[nbt.func_74762_e("sideConfig_"+i)];
		energyStorage.readFromNBT(nbt);
	}


	IEForgeEnergyWrapper[] wrappers = IEForgeEnergyWrapper.getDefaultWrapperArray(this);
	@Nonnull
	@Override
	public FluxStorage getFluxStorage()
	{
		return this.energyStorage;
	}
	@Nonnull
	@Override
	public SideConfig getEnergySideConfig(EnumFacing facing)
	{
		if(facing==null)
			return SideConfig.NONE;
		return this.sideConfig[facing.ordinal()];
	}
	@Override
	public IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing)
	{
		if(facing==null)
			return null;
		return wrappers[facing.ordinal()];
	}

	@Override
	public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer)
	{
		if(hammer && IEConfig.colourblindSupport)
		{
			SideConfig i = sideConfig[Math.min(sideConfig.length-1, mop.field_178784_b.ordinal())];
			SideConfig j = sideConfig[Math.min(sideConfig.length-1, mop.field_178784_b.func_176734_d().ordinal())];
			return new String[]{
					I18n.func_135052_a(Lib.DESC_INFO+"blockSide.facing")
							+": "+ I18n.func_135052_a(Lib.DESC_INFO+"blockSide.connectEnergy."+i),
					I18n.func_135052_a(Lib.DESC_INFO+"blockSide.opposite")
							+": "+ I18n.func_135052_a(Lib.DESC_INFO+"blockSide.connectEnergy."+j)
			};
		}
		return null;
	}
	@Override
	public boolean useNixieFont(EntityPlayer player, RayTraceResult mop)
	{
		return false;
	}

	@Override
	public int getComparatorInputOverride()
	{
		return this.comparatorOutput;
	}

	@Override
	public ItemStack getTileDrop(EntityPlayer player, IBlockState state)
	{
		ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
		if(energyStorage.getEnergyStored()>0)
			ItemNBTHelper.setInt(stack, "energyStorage", energyStorage.getEnergyStored());
		for(int i=0; i<6; i++)
			ItemNBTHelper.setInt(stack, "sideConfig_"+i, sideConfig[i].ordinal());
		return stack;
	}
	@Override
	public void readOnPlacement(EntityLivingBase placer, ItemStack stack)
	{
		if(ItemNBTHelper.hasKey(stack, "energyStorage"))
			energyStorage.setEnergy(ItemNBTHelper.getInt(stack, "energyStorage"));
		for(int i=0; i<6; i++)
			if(ItemNBTHelper.hasKey(stack, "sideConfig_"+i))
				sideConfig[i] = SideConfig.values()[ItemNBTHelper.getInt(stack, "sideConfig_"+i)];
	}
}
