/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IDynamicTexture;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IHasObjProperty;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockBucketWheel;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.NetworkRegistry.TargetPoint;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.ArrayList;
import java.util.HashMap;

public class TileEntityBucketWheel extends TileEntityMultiblockPart<TileEntityBucketWheel> implements IHasObjProperty, IDynamicTexture
{
	public float rotation = 0;
	public NonNullList<ItemStack> digStacks = NonNullList.func_191197_a(8, ItemStack.field_190927_a);
	public boolean active = false;
	public ItemStack particleStack = ItemStack.field_190927_a;
	private static final int[] size = {7, 1, 7};
	public TileEntityBucketWheel()
	{
		super(size);
	}
	@Override
	public ItemStack getOriginalBlock()
	{
		if(pos<0)
			return ItemStack.field_190927_a;
		ItemStack s = pos<0?ItemStack.field_190927_a: MultiblockBucketWheel.instance.getStructureManual()[pos/7][pos%7][0];
		return s.func_77946_l();
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		float nbtRot = nbt.func_74760_g("rotation");
		rotation = (Math.abs(nbtRot-rotation)>5*IEConfig.Machines.excavator_speed)?nbtRot:rotation; // avoid stuttering due to packet delays
		digStacks = Utils.readInventory(nbt.func_150295_c("digStacks", 10), 8);
		active = nbt.func_74767_n("active");
		particleStack = nbt.func_74764_b("particleStack")?new ItemStack(nbt.func_74775_l("particleStack")):ItemStack.field_190927_a;
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		nbt.func_74776_a("rotation", rotation);
		nbt.func_74782_a("digStacks", Utils.writeInventory(digStacks));
		nbt.func_74757_a("active", active);
		if(!particleStack.func_190926_b())
			nbt.func_74782_a("particleStack", particleStack.func_77955_b(new NBTTagCompound()));
	}

	@Override
	protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side)
	{
		return new IFluidTank[0];
	}
	@Override
	protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources)
	{
		return false;
	}
	@Override
	protected boolean canDrainTankFrom(int iTank, EnumFacing side)
	{
		return false;
	}

	@Override
	public void func_73660_a()
	{
		ApiUtils.checkForNeedlessTicking(this);
		if(!formed || pos!=24)
			return;

		if(active)
		{
			rotation+=IEConfig.Machines.excavator_speed;
			rotation%=360;
		}

		if(field_145850_b.field_72995_K)
		{
			if(!particleStack.func_190926_b())
			{
				ImmersiveEngineering.proxy.spawnBucketWheelFX(this, particleStack);
				particleStack = ItemStack.field_190927_a;
			}
		}
		else if (active&&field_145850_b.func_82737_E()%20==0)
		{
			NBTTagCompound nbt = new NBTTagCompound();
			nbt.func_74776_a("rotation", rotation);
			MessageTileSync sync = new MessageTileSync(this, nbt);
			ImmersiveEngineering.packetHandler.sendToAllAround(sync, new TargetPoint(field_145850_b.field_73011_w.getDimension(),
					func_174877_v().func_177958_n(), func_174877_v().func_177956_o(), func_174877_v().func_177952_p(), 100));
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public HashMap<String,String> getTextureReplacements()
	{
		synchronized (digStacks)
		{
			HashMap<String,String> texMap = new HashMap<String,String>();
			for(int i = 0; i< this.digStacks.size(); i++)
				if(!this.digStacks.get(i).func_190926_b())
				{
					Block b = Block.func_149634_a(this.digStacks.get(i).func_77973_b());
					IBlockState state = b!=null?b.func_176203_a(this.digStacks.get(i).func_77960_j()): Blocks.field_150348_b.func_176223_P();
					IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
					if(model!=null && model.func_177554_e()!=null)
						texMap.put("dig"+i, model.func_177554_e().func_94215_i());
				}
			return texMap;
		}
	}
	static ArrayList<String> emptyDisplayList = new ArrayList<>();
	@Override
	public ArrayList<String> compileDisplayList()
	{
		return emptyDisplayList;
	}

	@Override
	public void receiveMessageFromServer(NBTTagCompound message)
	{
		synchronized (digStacks)
		{
			if (message.func_74764_b("fill"))
				this.digStacks.set(message.func_74762_e("fill"), new ItemStack(message.func_74775_l("fillStack")));
			if (message.func_74764_b("empty"))
				this.digStacks.set(message.func_74762_e("empty"), ItemStack.field_190927_a);
			if (message.func_74764_b("rotation"))
			{
				int packetRotation = message.func_74762_e("rotation");
				if (Math.abs(packetRotation-rotation)>5*IEConfig.Machines.excavator_speed)
					rotation = packetRotation;
			}
		}
	}

	@Override
	public boolean func_145842_c(int id, int arg)
	{
		if(id==0)
			this.active = (arg==1);
		return true;
	}

	@SideOnly(Side.CLIENT)
	private AxisAlignedBB renderAABB;
	@Override
	@SideOnly(Side.CLIENT)
	public AxisAlignedBB getRenderBoundingBox()
	{
		if(renderAABB==null)
//			if(pos==24)
			renderAABB = new AxisAlignedBB(func_174877_v().func_177982_a(-(facing.func_176740_k() == Axis.Z ? 3 : 0), -3, -(facing.func_176740_k() == Axis.X ? 3 : 0)), func_174877_v().func_177982_a((facing.func_176740_k() == Axis.Z ? 4 : 1), 4, (facing.func_176740_k() == Axis.X ? 4 : 1)));
//			else
//				renderAABB = new AxisAlignedBB(getPos(), getPos());
		return renderAABB;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public double func_145833_n()
	{
		return super.func_145833_n()* IEConfig.increasedTileRenderdistance;
	}
	@Override
	public float[] getBlockBounds()
	{
		if(pos==3||pos==9||pos==11)
			return new float[]{0,.25f,0, 1,1,1};
		else if(pos==45||pos==37||pos==39)
			return new float[]{0,0,0, 1,.75f,1};
		else if(pos==21)
			return new float[]{facing==EnumFacing.NORTH?.25f:0,0,facing==EnumFacing.WEST?.25f:0, facing==EnumFacing.SOUTH?.75f:1,1,facing==EnumFacing.EAST?.75f:1};
		else if(pos==27)
			return new float[]{facing==EnumFacing.SOUTH?.25f:0,0,facing==EnumFacing.EAST?.25f:0, facing==EnumFacing.NORTH?.75f:1,1,facing==EnumFacing.WEST?.75f:1};
		else if(pos==15||pos==29)
			return new float[]{facing==EnumFacing.NORTH?.25f:0,0,facing==EnumFacing.WEST?.25f:0, facing==EnumFacing.SOUTH?.75f:1,1,facing==EnumFacing.EAST?.75f:1};
		else if(pos==19||pos==33)
			return new float[]{facing==EnumFacing.SOUTH?.25f:0,0,facing==EnumFacing.EAST?.25f:0, facing==EnumFacing.NORTH?.75f:1,1,facing==EnumFacing.WEST?.75f:1};
		return new float[]{0,0,0,1,1,1};
	}
}
