/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums.SideConfig;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.api.tool.BelljarHandler.FluidFertilizerHandler;
import blusunrize.immersiveengineering.api.tool.BelljarHandler.IPlantHandler;
import blusunrize.immersiveengineering.api.tool.BelljarHandler.ItemFertilizerHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IBlockBounds;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IDirectionalTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IGuiTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IHasDummyBlocks;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper.IEForgeEnergyWrapper;
import blusunrize.immersiveengineering.common.util.EnergyHelper.IIEInternalFluxHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry.TargetPoint;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Optional;

public class TileEntityBelljar extends TileEntityIEBase implements ITickable, IDirectionalTile, IBlockBounds, IHasDummyBlocks, IIEInventory, IIEInternalFluxHandler, IGuiTile, IOBJModelCallback<IBlockState>
{
	public EnumFacing facing = EnumFacing.NORTH;
	public int dummy = 0;
	private NonNullList<ItemStack> inventory = NonNullList.func_191197_a(7, ItemStack.field_190927_a);
	public FluidTank tank = new FluidTank(4000)
	{
		@Override
		protected void onContentsChanged()
		{
			TileEntityBelljar.this.sendSyncPacket(2);
		}
	};
	public FluxStorage energyStorage = new FluxStorage(16000,Math.max(256,IEConfig.Machines.belljar_consumption));

	private IPlantHandler curPlantHandler;
	public int fertilizerAmount = 0;
	public float fertilizerMod = 1;
	private float growth = 0;
	public float renderGrowth = 0;
	public boolean renderActive = false;

	@Override
	public void func_73660_a()
	{
		ApiUtils.checkForNeedlessTicking(this);
		if(dummy!=0 || field_145850_b.func_175687_A(func_174877_v())>0)
			return;
		if(func_145831_w().field_72995_K)
		{
			if(energyStorage.getEnergyStored()>IEConfig.Machines.belljar_consumption && fertilizerAmount>0 && renderActive)
			{
				IPlantHandler handler = getCurrentPlantHandler();
				if(handler!=null&&handler.isCorrectSoil(inventory.get(1), inventory.get(0)) && fertilizerAmount>0)
				{
					if(renderGrowth<1)
					{
						renderGrowth += handler.getGrowthStep(inventory.get(1), inventory.get(0), renderGrowth, this, fertilizerMod, true);
						fertilizerAmount--;
					}
					else
						renderGrowth = handler.resetGrowth(inventory.get(1), inventory.get(0), renderGrowth, this, true);
					if(Utils.RAND.nextInt(8)==0)
					{
						double partX = func_174877_v().func_177958_n()+.5;
						double partY = func_174877_v().func_177956_o()+2.6875;
						double partZ = func_174877_v().func_177952_p()+.5;
						ImmersiveEngineering.proxy.spawnRedstoneFX(func_145831_w(), partX, partY, partZ, .25, .25, .25, 1f, .55f, .1f, .1f);
					}
				}
			}
		}
		else
		{
			if(!inventory.get(1).func_190926_b())
			{
				IPlantHandler handler = getCurrentPlantHandler();
				if(handler!=null&&handler.isCorrectSoil(inventory.get(1), inventory.get(0)) && fertilizerAmount>0 && energyStorage.extractEnergy(IEConfig.Machines.belljar_consumption, true)==IEConfig.Machines.belljar_consumption)
				{
					boolean consume = false;
					if(growth >= 1)
					{
						ItemStack[] outputs = handler.getOutput(inventory.get(1), inventory.get(0), this);
						int canFit = 0;
						boolean[] emptySlotsUsed = new boolean[4];
						for(int i=0; i<outputs.length; i++)
							if(!outputs[i].func_190926_b())
								for(int j = 3; j < 7; j++)
									if((inventory.get(j).func_190926_b()&&!emptySlotsUsed[j-3])||(ItemHandlerHelper.canItemStacksStack(inventory.get(j), outputs[i])&&inventory.get(j).func_190916_E()+outputs[i].func_190916_E() <= inventory.get(j).func_77976_d()))
									{
										canFit++;
										if(inventory.get(j).func_190926_b())
											emptySlotsUsed[j-3] = true;
										break;
									}
						if(canFit>=outputs.length)
						{
							for(ItemStack output : outputs)
								for(int j=3;j<7;j++)
								{
									if(inventory.get(j).func_190926_b())
									{
										inventory.set(j, output.func_77946_l());
										break;
									}
									else if(ItemHandlerHelper.canItemStacksStack(inventory.get(j), output)&& inventory.get(j).func_190916_E()+output.func_190916_E() <= inventory.get(j).func_77976_d())
									{
										inventory.get(j).func_190917_f(output.func_190916_E());
										break;
									}
								}
							growth = handler.resetGrowth(inventory.get(1), inventory.get(0), growth, this, false);
							consume = true;
						}
					}
					else if(growth < 1)
					{
						growth += Config.IEConfig.Machines.belljar_growth_mod * handler.getGrowthStep(inventory.get(1), inventory.get(0), growth, this, fertilizerMod, false);
						consume = true;
						if(field_145850_b.func_82737_E()%32==((func_174877_v().func_177958_n()^func_174877_v().func_177952_p())&31))
							sendSyncPacket(0);
					}
					if(consume)
					{
						energyStorage.extractEnergy(IEConfig.Machines.belljar_consumption, false);
						fertilizerAmount--;
						if(!renderActive)
						{
							renderActive = true;
							sendSyncPacket(0);
						}
					}
					else if(renderActive)
					{
						renderActive = false;
						sendSyncPacket(0);
					}
				}
				else
					growth = 0;

				if(fertilizerAmount<=0 && tank.getFluidAmount()>=IEConfig.Machines.belljar_fluid)
				{
					FluidFertilizerHandler fluidFert = BelljarHandler.getFluidFertilizerHandler(tank.getFluid());
					if(fluidFert!=null)
					{
						fertilizerMod = fluidFert.getGrowthMultiplier(tank.getFluid(), inventory.get(1), inventory.get(0), this);
						tank.drain(IEConfig.Machines.belljar_fluid, true);
						if(!inventory.get(2).func_190926_b())
						{
							ItemFertilizerHandler itemFert = BelljarHandler.getItemFertilizerHandler(inventory.get(2));
							if(itemFert!=null)
								fertilizerMod *= itemFert.getGrowthMultiplier(inventory.get(2), inventory.get(1), inventory.get(0), this);
							inventory.get(2).func_190918_g(1);
							if(inventory.get(2).func_190916_E()<=0)
								inventory.set(2, ItemStack.field_190927_a);
						}
						fertilizerAmount = IEConfig.Machines.belljar_fertilizer;
						sendSyncPacket(1);
					}
				}
			}
			else
				growth = 0;

			if(field_145850_b.func_82737_E()%8==0)
			{
				BlockPos outputPos = func_174877_v().func_177984_a().func_177972_a(facing.func_176734_d());
				TileEntity outputTile = Utils.getExistingTileEntity(field_145850_b, outputPos);
				if (outputTile != null)
					for (int j = 3; j < 7; j++)
						if (!inventory.get(j).func_190926_b())
						{
							int out = Math.min(inventory.get(j).func_190916_E(), 16);
							ItemStack stack = Utils.copyStackWithAmount(inventory.get(j), out);
							stack = Utils.insertStackIntoInventory(outputTile, stack, facing);
							if (!stack.func_190926_b())
								out -= stack.func_190916_E();
							this.inventory.get(j).func_190918_g(out);
							if ((inventory.get(j).func_190916_E()) <= 0)
								this.inventory.set(j, ItemStack.field_190927_a);
						}
			}
		}
	}

	public IPlantHandler getCurrentPlantHandler()
	{
		if(curPlantHandler==null || !curPlantHandler.isValid(inventory.get(1)))
			curPlantHandler = BelljarHandler.getHandler(inventory.get(1));
		return curPlantHandler;
	}

	protected void sendSyncPacket(int type)
	{
		NBTTagCompound nbt = new NBTTagCompound();
		if(type==0)
		{
			nbt.func_74776_a("growth", growth);
			nbt.func_74768_a("energy", energyStorage.getEnergyStored());
			nbt.func_74757_a("renderActive", renderActive);
		}
		else if(type==1)
		{
			nbt.func_74768_a("fertilizerAmount", fertilizerAmount);
			nbt.func_74776_a("fertilizerMod", fertilizerMod);
		}
		else if(type==2)
			nbt.func_74782_a("tank", tank.writeToNBT(new NBTTagCompound()));
		ImmersiveEngineering.packetHandler.sendToAllAround(new MessageTileSync(this, nbt), new TargetPoint(field_145850_b.field_73011_w.getDimension(),func_174877_v().func_177958_n(), func_174877_v().func_177956_o(), func_174877_v().func_177952_p(), 128));
	}
	@Override
	public void receiveMessageFromServer(NBTTagCompound message)
	{
		if(message.func_74764_b("growth"))
			renderGrowth = message.func_74760_g("growth");
		if(message.func_74764_b("renderActive"))
			renderActive = message.func_74767_n("renderActive");
		if(message.func_74764_b("energy"))
			energyStorage.setEnergy(message.func_74762_e("energy"));
		if(message.func_74764_b("fertilizerAmount"))
			fertilizerAmount = message.func_74762_e("fertilizerAmount");
		if(message.func_74764_b("fertilizerMod"))
			fertilizerMod = message.func_74760_g("fertilizerMod");
		if(message.func_74764_b("tank"))
			tank.readFromNBT(message.func_74775_l("tank"));
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
		dummy = nbt.func_74762_e("dummy");
		inventory = Utils.readInventory(nbt.func_150295_c("inventory",10),7);
		energyStorage.readFromNBT(nbt);
		tank.readFromNBT(nbt.func_74775_l("tank"));
		fertilizerAmount = nbt.func_74762_e("fertilizerAmount");
		fertilizerMod = nbt.func_74760_g("fertilizerMod");
		growth = nbt.func_74760_g("growth");
		renderBB = null;
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74768_a("facing", facing.ordinal());
		nbt.func_74768_a("dummy", dummy);
		nbt.func_74782_a("inventory", Utils.writeInventory(inventory));
		energyStorage.writeToNBT(nbt);
		NBTTagCompound tankTag = tank.writeToNBT(new NBTTagCompound());
		nbt.func_74782_a("tank", tankTag);
		nbt.func_74768_a("fertilizerAmount", fertilizerAmount);
		nbt.func_74776_a("fertilizerMod", fertilizerMod);
		nbt.func_74776_a("growth", growth);
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}
	@Override
	public int getFacingLimitation()
	{
		return 2;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return true;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return true;
	}

	@Override
	public float[] getBlockBounds()
	{
		return null;//new float[]{facing==EnumFacing.EAST?0:.25f,facing==EnumFacing.UP?0:facing==EnumFacing.DOWN?.125f:.0625f,facing==EnumFacing.SOUTH?0:.25f, facing==EnumFacing.WEST?1:.75f,facing==EnumFacing.DOWN?1:.875f,facing==EnumFacing.NORTH?1:.75f};
	}

	@Override
	public boolean isDummy()
	{
		return dummy!=0;
	}
	@Override
	public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		for(int i=1; i<=2; i++)
		{
			field_145850_b.func_175656_a(pos.func_177981_b(i), state);
			((TileEntityBelljar)field_145850_b.func_175625_s(pos.func_177981_b(i))).dummy = i;
			((TileEntityBelljar)field_145850_b.func_175625_s(pos.func_177981_b(i))).facing = facing;
		}
	}
	@Override
	public void breakDummies(BlockPos pos, IBlockState state)
	{
		for(int i=0; i<=2; i++)
		{
			BlockPos p = func_174877_v().func_177979_c(dummy).func_177981_b(i);
			if(field_145850_b.func_175625_s(p) instanceof TileEntityBelljar)
				field_145850_b.func_175698_g(p);
		}
	}

	@Override
	public NonNullList<ItemStack> getInventory()
	{
		return inventory;
	}
	@Override
	public boolean isStackValid(int slot, ItemStack stack)
	{
		return true;
	}
	@Override
	public int getSlotLimit(int slot)
	{
		return slot<2?1:64;
	}
	@Override
	public void doGraphicalUpdates(int slot)
	{
		if(slot==0)
		{
			this.func_70296_d();
			this.markContainingBlockForUpdate(null);
		}
	}


	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		if (getGuiMaster()!=null)
		{
			if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
				return dummy == 0 ? (facing == null || facing.func_176740_k() != this.facing.func_176746_e().func_176740_k()) : dummy == 1 && (facing == null || facing == this.facing.func_176734_d());
			else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)
				return dummy == 0 && (facing == null || facing.func_176740_k() != this.facing.func_176746_e().func_176740_k());
		}
		return super.hasCapability(capability, facing);
	}
	IItemHandler inputHandler = new IEInventoryHandler(1,this,2, true,false);
	IItemHandler outputHandler = new IEInventoryHandler(4,this,3, false,true);
	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if(capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
		{
			if(dummy==0 && (facing==null||facing.func_176740_k()!=this.facing.func_176746_e().func_176740_k()))
				return (T)inputHandler;
			if(dummy==1 && (facing==null||facing==this.facing.func_176734_d()))
			{
				TileEntityBelljar te = getGuiMaster();
				if(te!=null)
					return (T) te.outputHandler;
			}
		}
		else if(capability==CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && dummy==0 && (facing==null||facing.func_176740_k()!=this.facing.func_176746_e().func_176740_k()))
			return (T)tank;
		return super.getCapability(capability, facing);
	}

	@Override
	public boolean canOpenGui()
	{
		return true;
	}
	@Override
	public int getGuiID()
	{
		return Lib.GUIID_Belljar;
	}
	@Override
	public TileEntityBelljar getGuiMaster()
	{
		if(dummy==0)
			return this;
		TileEntity te = field_145850_b.func_175625_s(func_174877_v().func_177979_c(dummy));
		if(te instanceof TileEntityBelljar)
			return (TileEntityBelljar) te;
		return null;
	}


	@Override
	@SideOnly(Side.CLIENT)
	public TextureAtlasSprite getTextureReplacement(IBlockState object, String material)
	{
		if(!inventory.get(0).func_190926_b() && "farmland".equals(material))
		{
			ResourceLocation rl = getSoilTexture();
			if(rl!=null)
				return ClientUtils.getSprite(rl);
		}
		return null;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public boolean shouldRenderGroup(IBlockState object, String group)
	{
		return !"glass".equals(group);
	}
	@Override
	@SideOnly(Side.CLIENT)
	public Optional<TRSRTransformation> applyTransformations(IBlockState object, String group, Optional<TRSRTransformation> transform)
	{
		return transform;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public String getCacheKey(IBlockState object)
	{
		if(!inventory.get(0).func_190926_b())
		{
			ResourceLocation rl = getSoilTexture();
			if(rl!=null)
				return rl.toString();
		}
		return null;
	}
	@SideOnly(Side.CLIENT)
	private ResourceLocation getSoilTexture()
	{
		ResourceLocation rl = curPlantHandler!=null?curPlantHandler.getSoilTexture(inventory.get(1), inventory.get(0), this):null;
		if(rl==null)
			rl=BelljarHandler.getSoilTexture(inventory.get(0));
		if(rl==null)
		{
			try
			{
				IBlockState state = Utils.getStateFromItemStack(inventory.get(0));
				if(state!=null)
					rl = ClientUtils.getSideTexture(state, EnumFacing.UP);
			}catch(Exception e)
			{
				rl = ClientUtils.getSideTexture(inventory.get(0), EnumFacing.UP);
			}
		}
		if(rl==null && !inventory.get(0).func_190926_b() && Utils.isFluidRelatedItemStack(inventory.get(0)))
		{
			FluidStack fs = FluidUtil.getFluidContained(inventory.get(0));
			if(fs!=null)
				rl = fs.getFluid().getStill(fs);
		}
		return rl;
	}

	@Nonnull
	@Override
	public FluxStorage getFluxStorage()
	{
		if(dummy!=0)
		{
			TileEntity te = field_145850_b.func_175625_s(func_174877_v().func_177979_c(dummy));
			if(te instanceof TileEntityBelljar)
				return ((TileEntityBelljar)te).energyStorage;
		}
		return this.energyStorage;
	}
	@Nonnull
	@Override
	public SideConfig getEnergySideConfig(@Nullable EnumFacing facing)
	{
		return facing==null||(dummy==0&&facing.func_176740_k()==this.facing.func_176746_e().func_176740_k())||(dummy==2&&facing==EnumFacing.UP)?SideConfig.INPUT:SideConfig.NONE;
	}
	IEForgeEnergyWrapper energyWrapper = new IEForgeEnergyWrapper(this, null);
	@Override
	public IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing)
	{
		if(facing==null||(dummy==0&&facing.func_176740_k()==this.facing.func_176746_e().func_176740_k())||(dummy==2&&facing==EnumFacing.UP))
			return energyWrapper;
		return null;
	}
	AxisAlignedBB renderBB;
	@Override
	public AxisAlignedBB getRenderBoundingBox()
	{
		if (renderBB==null)
			renderBB = new AxisAlignedBB(0, 0, 0, 1, 2, 1).func_186670_a(field_174879_c);
		return renderBB;
	}
}
