/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IAdvancedCollisionBounds;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IAdvancedSelectionBounds;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IGuiTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.ISoundTile;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockArcFurnace;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import com.google.common.collect.Lists;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

import java.util.*;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal.MultiblockProcessInMachine;

public class TileEntityArcFurnace extends TileEntityMultiblockMetal<TileEntityArcFurnace,ArcFurnaceRecipe> implements ISoundTile,IGuiTile, IAdvancedSelectionBounds,IAdvancedCollisionBounds
{
	public TileEntityArcFurnace()
	{
		super(MultiblockArcFurnace.instance, new int[]{5,5,5}, 64000, true);
	}
	public NonNullList<ItemStack> inventory = NonNullList.func_191197_a(26, ItemStack.field_190927_a);
	public int pouringMetal = 0;

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.readCustomNBT(nbt, descPacket);
		if(!descPacket)
			inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 26);
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		super.writeCustomNBT(nbt, descPacket);
		if(!descPacket)
			nbt.func_74782_a("inventory", Utils.writeInventory(inventory));
	}

	@Override
	public void func_73660_a()
	{
		super.func_73660_a();
		if (isDummy())
			return;
		if(field_145850_b.field_72995_K)
		{
			if(pouringMetal>0)
				pouringMetal--;
			if(shouldRenderAsActive())
				for(int i=0; i<4; i++)
				{
					if(Utils.RAND.nextInt(6)==0)
						ImmersiveEngineering.proxy.spawnSparkFX(field_145850_b, func_174877_v().func_177958_n()+.5-.25*facing.func_82601_c(),
								func_174877_v().func_177956_o()+2.9,func_174877_v().func_177952_p()+.5-.25*facing.func_82599_e(),
								Utils.RAND.nextDouble()*.05-.025, .025, Utils.RAND.nextDouble()*.05-.025);
					if(Utils.RAND.nextInt(6)==0)
						ImmersiveEngineering.proxy.spawnSparkFX(field_145850_b, func_174877_v().func_177958_n()+.5+(facing==EnumFacing.EAST?-.25:.25),
								func_174877_v().func_177956_o()+2.9,func_174877_v().func_177952_p()+.5+(facing==EnumFacing.SOUTH?.25:-.25),
								Utils.RAND.nextDouble()*.05-.025, .025, Utils.RAND.nextDouble()*.05-.025);
					if(Utils.RAND.nextInt(6)==0)
						ImmersiveEngineering.proxy.spawnSparkFX(field_145850_b, func_174877_v().func_177958_n()+.5+(facing==EnumFacing.WEST?.25:-.25),
								func_174877_v().func_177956_o()+2.9,func_174877_v().func_177952_p()+.5+(facing==EnumFacing.NORTH?-.25:.25),
								Utils.RAND.nextDouble()*.05-.025, .025, Utils.RAND.nextDouble()*.05-.025);
				}
		}
		else if (!isRSDisabled() && energyStorage.getEnergyStored() > 0)
		{
			if (this.tickedProcesses > 0)
				for (int i = 23; i < 26; i++)
					if (this.inventory.get(i).func_96631_a(1, Utils.RAND, null))
					{
						this.inventory.set(i, ItemStack.field_190927_a);
						//						updateClient = true;
						//						update = true;
					}

			if (this.processQueue.size() < this.getProcessQueueMaxLength())
			{
				Set<Integer> usedInvSlots = new HashSet<Integer>();
				//			final int[] usedInvSlots = new int[8];
				for (MultiblockProcess<ArcFurnaceRecipe> process : processQueue)
					if (process instanceof MultiblockProcessInMachine)
						for (int i : ((MultiblockProcessInMachine<ArcFurnaceRecipe>) process).inputSlots)
							usedInvSlots.add(i);

				//			Integer[] preferredSlots = new Integer[]{0,1,2,3,4,5,6,7};
				//			Arrays.sort(preferredSlots, 0,8, new Comparator<Integer>(){
				//				@Override
				//				public int compare(Integer arg0, Integer arg1)
				//				{
				//					return Integer.compare(usedInvSlots[arg0],usedInvSlots[arg1]);
				//				}});
				NonNullList<ItemStack> additives = NonNullList.func_191197_a(4, ItemStack.field_190927_a);
				for (int i = 0; i < 4; i++)
					additives.set(i, !inventory.get(12 + i).func_190926_b() ? inventory.get(12 + i).func_77946_l() : ItemStack.field_190927_a);
				for (int slot = 0; slot < 12; slot++)
					if (!usedInvSlots.contains(slot))
					{
						ItemStack stack = this.getInventory().get(slot);
						//				if(stack!=null)
						//				{
						//					stack = stack.copy();
						////					stack.stackSize-=usedInvSlots[slot];
						//				}
						if (!stack.func_190926_b() && stack.func_190916_E() > 0)
						{
							ArcFurnaceRecipe recipe = ArcFurnaceRecipe.findRecipe(stack, additives);

							if (recipe != null)
							{
								MultiblockProcessArcFurnace process = new MultiblockProcessArcFurnace(recipe, slot, 12, 13, 14, 15);
								if (this.addProcessToQueue(process, true))
								{
									this.addProcessToQueue(process, false);
									usedInvSlots.add(slot);
									//							update = true;
								}
							}
						}
					}
			}

			if (field_145850_b.func_82737_E() % 8 == 0)
			{
				BlockPos outputPos = this.getBlockPosForPos(2).func_177967_a(facing, -1);
				TileEntity outputTile = Utils.getExistingTileEntity(field_145850_b, outputPos);
				if (outputTile != null)
					for (int j = 16; j < 22; j++)
						if (!inventory.get(j).func_190926_b())
						{
							ItemStack stack = Utils.copyStackWithAmount(inventory.get(j), 1);
							stack = Utils.insertStackIntoInventory(outputTile, stack, facing.func_176734_d());
							if (stack.func_190926_b())
							{
								this.inventory.get(j).func_190918_g(1);
								if (this.inventory.get(j).func_190916_E() <= 0)
									this.inventory.set(j, ItemStack.field_190927_a);
							}
						}
				outputPos = this.getBlockPosForPos(22).func_177972_a(facing);
				outputTile = Utils.getExistingTileEntity(field_145850_b, outputPos);
				if (outputTile != null)
					if (!inventory.get(22).func_190926_b())
					{
						int out = Math.min(inventory.get(22).func_190916_E(), 16);
						ItemStack stack = Utils.copyStackWithAmount(inventory.get(22), out);
						stack = Utils.insertStackIntoInventory(outputTile, stack, facing);
						if (!stack.func_190926_b())
							out -= stack.func_190916_E();
						this.inventory.get(22).func_190918_g(out);
						if (this.inventory.get(22).func_190916_E() <= 0)
							this.inventory.set(22, ItemStack.field_190927_a);
					}
			}
		}
	}

	@Override
	public boolean func_145842_c(int id, int type)
	{
		if (id==0)
			pouringMetal = type;
		return super.func_145842_c(id, type);
	}

	@SideOnly(Side.CLIENT)
	private AxisAlignedBB renderAABB;
	@SideOnly(Side.CLIENT)
	@Override
	public AxisAlignedBB getRenderBoundingBox()
	{
		//		if(renderAABB==null)
		//			if(pos==17)
		//				renderAABB = AxisAlignedBB.getBoundingBox(xCoord-(facing==2||facing==3?2:1),yCoord,zCoord-(facing==4||facing==5?2:1), xCoord+(facing==2||facing==3?3:2),yCoord+3,zCoord+(facing==4||facing==5?3:2));
		//			else
		//				renderAABB = AxisAlignedBB.getBoundingBox(xCoord,yCoord,zCoord, xCoord,yCoord,zCoord);
		//		return renderAABB;
		return new AxisAlignedBB(func_174877_v().func_177958_n()-(facing.func_176740_k()==Axis.Z?2:1),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()-(facing.func_176740_k()==Axis.X?2:1), func_174877_v().func_177958_n()+(facing.func_176740_k()==Axis.Z?3:2),func_174877_v().func_177956_o()+3,func_174877_v().func_177952_p()+(facing.func_176740_k()==Axis.X?3:2));
	}
	@Override
	@SideOnly(Side.CLIENT)
	public double func_145833_n()
	{
		return super.func_145833_n()* IEConfig.increasedTileRenderdistance;
	}
	@Override
	public float[] getBlockBounds()
	{
		if(pos==1||pos==3)
			return new float[]{facing==EnumFacing.EAST?.4375f:0,0,facing==EnumFacing.SOUTH?.4375f:0, facing==EnumFacing.WEST?.5625f:1,.5f,facing==EnumFacing.NORTH?.5625f:1};
		else if(pos<20 && pos!=2)
			return new float[]{0,0,0,1,.5f,1};
		else if(pos==25)
			return new float[]{facing==EnumFacing.WEST?.5f:0,0,facing==EnumFacing.NORTH?.5f:0, facing==EnumFacing.EAST?.5f:1,1,facing==EnumFacing.SOUTH?.5f:1};
		else if((pos>=36&&pos<=38) || (pos>=41&&pos<=43))
		{
			EnumFacing fw = facing.func_176746_e();
			if(mirrored|pos%5==3)
				fw = fw.func_176734_d();
			if(pos%5==2)
				fw=null;
			float minX = fw==EnumFacing.EAST?.125f: 0;
			float maxX = fw==EnumFacing.WEST?.875f: 1;
			float minZ = fw==EnumFacing.SOUTH?.125f: 0;
			float maxZ = fw==EnumFacing.NORTH?.875f: 1;
			if(pos<=38)
			{
				minX -= facing==EnumFacing.EAST?.875f:0;
				maxX += facing==EnumFacing.WEST?.875f:0;
				minZ -= facing==EnumFacing.SOUTH?.875f:0;
				maxZ += facing==EnumFacing.NORTH?.875f:0;
			}
			return new float[]{minX,.5f,minZ, maxX,1,maxZ};
		}
		else if(pos==40||pos==44)
		{
			EnumFacing fl = pos==44?facing.func_176734_d():facing;
			return new float[]{fl==EnumFacing.NORTH?.125f:fl==EnumFacing.SOUTH?.625f:0,.125f,fl==EnumFacing.EAST?.125f:fl==EnumFacing.WEST?.625f:0, fl==EnumFacing.SOUTH?.875f:fl==EnumFacing.NORTH?.375f:1,.375f,fl==EnumFacing.WEST?.875f:fl==EnumFacing.EAST?.375f:1};
		}
		else if(pos>=46&&pos<=48)
			return new float[]{facing==EnumFacing.WEST?.25f:0,0,facing==EnumFacing.NORTH?.25f:0, facing==EnumFacing.EAST?.75f:1,1,facing==EnumFacing.SOUTH?.75f:1};
		else if(pos==97)
			return new float[]{facing.func_176740_k()==Axis.X?.375f:0,0,facing.func_176740_k()==Axis.Z?.375f:0,facing.func_176740_k()==Axis.X?.625f:1,1,facing.func_176740_k()==Axis.Z?.625f:1};
		else if(pos==122)
			return new float[]{facing==EnumFacing.WEST?.3125f:0,0,facing==EnumFacing.NORTH?.3125f:0,facing==EnumFacing.EAST?.6875f:1,.9375f,facing==EnumFacing.SOUTH?.6875f:1};
		else if(pos==117)
			return new float[]{0,.625f,0,1,.9375f,1};
		else if(pos==112)
			return new float[]{facing==EnumFacing.EAST?.125f:0,0,facing==EnumFacing.SOUTH?.125f:0,facing==EnumFacing.WEST?.875f:1,.9375f,facing==EnumFacing.NORTH?.875f:1};
		else if(pos==51||pos==53 || pos==96||pos==98||pos==121||pos==123)
		{
			EnumFacing fw = facing.func_176746_e();
			if(mirrored ^ pos % 5 == 3)
				fw = fw.func_176734_d();
			return new float[]{fw==EnumFacing.EAST?.5f:0,0,fw==EnumFacing.SOUTH?.5f:0, fw==EnumFacing.WEST?.5f:1,1,fw==EnumFacing.NORTH?.5f:1};
		}
		return new float[]{0,0,0,1,1,1};
	}
	@Override
	public List<AxisAlignedBB> getAdvancedSelectionBounds()
	{
		if(pos%15==7)
			return null;
		EnumFacing fl = facing;
		EnumFacing fw = facing.func_176746_e();
		if(mirrored)
			fw = fw.func_176734_d();
		if(pos==0)
		{
			List<AxisAlignedBB> list = Lists.newArrayList(new AxisAlignedBB(0,0,0, 1,.5f,1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			float minX = fl==EnumFacing.WEST?.625f: fl==EnumFacing.EAST?.125f: .125f;
			float maxX = fl==EnumFacing.EAST?.375f: fl==EnumFacing.WEST?.875f: .25f;
			float minZ = fl==EnumFacing.NORTH?.625f: fl==EnumFacing.SOUTH?.125f: .125f;
			float maxZ = fl==EnumFacing.SOUTH?.375f: fl==EnumFacing.NORTH?.875f: .25f;
			list.add(new AxisAlignedBB(minX,.5f,minZ, maxX,1,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));

			minX = fl==EnumFacing.WEST?.625f: fl==EnumFacing.EAST?.125f: .75f;
			maxX = fl==EnumFacing.EAST?.375f: fl==EnumFacing.WEST?.875f: .875f;
			minZ = fl==EnumFacing.NORTH?.625f: fl==EnumFacing.SOUTH?.125f: .75f;
			maxZ = fl==EnumFacing.SOUTH?.375f: fl==EnumFacing.NORTH?.875f: .875f;
			list.add(new AxisAlignedBB(minX,.5f,minZ, maxX,1,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			return list;
		}
		else if(pos>=46&&pos<=48)
		{
			float minX = fl==EnumFacing.WEST?.25f:0;
			float maxX = fl==EnumFacing.EAST?.75f:1;
			float minZ = fl==EnumFacing.NORTH?.25f:0;
			float maxZ = fl==EnumFacing.SOUTH?.75f:1;
			List<AxisAlignedBB> list = Lists.newArrayList(new AxisAlignedBB(minX,0,minZ,maxX,1,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));

			minX = fl==EnumFacing.WEST?0: fl==EnumFacing.EAST?.75f: .25f;
			maxX = fl==EnumFacing.EAST?1: fl==EnumFacing.WEST?.25f: .75f;
			minZ = fl==EnumFacing.NORTH?0: fl==EnumFacing.SOUTH?.75f: .25f;
			maxZ = fl==EnumFacing.SOUTH?1: fl==EnumFacing.NORTH?.25f: .75f;
			list.add(new AxisAlignedBB(minX,.25f,minZ, maxX,.75,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			return list;
		}
		else if(pos%25>=10 && (pos%5==0||pos%5==4))
		{
			List<AxisAlignedBB> list = pos<25?Lists.newArrayList(new AxisAlignedBB(0,0,0, 1,.5f,1).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p())):new ArrayList(2);
			if(pos%5==4)
				fw = fw.func_176734_d();
			float minX = fw==EnumFacing.EAST?.5f: 0;
			float maxX = fw==EnumFacing.WEST?.5f: 1;
			float minZ = fw==EnumFacing.SOUTH?.5f: 0;
			float maxZ = fw==EnumFacing.NORTH?.5f: 1;
			if(pos%25/5!=3)
				list.add(new AxisAlignedBB(minX,pos<25?.5:0,minZ, maxX,1,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			if(pos<25)
			{
				minX = fw==EnumFacing.EAST?.125f: fw==EnumFacing.WEST?.625f: fl==EnumFacing.EAST?.375f:-1.625f;
				maxX = fw==EnumFacing.EAST?.375f: fw==EnumFacing.WEST?.875f: fl==EnumFacing.WEST?.625f: 2.625f;
				minZ = fw==EnumFacing.SOUTH?.125f: fw==EnumFacing.NORTH?.625f: fl==EnumFacing.SOUTH?.375f:-1.625f;
				maxZ = fw==EnumFacing.SOUTH?.375f: fw==EnumFacing.NORTH?.875f: fl==EnumFacing.NORTH?.625f: 2.625f;
				AxisAlignedBB aabb = new AxisAlignedBB(minX,.6875,minZ, maxX,.9375,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p());
				aabb = aabb.func_72317_d(-fl.func_82601_c()*(pos%25-10)/5,0,-fl.func_82599_e()*(pos%25-10)/5);
				list.add(aabb);

				minX = fw==EnumFacing.EAST?.375f: fw==EnumFacing.WEST?.5f: fl==EnumFacing.EAST?.375f: .375f;
				maxX = fw==EnumFacing.EAST?.5f: fw==EnumFacing.WEST?.625f: fl==EnumFacing.WEST?.625f: .625f;
				minZ = fw==EnumFacing.SOUTH?.375f: fw==EnumFacing.NORTH?.5f: fl==EnumFacing.SOUTH?.375f: .375f;
				maxZ = fw==EnumFacing.SOUTH?.5f: fw==EnumFacing.NORTH?.625f: fl==EnumFacing.NORTH?.625f: .625f;
				aabb = new AxisAlignedBB(minX,.6875,minZ, maxX,.9375,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p());
				aabb = aabb.func_72317_d(-fl.func_82601_c()*(pos%25-10)/5,0,-fl.func_82599_e()*(pos%25-10)/5);
				list.add(aabb);

				minX = fw==EnumFacing.EAST?.375f: fw==EnumFacing.WEST?.5f: fl==EnumFacing.EAST?2.375f:-1.625f;
				maxX = fw==EnumFacing.EAST?.5f: fw==EnumFacing.WEST?.625f: fl==EnumFacing.WEST?-1.375f: 2.625f;
				minZ = fw==EnumFacing.SOUTH?.375f: fw==EnumFacing.NORTH?.5f: fl==EnumFacing.SOUTH?2.375f:-1.625f;
				maxZ = fw==EnumFacing.SOUTH?.5f: fw==EnumFacing.NORTH?.625f: fl==EnumFacing.NORTH?-1.375f: 2.625f;
				aabb = new AxisAlignedBB(minX,.6875,minZ, maxX,.9375,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p());
				aabb = aabb.func_72317_d(-fl.func_82601_c()*(pos%25-10)/5,0,-fl.func_82599_e()*(pos%25-10)/5);
				list.add(aabb);
			}
			else if(pos<50)
			{
				minX = fw==EnumFacing.EAST?.125f: fw==EnumFacing.WEST?.625f: fl==EnumFacing.EAST?.375f:-1.625f;
				maxX = fw==EnumFacing.EAST?.375f: fw==EnumFacing.WEST?.875f: fl==EnumFacing.WEST?.625f: 2.625f;
				minZ = fw==EnumFacing.SOUTH?.125f: fw==EnumFacing.NORTH?.625f: fl==EnumFacing.SOUTH?.375f:-1.625f;
				maxZ = fw==EnumFacing.SOUTH?.375f: fw==EnumFacing.NORTH?.875f: fl==EnumFacing.NORTH?.625f: 2.625f;
				AxisAlignedBB aabb = new AxisAlignedBB(minX,.125,minZ, maxX,.375,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p());
				aabb = aabb.func_72317_d(-fl.func_82601_c()*(pos%25-10)/5,0,-fl.func_82599_e()*(pos%25-10)/5);
				list.add(aabb);

				minX = fw==EnumFacing.EAST?.375f: fw==EnumFacing.WEST?.5f: fl==EnumFacing.EAST?.375f: .375f;
				maxX = fw==EnumFacing.EAST?.5f: fw==EnumFacing.WEST?.625f: fl==EnumFacing.WEST?.625f: .625f;
				minZ = fw==EnumFacing.SOUTH?.375f: fw==EnumFacing.NORTH?.5f: fl==EnumFacing.SOUTH?.375f: .375f;
				maxZ = fw==EnumFacing.SOUTH?.5f: fw==EnumFacing.NORTH?.625f: fl==EnumFacing.NORTH?.625f: .625f;
				aabb = new AxisAlignedBB(minX,.125,minZ, maxX,.375,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p());
				aabb = aabb.func_72317_d(-fl.func_82601_c()*(pos%25-10)/5,0,-fl.func_82599_e()*(pos%25-10)/5);
				if(pos%5==0)
					aabb = aabb.func_72317_d(0,.6875,0);
				list.add(aabb);
				if(pos%5==0)
				{
					minX = fw==EnumFacing.EAST?.125f: fw==EnumFacing.WEST?.625f: fl==EnumFacing.EAST?.375f: .375f;
					maxX = fw==EnumFacing.EAST?.375f: fw==EnumFacing.WEST?.875f: fl==EnumFacing.WEST?.625f: .625f;
					minZ = fw==EnumFacing.SOUTH?.125f: fw==EnumFacing.NORTH?.625f: fl==EnumFacing.SOUTH?.375f: .375f;
					maxZ = fw==EnumFacing.SOUTH?.375f: fw==EnumFacing.NORTH?.875f: fl==EnumFacing.NORTH?.625f: .625f;
					aabb = new AxisAlignedBB(minX,.375,minZ, maxX,1.0625,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p());
					aabb = aabb.func_72317_d(-fl.func_82601_c()*(pos%25-10)/5,0,-fl.func_82599_e()*(pos%25-10)/5);
					list.add(aabb);
				}
				minX = fw==EnumFacing.EAST?.375f: fw==EnumFacing.WEST?.5f: fl==EnumFacing.EAST?2.375f:-1.625f;
				maxX = fw==EnumFacing.EAST?.5f: fw==EnumFacing.WEST?.625f: fl==EnumFacing.WEST?-1.375f: 2.625f;
				minZ = fw==EnumFacing.SOUTH?.375f: fw==EnumFacing.NORTH?.5f: fl==EnumFacing.SOUTH?2.375f:-1.625f;
				maxZ = fw==EnumFacing.SOUTH?.5f: fw==EnumFacing.NORTH?.625f: fl==EnumFacing.NORTH?-1.375f: 2.625f;
				aabb = new AxisAlignedBB(minX,.125,minZ, maxX,.375,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p());
				aabb = aabb.func_72317_d(-fl.func_82601_c()*(pos%25-10)/5,0,-fl.func_82599_e()*(pos%25-10)/5);
				list.add(aabb);
			}
			else if(pos==60||pos==64)
			{
				minX = fw==EnumFacing.EAST?.375f: fw==EnumFacing.WEST?.5f: .25f;
				maxX = fw==EnumFacing.EAST?.5f: fw==EnumFacing.WEST?.625f: .75f;
				minZ = fw==EnumFacing.SOUTH?.375f: fw==EnumFacing.NORTH?.5f: .25f;
				maxZ = fw==EnumFacing.SOUTH?.5f: fw==EnumFacing.NORTH?.625f: .75f;
				list.add(new AxisAlignedBB(minX,.25,minZ, maxX,.75,maxZ).func_72317_d(func_174877_v().func_177958_n(),func_174877_v().func_177956_o(),func_174877_v().func_177952_p()));
			}
			return list;
		}
		return null;
	}
	@Override
	public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list)
	{
		return false;
	}
	@Override
	public List<AxisAlignedBB> getAdvancedColisionBounds()
	{
		return getAdvancedSelectionBounds();
	}

	@Override
	public int[] getEnergyPos()
	{
		return new int[]{46,47,48};
	}
	@Override
	public int[] getRedstonePos()
	{
		return new int[]{25};
	}

	@Override
	public int getComparatorInputOverride()
	{
		if(this.pos==112)
		{
			TileEntityArcFurnace master = master();
			if(master!=null)
			{
				float f = 0;
				for(int i = 23; i < 26; i++)
					if(!master.inventory.get(i).func_190926_b())
						f += 1-(master.inventory.get(i).func_77952_i()/(float)master.inventory.get(i).func_77958_k());
				return MathHelper.func_76141_d(Math.max(f/3f,0)*15);
			}
		}
		return super.getComparatorInputOverride();
	}

	@Override
	public boolean isInWorldProcessingMachine()
	{
		return false;
	}
	@Override
	public boolean shouldRenderAsActive()
	{
		return hasElectrodes() && super.shouldRenderAsActive();
	}

	@Override
	public boolean additionalCanProcessCheck(MultiblockProcess<ArcFurnaceRecipe> process)
	{
		if(!hasElectrodes())
			return false;
		if(process.recipe!=null && !process.recipe.slag.func_190926_b())
		{
			if(this.inventory.get(22).func_190926_b())
				return true;
			return ItemHandlerHelper.canItemStacksStack(this.inventory.get(22), process.recipe.slag)&&inventory.get(22).func_190916_E()+process.recipe.slag.func_190916_E() <= getSlotLimit(22);
		}
		return true;
	}
	@Override
	public void doProcessOutput(ItemStack output)
	{
		BlockPos pos = func_174877_v().func_177982_a(0,-1,0).func_177967_a(facing,-2);
		TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
		if(inventoryTile!=null)
			output = Utils.insertStackIntoInventory(inventoryTile, output, facing.func_176734_d());
		if(!output.func_190926_b())
			Utils.dropStackAtPos(field_145850_b, pos, output, facing);
	}
	@Override
	public void doProcessFluidOutput(FluidStack output)
	{
	}
	@Override
	public void onProcessFinish(MultiblockProcess<ArcFurnaceRecipe> process)
	{
		if(!process.recipe.slag.func_190926_b())
		{
			if(this.inventory.get(22).func_190926_b())
				this.inventory.set(22, process.recipe.slag.func_77946_l());
			else if(ItemHandlerHelper.canItemStacksStack(this.inventory.get(22), process.recipe.slag) || inventory.get(22).func_190916_E() + process.recipe.slag.func_190916_E() >getSlotLimit(22))
				this.inventory.get(22).func_190917_f(process.recipe.slag.func_190916_E());
		}
	}
	@Override
	public int getMaxProcessPerTick()
	{
		return 12;
	}
	@Override
	public int getProcessQueueMaxLength()
	{
		return 12;
	}
	@Override
	public float getMinProcessDistance(MultiblockProcess<ArcFurnaceRecipe> process)
	{
		return 0;
	}


	@Override
	public int getComparatedSize()
	{
		return 12;
	}
	@Override
	public NonNullList<ItemStack> getInventory()
	{
		return this.inventory;
	}
	@Override
	public boolean isStackValid(int slot, ItemStack stack)
	{
		return true;
	}
	@Override
	public int getSlotLimit(int slot)
	{
		return slot>22?1:64;
	}
	static int[] outputSlots = {16,17,18,19,20,21};
	@Override
	public int[] getOutputSlots()
	{
		return outputSlots;
	}
	@Override
	public int[] getOutputTanks()
	{
		return null;
	}
	@Override
	public IFluidTank[] getInternalTanks()
	{
		return null;
	}
	@Override
	protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side)
	{
		return new IFluidTank[0];
	}
	@Override
	protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources)
	{
		return false;
	}
	@Override
	protected boolean canDrainTankFrom(int iTank, EnumFacing side)
	{
		return false;
	}
	@Override
	public void doGraphicalUpdates(int slot)
	{
	}


	IItemHandler inputHandler = new IEInventoryHandler(12, this, 0, true,false)
	{
		//ignore the given slot and spread it out
		@Override
		public ItemStack insertItem(int slot, ItemStack stack, boolean simulate)
		{
			if (stack.func_190926_b())
				return stack;
			stack = stack.func_77946_l();
			List<Integer> possibleSlots = new ArrayList<>(12);
			for (int i = 0; i < 12; i++)
			{
				ItemStack here = inventory.get(i);
				if (here.func_190926_b())
				{
					if (!simulate)
						inventory.set(i, stack);
					return ItemStack.field_190927_a;
				}
				else if (ItemHandlerHelper.canItemStacksStack(stack, here) && here.func_190916_E() < here.func_77976_d())
				{
					possibleSlots.add(i);
				}
			}
			Collections.sort(possibleSlots, (a, b) -> Integer.compare(inventory.get(a).func_190916_E(), inventory.get(b).func_190916_E()));
			for (int i : possibleSlots)
			{
				ItemStack here = inventory.get(i);
				int fillCount = Math.min(here.func_77976_d() - here.func_190916_E(), stack.func_190916_E());
				if (!simulate)
					here.func_190917_f(fillCount);
				stack.func_190918_g(fillCount);
				if (stack.func_190926_b())
					return ItemStack.field_190927_a;
			}
			return stack;
		}
	};
	IItemHandler additiveHandler = new IEInventoryHandler(4, this, 12, true,false);
	IItemHandler outputHandler = new IEInventoryHandler(6, this, 16, false,true);
	IItemHandler slagHandler = new IEInventoryHandler(1, this, 22, false,true);

	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing)
	{
		if((pos == 2 || pos == 22 || pos == 86 || pos == 88) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
			return master()!=null;
		return super.hasCapability(capability, facing);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing)
	{
		if(capability==CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
		{
			TileEntityArcFurnace master = master();
			if (master==null)
				return null;
			if(pos==2)
				return (T)master.outputHandler;
			else if(pos==22)
				return (T)master.slagHandler;
			else if(pos==(mirrored?88:86))
				return (T)master.inputHandler;
			else if(pos==(mirrored?86:88))
				return (T)master.additiveHandler;
		}
		return super.getCapability(capability, facing);
	}

	@Override
	public ArcFurnaceRecipe findRecipeForInsertion(ItemStack inserting)
	{
		return null;
	}
	@Override
	protected ArcFurnaceRecipe readRecipeFromNBT(NBTTagCompound tag)
	{
		return ArcFurnaceRecipe.loadFromNBT(tag);
	}
	@Override
	protected MultiblockProcess loadProcessFromNBT(NBTTagCompound tag)
	{
		IMultiblockRecipe recipe = readRecipeFromNBT(tag);
		if(recipe!=null && recipe instanceof ArcFurnaceRecipe)
			return new MultiblockProcessArcFurnace((ArcFurnaceRecipe)recipe, tag.func_74759_k("process_inputSlots"));
		return null;
	}

	@Override
	public boolean canOpenGui()
	{
		return formed && (pos==2||pos==25|| (pos>25 && pos%5>0 && pos%5<4 && pos%25/5<4));
	}
	@Override
	public int getGuiID()
	{
		return Lib.GUIID_ArcFurnace;
	}
	@Override
	public TileEntity getGuiMaster()
	{
		return master();
	}

	@Override
	public boolean shoudlPlaySound(String sound)
	{
		return false;
	}

	public static class MultiblockProcessArcFurnace extends MultiblockProcessInMachine<ArcFurnaceRecipe>
	{
		public MultiblockProcessArcFurnace(ArcFurnaceRecipe recipe, int... inputSlots)
		{
			super(recipe, inputSlots);
		}

		@Override
		protected NonNullList<ItemStack> getRecipeItemOutputs(TileEntityMultiblockMetal multiblock)
		{
			ItemStack input = multiblock.getInventory().get(this.inputSlots[0]);
			NonNullList<ItemStack> additives = NonNullList.func_191197_a(4, ItemStack.field_190927_a);
			for(int i=0; i<4; i++)
				additives.set(i, !multiblock.getInventory().get(12+i).func_190926_b()? multiblock.getInventory().get(12+i).func_77946_l():ItemStack.field_190927_a);
			return recipe.getOutputs(input, additives);
		}

		@Override
		protected void writeExtraDataToNBT(NBTTagCompound nbt)
		{
			super.writeExtraDataToNBT(nbt);
		}

		@Override
		protected void processFinish(TileEntityMultiblockMetal te)
		{
			super.processFinish(te);
			te.func_145831_w().func_175641_c(te.func_174877_v(), te.func_145838_q(), 0,40);
		}
	}

	public boolean hasElectrodes()
	{
		for(int i = 23; i < 26; i++)
			if(inventory.get(i).func_190926_b())
				return false;
		return true;
	}
}
