/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase.IELadderBlock;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

public class BlockMetalLadder extends IELadderBlock<BlockTypes_MetalLadder>
{
	protected static final AxisAlignedBB[] LADDER_AABB = {
			new AxisAlignedBB(0, 0, .8125, 1, 1, 1),
			new AxisAlignedBB(0, 0, 0, 1, 1, .1875),
			new AxisAlignedBB(.8125, 0, 0, 1, 1, 1),
			new AxisAlignedBB(0, 0, 0, .1875, 1, 1)
	};
	protected static final AxisAlignedBB[] FRAME_AABB = {
			new AxisAlignedBB(0, 0, .9375, 1, 1, 1),
			new AxisAlignedBB(0, 0, 0, 1, 1, .0625),
			new AxisAlignedBB(.9375, 0, 0, 1, 1, 1),
			new AxisAlignedBB(0, 0, 0, .0625, 1, 1)
	};

	public BlockMetalLadder()
	{
		super("metal_ladder", Material.field_151573_f, PropertyEnum.func_177709_a("type", BlockTypes_MetalLadder.class), ItemBlockIEBase.class, IEProperties.FACING_HORIZONTAL);
		this.func_149711_c(3.0F);
		this.func_149752_b(15.0F);
		this.setBlockLayer(BlockRenderLayer.CUTOUT_MIPPED);
		this.setAllNotNormalBlock();
		field_149786_r = 0;
	}

	@Override
	public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side)
	{
		int meta = this.func_176201_c(state);
		if(meta==0)
			return BlockFaceShape.UNDEFINED;
		else if(side.func_176740_k()==Axis.Y)
			return BlockFaceShape.BOWL;
		return BlockFaceShape.SOLID;
	}

	@Override
	public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		int meta = this.func_176201_c(state);
		return (meta!=0&&side.func_176740_k()!=Axis.Y)&&super.isSideSolid(state, world, pos, side);
	}

	@Override
	public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		return true;
	}

	@Override
	public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_)
	{
		int meta = this.func_176201_c(state);
		if(meta==0)
			func_185492_a(pos, entityBox, collidingBoxes, this.func_185496_a(state, world, pos));
		else
		{
			EnumFacing dir = ((TileEntityLadder)world.func_175625_s(pos)).getFacing();
			for(int i = 0; i < 4; i++)
				if(i==dir.func_176745_a()-2)
					func_185492_a(pos, entityBox, collidingBoxes, LADDER_AABB[i]);
				else
					func_185492_a(pos, entityBox, collidingBoxes, FRAME_AABB[i]);
		}
	}

	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		if(this.func_176201_c(state)==0)
		{
			TileEntityLadder tile = (TileEntityLadder)world.func_175625_s(pos);
			if(tile!=null)
			{
				EnumFacing dir = tile.getFacing();
				return LADDER_AABB[dir.func_176745_a()-2];
			}
		}
		return super.func_185496_a(state, world, pos);
	}

	@Override
	public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack)
	{
		if(stack.func_77960_j() > 0)
			return true;

		if(this.canAttachTo(world, pos.func_177976_e(), side))
			return true;
		else if(this.canAttachTo(world, pos.func_177974_f(), side))
			return true;
		else if(this.canAttachTo(world, pos.func_177978_c(), side))
			return true;
		else
			return this.canAttachTo(world, pos.func_177968_d(), side);
	}

	public boolean canAttachTo(World world, BlockPos pos, EnumFacing facing)
	{
		IBlockState state = world.func_180495_p(pos);
		boolean flag = func_193382_c(state.func_177230_c());
		return !flag&&state.func_193401_d(world, pos, facing)==BlockFaceShape.SOLID&&!state.func_185897_m();
	}

	@Override
	public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos)
	{
		TileEntityLadder tile = (TileEntityLadder)world.func_175625_s(pos);
		if(tile!=null)
		{
			EnumFacing enumfacing = tile.getFacing();
			if(func_176201_c(state)==0&&!this.canAttachTo(world, pos.func_177972_a(enumfacing.func_176734_d()), enumfacing))
			{
				this.func_176226_b(world, pos, state, 0);
				world.func_175698_g(pos);
			}
		}
		super.func_189540_a(state, world, pos, blockIn, fromPos);
	}

	@Override
	public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack)
	{
		TileEntityLadder tile = (TileEntityLadder)world.func_175625_s(pos);
		if(tile!=null)
			tile.setFacing(tile.getFacingForPlacement(placer, pos, side, hitX, hitY, hitZ));
	}

	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		state = super.func_176221_a(state, world, pos);
		TileEntityLadder tile = (TileEntityLadder)world.func_175625_s(pos);
		if(tile!=null && tile.getFacing().func_176740_k().func_176722_c())
			state = applyProperty(state, IEProperties.FACING_HORIZONTAL, tile.getFacing());
		return state;
	}

	@Override
	public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity)
	{
		return true;
	}

	@Override
	public boolean allowHammerHarvest(IBlockState state)
	{
		return true;
	}

	@Override
	public boolean hasTileEntity(IBlockState state)
	{
		return true;
	}

	@Nullable
	@Override
	public TileEntity createTileEntity(World world, IBlockState state)
	{
		return new TileEntityLadder();
	}
}
