/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.BlockIEBase.IELadderBlock;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

public class BlockMetalDecoration1 extends IELadderBlock<BlockTypes_MetalDecoration1>
{
	public BlockMetalDecoration1()
	{
		super("metal_decoration1", Material.field_151573_f, PropertyEnum.func_177709_a("type", BlockTypes_MetalDecoration1.class), ItemBlockIEBase.class, BlockFence.field_176526_a,BlockFence.field_176527_M,BlockFence.field_176528_N,BlockFence.field_176525_b);
		this.func_149711_c(3.0F);
		this.func_149752_b(15.0F);
		this.setBlockLayer(BlockRenderLayer.CUTOUT_MIPPED);
		this.setAllNotNormalBlock();
		field_149786_r = 0;
	}

	@Override
	public boolean useCustomStateMapper()
	{
		return true;
	}
	@Override
	public String getCustomStateMapping(int meta, boolean itemBlock)
	{
		if(meta==0 && !itemBlock)
			return "steel_fence";
		else if(meta==4 && !itemBlock)
			return "aluminum_fence";
		return null;
	}

	@Override
	public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing)
	{
		int meta = this.func_176201_c(world.func_180495_p(pos));
		if(meta==BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta==BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta())
		{
			IBlockState connector = world.func_180495_p(pos.func_177972_a(facing));
			return connector.func_177230_c() instanceof BlockMetalDecoration1&&this.func_176201_c(connector)==meta;
		}
		return super.canBeConnectedTo(world, pos, facing);
	}

	@Override
	public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side)
	{
		int meta = this.func_176201_c(state);
		if(meta==BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta==BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta())
			return side != EnumFacing.UP && side != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.CENTER;
		return BlockFaceShape.SOLID;
	}

	@Override
	public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		int meta = this.func_176201_c(state);
		if(meta==BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta==BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta())
			return side==EnumFacing.UP;
		if(state.func_177229_b(this.property).isScaffold())
			return true;
		return super.isSideSolid(state, world, pos, side);
	}

	@Override
	public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		int meta = this.func_176201_c(state);
		if(state.func_177229_b(this.property).isScaffold())
		{
			IBlockState state2 = world.func_180495_p(pos.func_177972_a(side));
			if(this.equals(state2.func_177230_c()))
				return this.func_176201_c(state2)!=meta;
		}
		return super.func_176225_a(state, world, pos, side);
	}


	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		state  = super.func_176221_a(state, world, pos);
		if(this.func_176201_c(state)==BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || this.func_176201_c(state)==BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta())
			for(EnumFacing f : EnumFacing.field_176754_o)
				state = state.func_177226_a(f==EnumFacing.NORTH?BlockFence.field_176526_a:f==EnumFacing.SOUTH?BlockFence.field_176527_M:f==EnumFacing.WEST?BlockFence.field_176528_N:BlockFence.field_176525_b, Utils.canFenceConnectTo(world, pos, f, field_149764_J));
		return state;
	}

	@Override
	public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_)
	{
		state = state.func_185899_b(worldIn, pos);
		int meta = this.func_176201_c(state);
		if(meta==BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta==BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta())
		{
			func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185671_f);
			if(state.func_177229_b(BlockFence.field_176526_a).booleanValue())
				func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185668_C);
			if(state.func_177229_b(BlockFence.field_176525_b).booleanValue())
				func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185669_D);
			if(state.func_177229_b(BlockFence.field_176527_M).booleanValue())
				func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185672_g);
			if(state.func_177229_b(BlockFence.field_176528_N).booleanValue())
				func_185492_a(pos, entityBox, collidingBoxes, BlockFence.field_185667_B);
		}
		else
			func_185492_a(pos, entityBox, collidingBoxes, new AxisAlignedBB(.0625f, 0, .0625f, .9375f, 1, .9375f));
	}
	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		int meta = this.func_176201_c(state);
		if(meta==BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta==BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta())
			return new AxisAlignedBB(Utils.canFenceConnectTo(world,pos,EnumFacing.WEST,field_149764_J)?0:.375f,0,Utils.canFenceConnectTo(world,pos,EnumFacing.NORTH,field_149764_J)?0:.375f, Utils.canFenceConnectTo(world,pos,EnumFacing.EAST,field_149764_J)?1:.625f,1f,Utils.canFenceConnectTo(world,pos,EnumFacing.SOUTH,field_149764_J)?1:.625f);
		return super.func_185496_a(state, world, pos);
	}

	@Override
	public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity)
	{
		return world.func_180495_p(pos).func_177229_b(property).getMeta()%4!=0;
	}

	@Override
	public boolean allowHammerHarvest(IBlockState state)
	{
		return true;
	}

	@Nullable
	@Override
	public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		switch (state.func_177229_b(property))
		{
			case STEEL_FENCE:
			case ALUMINUM_FENCE:
				return PathNodeType.FENCE;
			default:
				return super.getAiPathNodeType(state, world, pos);
		}
	}
}
