/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

import java.util.Arrays;

public class BlockConnector extends BlockIETileProvider<BlockTypes_Connector>
{
	public BlockConnector()
	{
		super("connector", Material.field_151573_f, PropertyEnum.func_177709_a("type", BlockTypes_Connector.class), ItemBlockIEBase.class, IEProperties.FACING_ALL,
				IEProperties.BOOLEANS[0], IEProperties.BOOLEANS[1], IEProperties.MULTIBLOCKSLAVE, IOBJModelCallback.PROPERTY,
				IEProperties.TILEENTITY_PASSTHROUGH);
		func_149711_c(3.0F);
		func_149752_b(15.0F);
		field_149786_r = 0;
		setMetaBlockLayer(BlockTypes_Connector.RELAY_HV.getMeta(), BlockRenderLayer.SOLID, BlockRenderLayer.TRANSLUCENT);
		setMetaBlockLayer(BlockTypes_Connector.CONNECTOR_PROBE.getMeta(), BlockRenderLayer.SOLID, BlockRenderLayer.CUTOUT, BlockRenderLayer.TRANSLUCENT);
		setMetaBlockLayer(BlockTypes_Connector.FEEDTHROUGH.getMeta(), BlockRenderLayer.SOLID,
				BlockRenderLayer.CUTOUT, BlockRenderLayer.CUTOUT_MIPPED, BlockRenderLayer.TRANSLUCENT);
		setAllNotNormalBlock();
		setMetaMobilityFlag(BlockTypes_Connector.TRANSFORMER.getMeta(), EnumPushReaction.BLOCK);
		setMetaMobilityFlag(BlockTypes_Connector.TRANSFORMER_HV.getMeta(), EnumPushReaction.BLOCK);
		setMetaMobilityFlag(BlockTypes_Connector.ENERGY_METER.getMeta(), EnumPushReaction.BLOCK);
		setMetaMobilityFlag(BlockTypes_Connector.FEEDTHROUGH.getMeta(), EnumPushReaction.BLOCK);
	}

	@Override
	public boolean useCustomStateMapper()
	{
		return true;
	}
	@Override
	public String getCustomStateMapping(int meta, boolean itemBlock)
	{
		if(meta==BlockTypes_Connector.TRANSFORMER.getMeta())
			return "transformer";
		if(meta==BlockTypes_Connector.TRANSFORMER_HV.getMeta())
			return "transformer_hv";
		if(meta==BlockTypes_Connector.BREAKERSWITCH.getMeta())
			return "breaker_switch";
		if(meta==BlockTypes_Connector.REDSTONE_BREAKER.getMeta())
			return "redstone_breaker";
		if(meta==BlockTypes_Connector.ENERGY_METER.getMeta())
			return "energy_meter";
		return null;
	}
	@Override
	protected BlockStateContainer func_180661_e()
	{
		BlockStateContainer base = super.func_180661_e();
		IUnlistedProperty[] unlisted = (base instanceof ExtendedBlockState) ? ((ExtendedBlockState) base).getUnlistedProperties().toArray(new IUnlistedProperty[0]) : new IUnlistedProperty[0];
		unlisted = Arrays.copyOf(unlisted, unlisted.length+1);
		unlisted[unlisted.length-1] = IEProperties.CONNECTIONS;
		return new ExtendedBlockState(this, base.func_177623_d().toArray(new IProperty[0]), unlisted);
	}
	@Override
	public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		state = super.getExtendedState(state, world, pos);
		if(state instanceof IExtendedBlockState)
		{
			IExtendedBlockState ext = (IExtendedBlockState) state;
			TileEntity te = world.func_175625_s(pos);
			if (!(te instanceof TileEntityImmersiveConnectable))
				return state;
			state = ext.withProperty(IEProperties.CONNECTIONS, ((TileEntityImmersiveConnectable)te).genConnBlockstate());
		}
		return state;
	}
	@Override
	public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side)
	{
		IBlockState s = world.func_180495_p(pos);
		return s.func_177229_b(property) == BlockTypes_Connector.ENERGY_METER;
	}

	@Override
	public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack)
	{
		switch (BlockTypes_Connector.values()[stack.func_77952_i()])
		{
			case TRANSFORMER:
			case TRANSFORMER_HV:
				for (int hh = 1; hh <= 2; hh++)
				{
					BlockPos pos2 = pos.func_177981_b(hh);
					if (world.func_189509_E(pos2) || !world.func_180495_p(pos2).func_177230_c().func_176200_f(world, pos2))
						return false;
				}
			break;
			case ENERGY_METER:
				BlockPos pos2 = pos.func_177984_a();
				return !world.func_189509_E(pos2) && world.func_180495_p(pos2).func_177230_c().func_176200_f(world, pos2);
			case FEEDTHROUGH:
				EnumFacing f = new TileEntityFeedthrough().getFacingForPlacement(player, pos, side, hitX, hitY, hitZ);
				BlockPos forward = pos.func_177967_a(f, 1);
				BlockPos backward = pos.func_177967_a(f, -1);
				return world.func_180495_p(forward).func_177230_c().func_176200_f(world, forward)&&
						world.func_180495_p(backward).func_177230_c().func_176200_f(world, backward);
		}
		return true;
	}

	@Override
	public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos)
	{
		super.func_189540_a(state, world, pos, blockIn, fromPos);
		TileEntity te = world.func_175625_s(pos);
		if(te instanceof TileEntityConnectorLV)
		{
			TileEntityConnectorLV connector = (TileEntityConnectorLV) te;
			if(world.func_175623_d(pos.func_177972_a(connector.facing)))
			{
				this.func_176226_b(connector.func_145831_w(), pos, world.func_180495_p(pos), 0);
				connector.func_145831_w().func_175698_g(pos);
				return;
			}
		}
		if(te instanceof TileEntityConnectorRedstone)
		{
			TileEntityConnectorRedstone connector = (TileEntityConnectorRedstone) te;
			if(world.func_175623_d(pos.func_177972_a(connector.facing)))
			{
				this.func_176226_b(connector.func_145831_w(), pos, world.func_180495_p(pos), 0);
				connector.func_145831_w().func_175698_g(pos);
				return;
			}
			if (connector.isRSInput())
				connector.rsDirty = true;
		}
	}

	@Override
	public TileEntity createBasicTE(World world, BlockTypes_Connector type)
	{
		switch(type)
		{
			case CONNECTOR_LV:
				return new TileEntityConnectorLV();
			case RELAY_LV:
				return new TileEntityRelayLV();
			case CONNECTOR_MV:
				return new TileEntityConnectorMV();
			case RELAY_MV:
				return new TileEntityRelayMV();
			case CONNECTOR_HV:
				return new TileEntityConnectorHV();
			case RELAY_HV:
				return new TileEntityRelayHV();
			case CONNECTOR_STRUCTURAL:
				return new TileEntityConnectorStructural();
			case TRANSFORMER:
				return new TileEntityTransformer();
			case TRANSFORMER_HV:
				return new TileEntityTransformerHV();
			case BREAKERSWITCH:
				return new TileEntityBreakerSwitch();
			case REDSTONE_BREAKER:
				return new TileEntityRedstoneBreaker();
			case ENERGY_METER:
				return new TileEntityEnergyMeter();
			case CONNECTOR_REDSTONE:
				return new TileEntityConnectorRedstone();
			case CONNECTOR_PROBE:
				return new TileEntityConnectorProbe();
			case FEEDTHROUGH:
				return new TileEntityFeedthrough();
		}
		return null;
	}
	@Override
	public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer)
	{
		IBlockState ret = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
		if (meta==BlockTypes_Connector.TRANSFORMER.getMeta())
		{
			BlockPos pos2 = pos.func_177967_a(facing, -1);
			IBlockState placedAgainst = world.func_180495_p(pos2);
			Block block = placedAgainst.func_177230_c();
			if (block instanceof IPostBlock&&((IPostBlock)block).canConnectTransformer(world, pos2))
				ret = ret.func_177226_a(IEProperties.BOOLEANS[1], true);
			TileEntity tile = world.func_175625_s(pos2);
			if(tile instanceof IPostBlock && ((IPostBlock)tile).canConnectTransformer(world, pos2))
				ret = ret.func_177226_a(IEProperties.BOOLEANS[1], true);
		}
		return ret;
	}

	@Override
	public boolean allowHammerHarvest(IBlockState state)
	{
		return true;
	}

	@Override
	public int getLightOpacity(IBlockState state, IBlockAccess w, BlockPos pos)
	{
		if (state.func_177229_b(property)==BlockTypes_Connector.FEEDTHROUGH)
		{
			TileEntity te = w.func_175625_s(pos);
			if (te instanceof TileEntityFeedthrough&&((TileEntityFeedthrough) te).offset==0)
				return 255;
		}
		return super.getLightOpacity(state, w, pos);
	}
}
