/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IEProperties.PropertyBoolInverted;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.*;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.Lists;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

import java.util.List;

/**
 * @author BluSunrize - 01.10.2016
 */
public class TileEntityStripCurtain extends TileEntityIEBase implements ITickable, IRedstoneOutput, IHammerInteraction, IAdvancedCollisionBounds, IAdvancedDirectionalTile, IDualState, IColouredTile, ITileDrop
{
	public EnumFacing facing = EnumFacing.NORTH;
	public boolean ceilingAttached = false;
	public int colour = 0xffffff;
	private int redstoneSignal = 0;
	private boolean strongSignal = false;

	@Override
	public void func_73660_a()
	{
		if(!field_145850_b.field_72995_K &&field_145850_b.func_82737_E()%4==((func_174877_v().func_177958_n()^func_174877_v().func_177952_p())&3))
		{
			List<Entity> entities = null;
			AxisAlignedBB aabb = bounds[ceilingAttached?(facing.func_176740_k()== Axis.Z?4:5):((facing.ordinal()-2)%4)];
			aabb = new AxisAlignedBB(aabb.field_72340_a,aabb.field_72338_b-.8125,aabb.field_72339_c, aabb.field_72336_d,aabb.field_72337_e,aabb.field_72334_f).func_186670_a(func_174877_v());
			entities = field_145850_b.func_72872_a(Entity.class, aabb);
			if(!ceilingAttached && !entities.isEmpty() && redstoneSignal==0)
			{
				redstoneSignal = 15;
				func_70296_d();
				field_145850_b.func_175685_c(func_174877_v(), func_145838_q(), false);
				field_145850_b.func_175685_c(func_174877_v().func_177972_a(facing), func_145838_q(), false);
			}
			if(entities.isEmpty() && redstoneSignal!=0)
			{
				redstoneSignal = 0;
				field_145850_b.func_175685_c(func_174877_v(), func_145838_q(), false);
				field_145850_b.func_175685_c(func_174877_v().func_177972_a(facing), func_145838_q(), false);
			}
		}
	}
	@Override
	public void onEntityCollision(World world, Entity entity)
	{
		if(ceilingAttached && !entity.field_70128_L && redstoneSignal ==0)
		{
			AxisAlignedBB aabb = bounds[ceilingAttached ? (facing.func_176740_k() == Axis.Z ? 4 : 5) : ((facing.ordinal() - 2) % 4)];
			aabb = new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b - .8125, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_186670_a(func_174877_v());
			if(entity.func_174813_aQ().func_72326_a(aabb))
			{
				redstoneSignal = 15;
				func_70296_d();
				world.func_175685_c(func_174877_v(), func_145838_q(), false);
				world.func_175685_c(func_174877_v().func_177972_a(EnumFacing.UP), func_145838_q(), false);
			}
		}
	}
	@Override
	public int getStrongRSOutput(IBlockState state, EnumFacing side)
	{
		if(!strongSignal)
			return 0;
		return getWeakRSOutput(state, facing);
	}
	@Override
	public int getWeakRSOutput(IBlockState state, EnumFacing side)
	{
		if(side==EnumFacing.DOWN)
			return 0;
		return redstoneSignal;
	}
	@Override
	public boolean canConnectRedstone(IBlockState state, EnumFacing side)
	{
		return false;
	}

	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
		ceilingAttached = nbt.func_74767_n("ceilingAttached");
		colour = nbt.func_74762_e("colour");
	}

	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		if(facing!=null)
			nbt.func_74768_a("facing",facing.ordinal());
		nbt.func_74757_a("ceilingAttached", ceilingAttached);
		nbt.func_74768_a("colour", colour);
	}

	AxisAlignedBB[] bounds = {
			new AxisAlignedBB(0,0,0,1,.1875f,.0625f),
			new AxisAlignedBB(0,0,.9375f,1,.1875f,1),
			new AxisAlignedBB(0,0,0,.0625f,.1875f,1),
			new AxisAlignedBB(.9375f,0,0,1,.1875f,1),
			new AxisAlignedBB(0,.8125f,.46875f,1,1,.53125f),
			new AxisAlignedBB(.46875f,.8125f,0,.53125f,1,1)
	};
	@Override
	public float[] getBlockBounds()
	{
		AxisAlignedBB aabb = bounds[ceilingAttached?(facing.func_176740_k()== Axis.Z?4:5):((facing.ordinal()-2)%4)];
		return new float[]{(float)aabb.field_72340_a,(float)aabb.field_72338_b,(float)aabb.field_72339_c, (float)aabb.field_72336_d,(float)aabb.field_72337_e,(float)aabb.field_72334_f};
	}
	@Override
	public List<AxisAlignedBB> getAdvancedColisionBounds()
	{
		return Lists.newArrayList(bounds[ceilingAttached?(facing.func_176740_k()== Axis.Z?4:5):((facing.ordinal()-2)%4)]);
	}

	@Override
	public EnumFacing getFacing()
	{
		return facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}
	@Override
	public int getFacingLimitation()
	{
		return 2;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return false;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return false;
	}
	@Override
	public void onDirectionalPlacement(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer)
	{
		if(side==EnumFacing.DOWN)
			ceilingAttached = true;
	}

	@Override
	public boolean getIsSecondState()
	{
		return ceilingAttached;
	}
	@Override
	public PropertyBoolInverted getBoolProperty(Class<? extends IUsesBooleanProperty> inf)
	{
		return IEProperties.BOOLEANS[0];
	}

	@Override
	public int getRenderColour(int tintIndex)
	{
		if(tintIndex==1)
			return colour;
		return 0xffffff;
	}

	@Override
	public ItemStack getTileDrop(EntityPlayer player, IBlockState state)
	{
		ItemStack stack = new ItemStack(state.func_177230_c(),1,state.func_177230_c().func_176201_c(state));
		if(colour!=0xffffff)
			ItemNBTHelper.setInt(stack, "colour", colour);
		return stack;
	}
	@Override
	public void readOnPlacement(EntityLivingBase placer, ItemStack stack)
	{
		if(ItemNBTHelper.hasKey(stack, "colour"))
			this.colour = ItemNBTHelper.getInt(stack, "colour");
	}

	@Override
	public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ)
	{
		strongSignal = !strongSignal;
		ChatUtils.sendServerNoSpamMessages(player, new TextComponentTranslation(Lib.CHAT_INFO+"rsControl.strongSignal."+strongSignal));
		return true;
	}
}
