/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemBlockClothDevice extends ItemBlockIEBase
{

	public ItemBlockClothDevice(Block b)
	{
		super(b);
	}
	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand)
	{
		ItemStack itemStackIn = playerIn.func_184586_b(hand);
		if(itemStackIn.func_77960_j()!=BlockTypes_ClothDevice.BALLOON.getMeta())
			return super.func_77659_a(worldIn, playerIn, hand);
		if(playerIn.func_70093_af())
			increaseOffset(itemStackIn);
		else
		{
			Vec3d pos = playerIn.func_174791_d().func_72441_c(0, playerIn.func_70047_e(), 0).func_178787_e(playerIn.func_70040_Z());
			BlockPos bPos = new BlockPos(pos);
			NBTTagCompound nbt = itemStackIn.func_77978_p();
			int offset = nbt==null?0:nbt.func_74771_c("offset");
			bPos = bPos.func_177981_b(offset);
			if (worldIn.func_175623_d(bPos))
			{
				if(!worldIn.field_72995_K)
				{
					worldIn.func_175656_a(bPos, IEContent.blockClothDevice.func_176203_a(BlockTypes_ClothDevice.BALLOON.getMeta()));
					itemStackIn.func_190918_g(1);
					if(itemStackIn.func_190916_E() <= 0)
						playerIn.func_184611_a(hand, ItemStack.field_190927_a);
				}
				return new ActionResult(EnumActionResult.SUCCESS, itemStackIn);
			}
		}
		return new ActionResult(EnumActionResult.PASS, itemStackIn);
	}
	@Override
	public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		ItemStack stack = playerIn.func_184586_b(hand);
		if(stack.func_77960_j()==BlockTypes_ClothDevice.BALLOON.getMeta() && playerIn.func_70093_af())
		{
			increaseOffset(stack);
			return EnumActionResult.SUCCESS;
		}
		return super.func_180614_a(playerIn, worldIn, pos, hand, side, hitX, hitY, hitZ);
	}
	@Override
	public String func_77653_i(ItemStack stack)
	{
		String ret = super.func_77653_i(stack);
		NBTTagCompound nbt = stack.func_77978_p();
		if (nbt!=null&&nbt.func_74771_c("offset")!=0)
			ret+=" (+"+nbt.func_74771_c("offset")+")";
		return ret;
	}
	private void increaseOffset(ItemStack s)
	{
		if (s.func_77978_p()==null)
			s.func_77982_d(new NBTTagCompound());
		NBTTagCompound tag = s.func_77978_p();
		byte offset = tag.func_74771_c("offset");
		tag.func_74774_a("offset", (byte) ((offset+1)%5));
	
	}
}
