/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IBlockBounds;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IDirectionalTile;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IGeneralMultiblock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.ITileDrop;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class TileEntityMultiblockPart<T extends TileEntityMultiblockPart<T>> extends TileEntityIEBase
		implements ITickable, IDirectionalTile, IBlockBounds, IGeneralMultiblock
{
	public boolean formed = false;
	public int pos=-1;
	public int[] offset = {0,0,0};
	public boolean mirrored = false;
	public EnumFacing facing = EnumFacing.NORTH;
	// stores the world time at which this block can only be disassembled by breaking the block associated with this TE.
	// This prevents half/duplicate disassembly when working with the drill or TCon hammers
	public long onlyLocalDissassembly = -1;
	/**H L W*/
	protected final int[] structureDimensions;
	protected TileEntityMultiblockPart(int[] structureDimensions)
	{
		this.structureDimensions = structureDimensions;
	}

	@Override
	public EnumFacing getFacing()
	{
		return this.facing;
	}
	@Override
	public void setFacing(EnumFacing facing)
	{
		this.facing = facing;
	}
	@Override
	public int getFacingLimitation()
	{
		return 2;
	}
	@Override
	public boolean mirrorFacingOnPlacement(EntityLivingBase placer)
	{
		return false;
	}
	@Override
	public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity)
	{
		return false;
	}
	@Override
	public boolean canRotate(EnumFacing axis)
	{
		return false;
	}


	//	=================================
	//		DATA MANAGEMENT
	//	=================================
	@Override
	public void readCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		formed = nbt.func_74767_n("formed");
		pos = nbt.func_74762_e("pos");
		offset = nbt.func_74759_k("offset");
		mirrored = nbt.func_74767_n("mirrored");
		facing = EnumFacing.func_82600_a(nbt.func_74762_e("facing"));
	}
	@Override
	public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket)
	{
		nbt.func_74757_a("formed", formed);
		nbt.func_74768_a("pos", pos);
		nbt.func_74783_a("offset", offset);
		nbt.func_74757_a("mirrored", mirrored);
		nbt.func_74768_a("facing", facing.ordinal());
	}

	@Override
	public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing)
	{
		if(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing!=null&&this.getAccessibleFluidTanks(facing).length>0)
			return true;
		return super.hasCapability(capability, facing);
	}
	@Override
	public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing)
	{
		if(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing!=null&&this.getAccessibleFluidTanks(facing).length>0)
			return (T)new MultiblockFluidWrapper(this, facing);
		return super.getCapability(capability, facing);
	}

	//	=================================
	//		FLUID MANAGEMENT
	//	=================================
	@Nonnull
	protected abstract IFluidTank[] getAccessibleFluidTanks(EnumFacing side);
	protected abstract boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource);
	protected abstract boolean canDrainTankFrom(int iTank, EnumFacing side);

	public static class MultiblockFluidWrapper implements IFluidHandler
	{
		final TileEntityMultiblockPart multiblock;
		final EnumFacing side;

		public MultiblockFluidWrapper(TileEntityMultiblockPart multiblock, EnumFacing side)
		{
			this.multiblock = multiblock;
			this.side = side;
		}
		@Override
		public IFluidTankProperties[] getTankProperties()
		{
			if(!this.multiblock.formed)
				return new IFluidTankProperties[0];
			IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(side);
			IFluidTankProperties[] array = new IFluidTankProperties[tanks.length];
			for(int i=0; i<tanks.length; i++)
				array[i] = new FluidTankProperties(tanks[i].getFluid(), tanks[i].getCapacity());
			return array;
		}
		@Override
		public int fill(FluidStack resource, boolean doFill)
		{
			if(!this.multiblock.formed || resource==null)
				return 0;
			IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(side);
			int fill = -1;
			for(int i=0; i<tanks.length; i++)
			{
				IFluidTank tank = tanks[i];
				if(tank != null && this.multiblock.canFillTankFrom(i, side, resource) && tank.getFluid()!= null && tank.getFluid().isFluidEqual(resource))
				{
					fill = tank.fill(resource, doFill);
					if(fill>0)
						break;
				}
			}
			if(fill==-1)
				for(int i=0; i<tanks.length; i++)
				{
					IFluidTank tank = tanks[i];
					if(tank != null && this.multiblock.canFillTankFrom(i, side, resource))
					{
						fill = tank.fill(resource, doFill);
						if(fill>0)
							break;
					}
				}
			if(fill>0)
				this.multiblock.updateMasterBlock(null, true);
			return fill<0?0:fill;
		}
		@Nullable
		@Override
		public FluidStack drain(FluidStack resource, boolean doDrain)
		{
			if(!this.multiblock.formed || resource==null)
				return null;
			IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(side);
			FluidStack drain = null;
			for(int i=0; i<tanks.length; i++)
			{
				IFluidTank tank = tanks[i];
				if(tank != null && this.multiblock.canDrainTankFrom(i, side))
				{
					if(tank instanceof IFluidHandler)
						drain = ((IFluidHandler)tank).drain(resource, doDrain);
					else
						drain = tank.drain(resource.amount, doDrain);
					if(drain!=null)
						break;
				}
			}
			if(drain!=null)
				this.multiblock.updateMasterBlock(null, true);
			return drain;
		}
		@Nullable
		@Override
		public FluidStack drain(int maxDrain, boolean doDrain)
		{
			if(!this.multiblock.formed || maxDrain==0)
				return null;
			IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(side);
			FluidStack drain = null;
			for(int i=0; i<tanks.length; i++)
			{
				IFluidTank tank = tanks[i];
				if(tank!=null && this.multiblock.canDrainTankFrom(i, side))
				{
					drain = tank.drain(maxDrain, doDrain);
					if(drain!=null)
						break;
				}
			}
			if(drain!=null)
				this.multiblock.updateMasterBlock(null, true);
			return drain;
		}
	}

	@Override
	public void func_145843_s()
	{
		super.func_145843_s();
	}

	public static boolean _Immovable()
	{
		return true;
	}
	@Nullable
	public T master()
	{
		if(offset[0]==0&&offset[1]==0&&offset[2]==0)
			return (T)this;
		BlockPos masterPos = func_174877_v().func_177982_a(-offset[0],-offset[1],-offset[2]);
		TileEntity te = Utils.getExistingTileEntity(field_145850_b, masterPos);
		return this.getClass().isInstance(te)?(T)te: null;
	}
	public void updateMasterBlock(IBlockState state, boolean blockUpdate)
	{
		T master = master();
		if(master!=null)
		{
			master.func_70296_d();
			if(blockUpdate)
				master.markContainingBlockForUpdate(state);
		}
	}
	public boolean isDummy()
	{
		return offset[0]!=0 || offset[1]!=0 || offset[2]!=0;
	}

	@Override
	public boolean isLogicDummy()
	{
		return isDummy();
	}

	public abstract ItemStack getOriginalBlock();
	public void disassemble()
	{
		if(formed && !field_145850_b.field_72995_K)
		{
			BlockPos startPos = getOrigin();
			BlockPos masterPos = func_174877_v().func_177982_a(-offset[0], -offset[1], -offset[2]);
			long time = field_145850_b.func_82737_E();
			for(int yy=0;yy<structureDimensions[0];yy++)
				for(int ll=0;ll<structureDimensions[1];ll++)
					for(int ww=0;ww<structureDimensions[2];ww++)
					{
						int w = mirrored?-ww:ww;
						BlockPos pos = startPos.func_177967_a(facing, ll).func_177967_a(facing.func_176746_e(), w).func_177982_a(0, yy, 0);
						ItemStack s = ItemStack.field_190927_a;

						TileEntity te = field_145850_b.func_175625_s(pos);
						if(te instanceof TileEntityMultiblockPart)
						{
							TileEntityMultiblockPart part = (TileEntityMultiblockPart) te;
							Vec3i diff = pos.func_177973_b(masterPos);
							if (part.offset[0]!=diff.func_177958_n()||part.offset[1]!=diff.func_177956_o()||part.offset[2]!=diff.func_177952_p())
								continue;
							else if (time!=part.onlyLocalDissassembly)
							{
								s = part.getOriginalBlock();
								part.formed = false;
							}
						}
						if(pos.equals(func_174877_v()))
							s = this.getOriginalBlock();
						IBlockState state = Utils.getStateFromItemStack(s);
						if(state!=null)
						{
							if(pos.equals(func_174877_v()))
								field_145850_b.func_72838_d(new EntityItem(field_145850_b, pos.func_177958_n()+.5,pos.func_177956_o()+.5,pos.func_177952_p()+.5, s));
							else
								replaceStructureBlock(pos, state, s, yy,ll,ww);
						}
					}
		}
	}
	public BlockPos getOrigin() {
		return getBlockPosForPos(0);
	}
	public BlockPos getBlockPosForPos(int targetPos)
	{
		int blocksPerLevel = structureDimensions[1]*structureDimensions[2];
		// dist = target position - current position
		int distH = (targetPos/blocksPerLevel)-(pos/blocksPerLevel);
		int distL = (targetPos%blocksPerLevel / structureDimensions[2])-(pos%blocksPerLevel / structureDimensions[2]);
		int distW = (targetPos%structureDimensions[2])-(pos%structureDimensions[2]);
		int w = mirrored?-distW:distW;
		return func_174877_v().func_177967_a(facing, distL).func_177967_a(facing.func_176746_e(), w).func_177982_a(0, distH, 0);
	}
	public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w)
	{
		if(state.func_177230_c()==this.func_145838_q())
			field_145850_b.func_175698_g(pos);
		field_145850_b.func_175656_a(pos, state);
		TileEntity tile = field_145850_b.func_175625_s(pos);
		if(tile instanceof ITileDrop)
			((ITileDrop)tile).readOnPlacement(null, stack);
	}
}
