/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IDirectionalTile;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.energy.CapabilityEnergy;

import javax.annotation.Nullable;

public abstract class TileEntityIEBase extends TileEntity
{
	@Override
	public void func_145839_a(NBTTagCompound nbt)
	{
		super.func_145839_a(nbt);
		this.readCustomNBT(nbt, false);
	}
	public abstract void readCustomNBT(NBTTagCompound nbt, boolean descPacket);
	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbt)
	{
		super.func_189515_b(nbt);
		this.writeCustomNBT(nbt, false);
		return nbt;
	}
	public abstract void writeCustomNBT(NBTTagCompound nbt, boolean descPacket);

	@Override
	public SPacketUpdateTileEntity func_189518_D_()
	{
		NBTTagCompound nbttagcompound = new NBTTagCompound();
		this.writeCustomNBT(nbttagcompound, true);
		return new SPacketUpdateTileEntity(this.field_174879_c, 3, nbttagcompound);
	}
	@Override
	public NBTTagCompound func_189517_E_()
	{
		NBTTagCompound nbt = super.func_189515_b(new NBTTagCompound());
		writeCustomNBT(nbt, true);
		return nbt;
	}
	@Override
	public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt)
	{
		this.readCustomNBT(pkt.func_148857_g(), true);
	}


	@Override
	public void func_189667_a(Rotation rot)
	{
		if(rot!=Rotation.NONE && this instanceof IDirectionalTile && ((IDirectionalTile)this).canRotate(EnumFacing.UP))
		{
			EnumFacing f = ((IDirectionalTile)this).getFacing();
			switch(rot)
			{
				case CLOCKWISE_90:
					f = f.func_176746_e();
					break;
				case CLOCKWISE_180:
					f = f.func_176734_d();
					break;
				case COUNTERCLOCKWISE_90:
					f = f.func_176735_f();
					break;
			}
			((IDirectionalTile)this).setFacing(f);
			this.func_70296_d();
			if(this.field_174879_c!=null)
				this.markBlockForUpdate(this.field_174879_c, null);
		}
	}

	@Override
	public void func_189668_a(Mirror mirrorIn)
	{
		if(mirrorIn==Mirror.FRONT_BACK && this instanceof IDirectionalTile)
		{
			((IDirectionalTile)this).setFacing(((IDirectionalTile)this).getFacing());
			this.func_70296_d();
			if(this.field_174879_c!=null)
				this.markBlockForUpdate(this.field_174879_c, null);
		}
	}


	public void receiveMessageFromClient(NBTTagCompound message)
	{
	}
	public void receiveMessageFromServer(NBTTagCompound message)
	{
	}

	public void onEntityCollision(World world, Entity entity)
	{
	}
	@Override
	public boolean func_145842_c(int id, int type)
	{
		if(id == 0 || id == 255)
		{
			markContainingBlockForUpdate(null);
			return true;
		} else if(id == 254)
		{
			IBlockState state = field_145850_b.func_180495_p(field_174879_c);
			if(state instanceof IExtendedBlockState)
				ImmersiveEngineering.proxy.removeStateFromSmartModelCache((IExtendedBlockState) state);
			field_145850_b.func_184138_a(field_174879_c, state, state, 3);
			return true;
		}
		return super.func_145842_c(id, type);
	}
	@Override
	public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState)
	{
		if (world.func_175667_e(pos))
			newState = world.func_180495_p(pos);
		if (oldState.func_177230_c()!=newState.func_177230_c()||!(oldState.func_177230_c() instanceof BlockIEBase)||!(newState.func_177230_c() instanceof BlockIEBase))
			return true;
		IProperty type = ((BlockIEBase)oldState.func_177230_c()).getMetaProperty();
		return oldState.func_177229_b(type) != newState.func_177229_b(type);
	}

	public void markContainingBlockForUpdate(@Nullable IBlockState newState)
	{
		markBlockForUpdate(func_174877_v(), newState);
	}
	public void markBlockForUpdate(BlockPos pos, @Nullable IBlockState newState)
	{
		IBlockState state = field_145850_b.func_180495_p(func_174877_v());
		if(newState==null)
			newState = state;
		field_145850_b.func_184138_a(pos,state,newState,3);
		field_145850_b.func_175685_c(pos, newState.func_177230_c(), true);
	}


	@Override
	public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing)
	{
		if(capability==CapabilityEnergy.ENERGY && this instanceof EnergyHelper.IIEInternalFluxConnector)
			return ((EnergyHelper.IIEInternalFluxConnector)this).getCapabilityWrapper(facing)!=null;
		return super.hasCapability(capability, facing);
	}
	@Override
	public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing)
	{
		if(capability==CapabilityEnergy.ENERGY && this instanceof EnergyHelper.IIEInternalFluxConnector)
			return (T)((EnergyHelper.IIEInternalFluxConnector)this).getCapabilityWrapper(facing);
		return super.getCapability(capability, facing);
	}
}
