/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.*;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Locale;

public class ItemBlockIEBase extends ItemBlock
{
	private int[] burnTime;

	public ItemBlockIEBase(Block b)
	{
		super(b);
		if(((BlockIEBase)b).enumValues.length>1)
			func_77627_a(true);
		this.burnTime = new int[((BlockIEBase)b).enumValues!=null?((BlockIEBase)b).enumValues.length:1];
	}

	@Override
	public int func_77647_b (int damageValue)
	{
		return damageValue;
	}

	@Override
	public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> itemList)
	{
		if(this.func_194125_a(tab))
			this.field_150939_a.func_149666_a(tab, itemList);
	}
	@Override
	public String func_77667_c(ItemStack stack)
	{
		return ((BlockIEBase) this.field_150939_a).getUnlocalizedName(stack);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public FontRenderer getFontRenderer(ItemStack stack)
	{
		return ClientProxy.itemFont;
	}

	@Override
	public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag)
	{
		if(((BlockIEBase)field_150939_a).hasFlavour(stack))
		{
			String subName = ((BlockIEBase)this.field_150939_a).func_176203_a(stack.func_77952_i()).func_177229_b(((BlockIEBase)this.field_150939_a).property).toString().toLowerCase(Locale.US);
			String flavourKey = Lib.DESC_FLAVOUR+((BlockIEBase)this.field_150939_a).name+"."+subName;
			tooltip.add(TextFormatting.GRAY.toString()+ I18n.func_135052_a(flavourKey));
		}
		super.func_77624_a(stack, world, tooltip, tooltipFlag);
		if(ItemNBTHelper.hasKey(stack, "energyStorage"))
			tooltip.add(I18n.func_135052_a("desc.immersiveengineering.info.energyStored", ItemNBTHelper.getInt(stack, "energyStorage")));
		if(ItemNBTHelper.hasKey(stack, "tank"))
		{
			FluidStack fs = FluidStack.loadFluidStackFromNBT(ItemNBTHelper.getTagCompound(stack, "tank"));
			if(fs!=null)
				tooltip.add(fs.getLocalizedName()+": "+fs.amount+"mB");
		}
	}


	public ItemBlockIEBase setBurnTime(int meta, int burnTime)
	{
		if(meta>=0 && meta<this.burnTime.length)
			this.burnTime[meta] = burnTime;
		return this;
	}
	@Override
	public int getItemBurnTime(ItemStack itemStack)
	{
		return this.burnTime[Math.max(0, Math.min(itemStack.func_77960_j(), this.burnTime.length-1))];
	}

	@Override
	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState)
	{
		if(!((BlockIEBase)this.field_150939_a).canIEBlockBePlaced(world, pos, newState, side, hitX,hitY,hitZ, player, stack))
			return false;
		boolean ret = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
		if(ret)
		{
			((BlockIEBase)this.field_150939_a).onIEBlockPlacedBy(world, pos, newState, side, hitX,hitY,hitZ, player, stack);
		}
		return ret;
	}

	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ)
	{
		ItemStack stack = player.func_184586_b(hand);
		IBlockState iblockstate = world.func_180495_p(pos);
		Block block = iblockstate.func_177230_c();
		if (!block.func_176200_f(world, pos))
			pos = pos.func_177972_a(side);
		if(stack.func_190916_E() > 0 && player.func_175151_a(pos, side, stack) && canBlockBePlaced(world, pos, side, stack))
		{
			int i = this.func_77647_b(stack.func_77960_j());
			IBlockState iblockstate1 = this.field_150939_a.func_180642_a(world, pos, side, hitX, hitY, hitZ, i, player);
			if(placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, iblockstate1))
			{
				SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, player);
				world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0F) / 2.0F, soundtype.func_185847_b() * 0.8F);
				if(!player.field_71075_bZ.field_75098_d)
					stack.func_190918_g(1);
			}
			return EnumActionResult.SUCCESS;
		}
		return EnumActionResult.FAIL;
	}
	@Override
	public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack)
	{
		Block block = worldIn.func_180495_p(pos).func_177230_c();

		if(block == Blocks.field_150431_aC && block.func_176200_f(worldIn, pos))
		{
			side = EnumFacing.UP;
		} else if(!block.func_176200_f(worldIn, pos))
		{
			pos = pos.func_177972_a(side);
		}

		return canBlockBePlaced(worldIn, pos, side, stack);
	}
	private boolean canBlockBePlaced(World w, BlockPos pos, EnumFacing side, ItemStack stack)
	{
		BlockIEBase blockIn = (BlockIEBase) this.field_150939_a;
		Block block = w.func_180495_p(pos).func_177230_c();
		AxisAlignedBB axisalignedbb = blockIn.func_180646_a( blockIn.func_176203_a(stack.func_77952_i()), w, pos);
		if (axisalignedbb != null && !w.func_72917_a(axisalignedbb.func_186670_a(pos), null)) return false;
		return block.func_176200_f(w, pos) && blockIn.func_176198_a(w, pos, side);
	}

	public static class ItemBlockIENoInventory extends ItemBlockIEBase
	{
		public ItemBlockIENoInventory(Block b)
		{
			super(b);
		}

		@Nullable
		@Override
		public NBTTagCompound getNBTShareTag(ItemStack stack)
		{
			NBTTagCompound ret = super.getNBTShareTag(stack);
			if (ret!=null) {
				ret = ret.func_74737_b();
				ret.func_82580_o("inventory");
			}
			return ret;
		}

		@Override
		public boolean func_77651_p()
		{
			return super.func_77651_p();
		}
	}
}
