/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;
import java.util.List;

public class BlockIEScaffoldSlab<E extends Enum<E>&BlockIEBase.IBlockEnum> extends BlockIESlab<E>
{
	public BlockIEScaffoldSlab(String name, Material material, PropertyEnum property)
	{
		super(name, material, property);
		setBlockLayer(BlockRenderLayer.CUTOUT_MIPPED);
	}

	@Override
	public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_)
	{
		TileEntity te = world.func_175625_s(pos);
		if(te instanceof TileEntityIESlab)
		{
			int type = ((TileEntityIESlab)te).slabType;
			if(type==0)
				func_185492_a(pos, entityBox, collidingBoxes, new AxisAlignedBB(.0625f, 0, .0625f, .9375f, .5, .9375f));
			else if(type==1)
				func_185492_a(pos, entityBox, collidingBoxes, new AxisAlignedBB(.0625f, .5, .0625f, .9375f, 1, .9375f));
			else
				func_185492_a(pos, entityBox, collidingBoxes, new AxisAlignedBB(.0625f, 0, .0625f, .9375f, 1, .9375f));
		}
		else
			func_185492_a(pos, entityBox, collidingBoxes, new AxisAlignedBB(.0625f, 0, .0625f, .9375f, .5, .9375f));
	}

	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		TileEntity te = world.func_175625_s(pos);
		if(te instanceof TileEntityIESlab)
		{
			int type = ((TileEntityIESlab)te).slabType;
			if(type==0)
				return new AxisAlignedBB(0,0,0, 1,.5f,1);
			else if(type==1)
				return new AxisAlignedBB(0,.5f,0, 1,1,1);
			else
				return field_185505_j;
		}
		else
			return new AxisAlignedBB(0,0,0,1,.5f,1);
	}

	@Override
	public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn)
	{
		super.func_180634_a(worldIn, pos, state, entityIn);
		if (entityIn instanceof EntityLivingBase&&!((EntityLivingBase) entityIn).func_70617_f_()&&isLadder(state, worldIn, pos, (EntityLivingBase)entityIn))
		{
			float f5 = 0.15F;
			if (entityIn.field_70159_w < -f5)
				entityIn.field_70159_w = -f5;
			if (entityIn.field_70159_w > f5)
				entityIn.field_70159_w = f5;
			if (entityIn.field_70179_y < -f5)
				entityIn.field_70179_y = -f5;
			if (entityIn.field_70179_y > f5)
				entityIn.field_70179_y = f5;

			entityIn.field_70143_R = 0.0F;
			if (entityIn.field_70181_x < -0.15D)
				entityIn.field_70181_x = -0.15D;

			if(entityIn.field_70181_x<0 && entityIn instanceof EntityPlayer && entityIn.func_70093_af())
			{
				entityIn.field_70181_x=0;
				return;
			}
			if(entityIn.field_70123_F)
				entityIn.field_70181_x=.2;
		}
	}

	@Override
	public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity)
	{
		TileEntity te = world.func_175625_s(pos);
		if(te instanceof TileEntityIESlab && ((TileEntityIESlab)te).slabType==0)
			return entity.field_70163_u-pos.func_177956_o()<.5;
		return true;
	}

	@Override
	public boolean allowHammerHarvest(IBlockState state)
	{
		return true;
	}
}
