/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.ITileDrop;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockIEMultiblock<E extends Enum<E> & BlockIEBase.IBlockEnum> extends BlockIETileProvider<E>
{
	public BlockIEMultiblock(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockIEBase> itemBlock, Object... additionalProperties)
	{
		super(name, material, mainProperty, itemBlock, combineProperties(additionalProperties, IEProperties.FACING_HORIZONTAL,IEProperties.MULTIBLOCKSLAVE));
	}
	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		state = super.func_176221_a(state, world, pos);
		return state;
	}

	@Override
	public void func_180663_b(World world, BlockPos pos, IBlockState state)
	{
		TileEntity tileEntity = world.func_175625_s(pos);
		if(tileEntity instanceof TileEntityMultiblockPart && world.func_82736_K().func_82766_b("doTileDrops"))
		{
			TileEntityMultiblockPart tile = (TileEntityMultiblockPart)tileEntity;
			if(!tile.formed && tile.pos==-1 && !tile.getOriginalBlock().func_190926_b())
				world.func_72838_d(new EntityItem(world, pos.func_177958_n()+.5,pos.func_177956_o()+.5,pos.func_177952_p()+.5, tile.getOriginalBlock().func_77946_l()));

			if(tile.formed && tile instanceof IIEInventory)
			{
				IIEInventory master = (IIEInventory)tile.master();
				if(master!=null && (!(master instanceof ITileDrop) || !((ITileDrop)master).preventInventoryDrop()) && master.getDroppedItems()!=null)
					for(ItemStack s : master.getDroppedItems())
						if(!s.func_190926_b())
							world.func_72838_d(new EntityItem(world, pos.func_177958_n()+.5,pos.func_177956_o()+.5,pos.func_177952_p()+.5, s.func_77946_l()));
			}
		}
		if(tileEntity instanceof TileEntityMultiblockPart)
			((TileEntityMultiblockPart)tileEntity).disassemble();
		super.func_180663_b(world, pos, state);
	}
	@Override
	public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune)
	{
	}
	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player)
	{
		ItemStack stack = getOriginalBlock(world, pos);
		if(!stack.func_190926_b())
			return stack;
		return super.getPickBlock(state, target, world, pos, player);
	}
	public ItemStack getOriginalBlock(World world, BlockPos pos)
	{
		TileEntity te = world.func_175625_s(pos);
		if(te instanceof TileEntityMultiblockPart)
			return ((TileEntityMultiblockPart)te).getOriginalBlock();
		return ItemStack.field_190927_a;
	}
}
