/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDevices;
import blusunrize.immersiveengineering.common.util.IEPotions;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;

import java.util.Random;

/**
 * @author BluSunrize - 22.01.2017
 */
public class BlockIEFluidConcrete extends BlockIEFluid
{
	public BlockIEFluidConcrete(String name, Fluid fluid, Material material)
	{
		super(name, fluid, material);
		this.setQuantaPerBlock(16);
	}

	@Override
	protected BlockStateContainer func_180661_e()
	{
		return new ExtendedBlockState(this, new IProperty[] { LEVEL, IEProperties.INT_16}, FLUID_RENDER_PROPS.toArray(new IUnlistedProperty<?>[0]));
	}

	@Override
	public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand)
	{
		if(!isSourceBlock(world, pos) && ForgeEventFactory.canCreateFluidSource(world, pos, state, false))
		{
			int adjacentSourceBlocks =
					(isSourceBlock(world, pos.func_177978_c()) ? 1 : 0) +
							(isSourceBlock(world, pos.func_177968_d()) ? 1 : 0) +
							(isSourceBlock(world, pos.func_177974_f()) ? 1 : 0) +
							(isSourceBlock(world, pos.func_177976_e()) ? 1 : 0);
			if(adjacentSourceBlocks >= 2 && (world.func_180495_p(pos.func_177981_b(densityDir)).func_185904_a().func_76220_a() || isSourceBlock(world, pos.func_177981_b(densityDir))))
				world.func_175656_a(pos, state.func_177226_a(LEVEL, 0));
		}

		int level = state.func_177229_b(LEVEL);
		int timer = state.func_177229_b(IEProperties.INT_16);
		int quantaRemaining = quantaPerBlock - level;
		int expQuanta = -101;
		if(timer>=Math.min(14,quantaRemaining))
		{
			IBlockState solidState;
			if(level>=14)
				solidState = IEContent.blockStoneDevice.func_176203_a(BlockTypes_StoneDevices.CONCRETE_SHEET.getMeta());
			else if(level>=10)
				solidState = IEContent.blockStoneDevice.func_176203_a(BlockTypes_StoneDevices.CONCRETE_QUARTER.getMeta());
			else if(level>=6)
				solidState = IEContent.blockStoneDecorationSlabs.func_176203_a(BlockTypes_StoneDecoration.CONCRETE.getMeta());
			else if(level>=2)
				solidState = IEContent.blockStoneDevice.func_176203_a(BlockTypes_StoneDevices.CONCRETE_THREEQUARTER.getMeta());
			else
				solidState = IEContent.blockStoneDecoration.func_176203_a(BlockTypes_StoneDecoration.CONCRETE.getMeta());
			world.func_175656_a(pos, solidState);
			for(EntityLivingBase living : world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos,pos.func_177982_a(1,1,1))))
				living.func_70690_d(new PotionEffect(IEPotions.concreteFeet,Integer.MAX_VALUE));
			return;
		}
		else
		{
			state = state.func_177226_a(IEProperties.INT_16, Math.min(15, timer+1));
			world.func_175656_a(pos, state);

		}

		// check adjacent block levels if non-source
		if(quantaRemaining < quantaPerBlock)
		{
			if(world.func_180495_p(pos.func_177982_a( 0, -densityDir,  0)).func_177230_c() == this ||
					world.func_180495_p(pos.func_177982_a(-1, -densityDir,  0)).func_177230_c() == this ||
					world.func_180495_p(pos.func_177982_a( 1, -densityDir,  0)).func_177230_c() == this ||
					world.func_180495_p(pos.func_177982_a( 0, -densityDir, -1)).func_177230_c() == this ||
					world.func_180495_p(pos.func_177982_a( 0, -densityDir,  1)).func_177230_c() == this)
			{
				expQuanta = quantaPerBlock - 1;
			}
			else
			{
				int maxQuanta = -100;
				maxQuanta = getLargerQuanta(world, pos.func_177982_a(-1, 0,  0), maxQuanta);
				maxQuanta = getLargerQuanta(world, pos.func_177982_a( 1, 0,  0), maxQuanta);
				maxQuanta = getLargerQuanta(world, pos.func_177982_a( 0, 0, -1), maxQuanta);
				maxQuanta = getLargerQuanta(world, pos.func_177982_a( 0, 0,  1), maxQuanta);

				expQuanta = maxQuanta - 1;
			}

			int total = level;
			int blocks = 1;
			for(EnumFacing f : EnumFacing.field_176754_o)
			{
				IBlockState otherState = world.func_180495_p(pos.func_177972_a(f));
				if(otherState.func_177230_c()==this)
				{
					blocks++;
					total += otherState.func_177229_b(LEVEL);
				}
			}
			int newEvenQuanta = (int)Math.ceil(total/(float)blocks);
			for(EnumFacing f : EnumFacing.field_176754_o)
			{
				IBlockState otherState = world.func_180495_p(pos.func_177972_a(f));
				if(otherState.func_177230_c()==this)
					world.func_175656_a(pos.func_177972_a(f), otherState.func_177226_a(LEVEL, newEvenQuanta));

			}

			// decay calculation
			if(expQuanta != quantaRemaining)
			{
				quantaRemaining = expQuanta;

				if(expQuanta <= 0)
					world.func_175698_g(pos);
				else
				{
					world.func_180501_a(pos, state.func_177226_a(LEVEL, quantaPerBlock - expQuanta), 2);
					world.func_175684_a(pos, this, tickRate);
					world.func_175685_c(pos, this, true);
				}
			}
		}
		// This is a "source" block, set meta to zero, and send a server only update
		else if(quantaRemaining >= quantaPerBlock)
			world.func_180501_a(pos, this.func_176223_P(), 2);

		// Flow vertically if possible
		if(canDisplace(world, pos.func_177981_b(densityDir)))
		{
			flowIntoBlockRet(world, pos.func_177981_b(densityDir), 1, timer);
			return;
		}

		// Flow outward if possible
		int flowMeta = quantaPerBlock - quantaRemaining + 1;
		if(flowMeta >= quantaPerBlock)
		{
			world.func_175656_a(pos, state.func_177226_a(IEProperties.INT_16, Math.min(15, timer+1)));
			world.func_175684_a(pos, this, tickRate);
			return;
		}

		if(isSourceBlock(world, pos) || !isFlowingVertically(world, pos))
		{
			if(world.func_180495_p(pos.func_177979_c(densityDir)).func_177230_c() == this)
				flowMeta = 1;
			boolean flowTo[] = getOptimalFlowDirections(world, pos);
			boolean hasFlown = false;
			if(flowTo[0])
				hasFlown |= flowIntoBlockRet(world, pos.func_177982_a(-1, 0,  0), flowMeta, timer);
			if(flowTo[1])
				hasFlown |= flowIntoBlockRet(world, pos.func_177982_a( 1, 0,  0), flowMeta, timer);
			if(flowTo[2])
				hasFlown |= flowIntoBlockRet(world, pos.func_177982_a( 0, 0, -1), flowMeta, timer);
			if(flowTo[3])
				hasFlown |= flowIntoBlockRet(world, pos.func_177982_a( 0, 0,  1), flowMeta, timer);

			if(!hasFlown)
			{
				world.func_175656_a(pos, state.func_177226_a(IEProperties.INT_16, Math.min(15, timer+1)));
				world.func_175684_a(pos, this, tickRate);
			}
		}
	}

	protected boolean flowIntoBlockRet(World world, BlockPos pos, int meta, int harden)
	{
		if(meta < 0)
			return false;
		if(displaceIfPossible(world, pos))
		{
			world.func_180501_a(pos, this.func_176194_O().func_177621_b().func_177226_a(LEVEL, meta).func_177226_a(IEProperties.INT_16, harden), 3);
			return true;
		}
		return false;
	}
}
