/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IIEMetaBlock;
import com.google.common.collect.Sets;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.*;

public class BlockIEBase<E extends Enum<E> & BlockIEBase.IBlockEnum> extends Block implements IIEMetaBlock
{
	protected static IProperty[] tempProperties;
	protected static IUnlistedProperty[] tempUnlistedProperties;

	public final String name;
	public final PropertyEnum<E> property;
	public final IProperty[] additionalProperties;
	public final IUnlistedProperty[] additionalUnlistedProperties;
	public final E[] enumValues;
	boolean[] isMetaHidden;
	boolean[] hasFlavour;
	protected Set<BlockRenderLayer> renderLayers = Sets.newHashSet(BlockRenderLayer.SOLID);
	protected Set<BlockRenderLayer>[] metaRenderLayers;
	protected Map<Integer, Integer> metaLightOpacities = new HashMap<>();
	protected Map<Integer, Float> metaHardness = new HashMap<>();
	protected Map<Integer, Integer> metaResistances = new HashMap<>();
	protected EnumPushReaction[] metaMobilityFlags;
	protected boolean[] canHammerHarvest;
	protected boolean[] metaNotNormalBlock;
	private boolean opaqueCube = false;
	public BlockIEBase(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockIEBase> itemBlock, Object... additionalProperties)
	{
		super(setTempProperties(material, mainProperty, additionalProperties));
		this.name = name;
		this.property = mainProperty;
		this.enumValues = mainProperty.func_177699_b().getEnumConstants();
		this.isMetaHidden = new boolean[this.enumValues.length];
		this.hasFlavour = new boolean[this.enumValues.length];
		this.metaRenderLayers = new Set[this.enumValues.length];
		this.canHammerHarvest = new boolean[this.enumValues.length];
		this.metaMobilityFlags = new EnumPushReaction[this.enumValues.length];

		ArrayList<IProperty> propList = new ArrayList<IProperty>();
		ArrayList<IUnlistedProperty> unlistedPropList = new ArrayList<IUnlistedProperty>();
		for(Object o : additionalProperties)
		{
			if(o instanceof IProperty)
				propList.add((IProperty)o);
			if(o instanceof IProperty[])
				for(IProperty p : ((IProperty[])o))
					propList.add(p);
			if(o instanceof IUnlistedProperty)
				unlistedPropList.add((IUnlistedProperty)o);
			if(o instanceof IUnlistedProperty[])
				for(IUnlistedProperty p : ((IUnlistedProperty[])o))
					unlistedPropList.add(p);
		}
		this.additionalProperties = propList.toArray(new IProperty[propList.size()]);
		this.additionalUnlistedProperties = unlistedPropList.toArray(new IUnlistedProperty[unlistedPropList.size()]);
		this.func_180632_j(getInitDefaultState());
		String registryName = createRegistryName();
		this.func_149663_c(registryName.replace(':', '.'));
		this.func_149647_a(ImmersiveEngineering.creativeTab);
		this.adjustSound();

//		ImmersiveEngineering.registerBlockByFullName(this, itemBlock, registryName);
		IEContent.registeredIEBlocks.add(this);
		try{
			IEContent.registeredIEItems.add(itemBlock.getConstructor(Block.class).newInstance(this));
		}catch(Exception e){e.printStackTrace();}
		field_149786_r = 255;
	}

	@Override
	public String getIEBlockName()
	{
		return this.name;
	}
	@Override
	public Enum[] getMetaEnums()
	{
		return enumValues;
	}
	@Override
	public IBlockState getInventoryState(int meta)
	{
		return func_176203_a(meta);
	}
	@Override
	public PropertyEnum<E> getMetaProperty()
	{
		return this.property;
	}
	@Override
	public boolean useCustomStateMapper()
	{
		return false;
	}
	@Override
	public String getCustomStateMapping(int meta, boolean itemBlock)
	{
		return null;
	}
	@Override
	@SideOnly(Side.CLIENT)
	public StateMapperBase getCustomMapper()
	{
		return null;
	}

	@Override
	public boolean appendPropertiesToState()
	{
		return true;
	}

	public String getUnlocalizedName(ItemStack stack)
	{
		String subName = func_176203_a(stack.func_77952_i()).func_177229_b(property).toString().toLowerCase(Locale.US);
		return super.func_149739_a() + "." + subName;
	}

	protected static Material setTempProperties(Material material, PropertyEnum<?> property, Object... additionalProperties)
	{
		ArrayList<IProperty> propList = new ArrayList<IProperty>();
		ArrayList<IUnlistedProperty> unlistedPropList = new ArrayList<IUnlistedProperty>();
		propList.add(property);
		for(Object o : additionalProperties)
		{
			if(o instanceof IProperty)
				propList.add((IProperty)o);
			if(o instanceof IProperty[])
				for(IProperty p : ((IProperty[])o))
					propList.add(p);
			if(o instanceof IUnlistedProperty)
				unlistedPropList.add((IUnlistedProperty)o);
			if(o instanceof IUnlistedProperty[])
				for(IUnlistedProperty p : ((IUnlistedProperty[])o))
					unlistedPropList.add(p);
		}
		tempProperties = propList.toArray(new IProperty[propList.size()]);
		tempUnlistedProperties = unlistedPropList.toArray(new IUnlistedProperty[unlistedPropList.size()]);
		return material;
	}
	protected static Object[] combineProperties(Object[] currentProperties, Object... addedProperties)
	{
		Object[] array = new Object[currentProperties.length + addedProperties.length];
		for(int i=0; i<currentProperties.length; i++)
			array[i] = currentProperties[i];
		for(int i=0; i<addedProperties.length; i++)
			array[currentProperties.length+i] = addedProperties[i];
		return array;
	}

	public BlockIEBase setMetaHidden(int... meta)
	{
		for(int i : meta)
			if(i>=0 && i<this.isMetaHidden.length)
				this.isMetaHidden[i] = true;
		return this;
	}
	public BlockIEBase setMetaUnhidden(int... meta)
	{
		for(int i : meta)
			if(i>=0 && i<this.isMetaHidden.length)
				this.isMetaHidden[i] = false;
		return this;
	}
	public boolean isMetaHidden(int meta)
	{
		return this.isMetaHidden[Math.max(0, Math.min(meta, this.isMetaHidden.length-1))];
	}

	public BlockIEBase setHasFlavour(int... meta)
	{
		if(meta==null||meta.length<1)
			for(int i=0; i<hasFlavour.length; i++)
				this.hasFlavour[i] = true;
		else
			for(int i : meta)
				if(i>=0 && i<this.hasFlavour.length)
					this.hasFlavour[i] = false;
		return this;
	}
	public boolean hasFlavour(ItemStack stack)
	{
		return this.hasFlavour[Math.max(0, Math.min(stack.func_77952_i(), this.hasFlavour.length-1))];
	}

	public BlockIEBase<E> setBlockLayer(BlockRenderLayer... layer)
	{
		this.renderLayers = Sets.newHashSet(layer);
		return this;
	}
	public BlockIEBase<E> setMetaBlockLayer(int meta, BlockRenderLayer... layer)
	{
		this.metaRenderLayers[Math.max(0, Math.min(meta, this.metaRenderLayers.length-1))] = Sets.newHashSet(layer);
		return this;
	}

	@Override
	public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer)
	{
		int meta = this.func_176201_c(state);
		if (meta >= 0 && meta < metaRenderLayers.length && metaRenderLayers[meta] != null)
			return metaRenderLayers[meta].contains(layer);
		return renderLayers.contains(layer);
	}
	public BlockIEBase<E> setMetaLightOpacity(int meta, int opacity)
	{
		metaLightOpacities.put(meta, opacity);
		return this;
	}
	@Override
	public int getLightOpacity(IBlockState state, IBlockAccess w, BlockPos pos)
	{
		int meta = func_176201_c(state);
		if(metaLightOpacities.containsKey(meta))
			return metaLightOpacities.get(meta);
		return super.getLightOpacity(state,w,pos);
	}

	public BlockIEBase<E> setMetaHardness(int meta, float hardness)
	{
		metaHardness.put(meta, hardness);
		return this;
	}
	@Override
	public float func_176195_g(IBlockState state, World world, BlockPos pos)
	{
		int meta = func_176201_c(state);
		if(metaHardness.containsKey(meta))
			return metaHardness.get(meta);
		return super.func_176195_g(state, world, pos);
	}

	public BlockIEBase<E> setMetaExplosionResistance(int meta, int resistance)
	{
		metaResistances.put(meta, resistance);
		return this;
	}
	@Override
	public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion)
	{
		int meta = func_176201_c(world.func_180495_p(pos));
		if(metaResistances.containsKey(meta))
			return metaResistances.get(meta);
		return super.getExplosionResistance(world, pos, exploder, explosion);
	}


	public BlockIEBase<E> setMetaMobilityFlag(int meta, EnumPushReaction flag)
	{
		metaMobilityFlags[meta] = flag;
		return this;
	}
	@Override
	public EnumPushReaction func_149656_h(IBlockState state)
	{
		int meta = func_176201_c(state);
		if(metaMobilityFlags[meta]==null)
			return EnumPushReaction.NORMAL;
		return metaMobilityFlags[meta];
	}

	public BlockIEBase<E> setNotNormalBlock(int meta)
	{
		if(metaNotNormalBlock == null)
			metaNotNormalBlock = new boolean[this.enumValues.length];
		metaNotNormalBlock[meta] = true;
		return this;
	}
	public BlockIEBase<E> setAllNotNormalBlock()
	{
		if(metaNotNormalBlock == null)
			metaNotNormalBlock = new boolean[this.enumValues.length];
		for(int i = 0; i < metaNotNormalBlock.length; i++)
			metaNotNormalBlock[i] = true;
		return this;
	}
	protected boolean normalBlockCheck(IBlockState state)
	{
		if(metaNotNormalBlock == null)
			return true;
		int meta = func_176201_c(state);
		return (meta < 0 || meta >= metaNotNormalBlock.length) || !metaNotNormalBlock[meta];
	}
	@Override
	public boolean func_149730_j(IBlockState state)
	{
		return normalBlockCheck(state);
	}
	@Override
	public boolean func_149686_d(IBlockState state)
	{
		return normalBlockCheck(state);
	}
	@Override
	public boolean func_149662_c(IBlockState state)
	{
		return normalBlockCheck(state);
	}

	@Override
	public boolean func_176214_u(IBlockState state)
	{
		if(metaNotNormalBlock == null)
			return true;
		int majority = 0;
		for(boolean b : metaNotNormalBlock)
			if(b)
				majority++;
		return majority<metaNotNormalBlock.length/2;
	}
	@Override
	public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos)
	{
		return normalBlockCheck(state);
	}

	protected BlockStateContainer createNotTempBlockState()
	{
		IProperty[] array = new IProperty[1+this.additionalProperties.length];
		array[0] = this.property;
		for(int i=0; i<this.additionalProperties.length; i++)
			array[1+i] = this.additionalProperties[i];
		if(this.additionalUnlistedProperties.length>0)
			return new ExtendedBlockState(this, array, additionalUnlistedProperties);
		return new BlockStateContainer(this, array);
	}
	protected IBlockState getInitDefaultState()
	{
		IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(this.property, enumValues[0]);
		for(int i=0; i<this.additionalProperties.length; i++)
			if(this.additionalProperties[i]!=null && !this.additionalProperties[i].func_177700_c().isEmpty())
				state = applyProperty(state, additionalProperties[i], additionalProperties[i].func_177700_c().iterator().next());
		return state;
	}

	protected <V extends Comparable<V>> IBlockState applyProperty(IBlockState in, IProperty<V> prop, Object val)
	{
		return in.func_177226_a(prop, (V)val);
	}

	public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack)
	{
	}
	public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack)
	{
		return true;
	}

	@Override
	protected BlockStateContainer func_180661_e()
	{
		if(this.property!=null)
			return createNotTempBlockState();
		if(tempUnlistedProperties.length>0)
			return new ExtendedBlockState(this, tempProperties, tempUnlistedProperties);
		return new BlockStateContainer(this, tempProperties);
	}
	@Override
	public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack)
	{
		super.func_180633_a(worldIn, pos, state, placer, stack);
	}
	@Override
	public int func_176201_c(IBlockState state)
	{
		if(state==null || !this.equals(state.func_177230_c()))
			return 0;
		return state.func_177229_b(this.property).getMeta();
	}
	protected E fromMeta(int meta)
	{
		if(meta<0||meta>=enumValues.length)
			meta = 0;
		return enumValues[meta];
	}

	@Override
	public IBlockState func_176203_a(int meta)
	{
		return this.func_176223_P().func_177226_a(this.property, fromMeta(meta));
	}

	@Override
	public int func_180651_a(IBlockState state)
	{
		return func_176201_c(state);
	}
	@SideOnly(Side.CLIENT)
	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list)
	{
		for(E type : this.enumValues)
			if(type.listForCreative() && !this.isMetaHidden[type.getMeta()])
				list.add(new ItemStack(this, 1, type.getMeta()));
	}

	void adjustSound()
	{
		if(this.field_149764_J==Material.field_151574_g)
			this.field_149762_H = SoundType.field_185858_k;
		else if(this.field_149764_J==Material.field_151593_r||this.field_149764_J==Material.field_151580_n)
			this.field_149762_H = SoundType.field_185854_g;
		else if(this.field_149764_J==Material.field_151592_s||this.field_149764_J==Material.field_151588_w)
			this.field_149762_H = SoundType.field_185853_f;
		else if(this.field_149764_J==Material.field_151577_b||this.field_149764_J==Material.field_151590_u||this.field_149764_J==Material.field_151585_k||this.field_149764_J==Material.field_151582_l)
			this.field_149762_H = SoundType.field_185850_c;
		else if(this.field_149764_J==Material.field_151578_c)
			this.field_149762_H = SoundType.field_185849_b;
		else if(this.field_149764_J==Material.field_151573_f)
			this.field_149762_H = SoundType.field_185852_e;
		else if(this.field_149764_J==Material.field_151595_p)
			this.field_149762_H = SoundType.field_185855_h;
		else if(this.field_149764_J==Material.field_151597_y)
			this.field_149762_H = SoundType.field_185856_i;
		else if(this.field_149764_J==Material.field_151576_e)
			this.field_149762_H = SoundType.field_185851_d;
		else if(this.field_149764_J==Material.field_151575_d||this.field_149764_J==Material.field_151570_A)
			this.field_149762_H = SoundType.field_185848_a;
	}

	@Override
	public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam)
	{
		if (worldIn.field_72995_K&&eventID==255)
		{
			worldIn.func_184138_a(pos,state,state,3);
			return true;
		}
		return super.func_189539_a(state, worldIn, pos, eventID, eventParam);
	}

	public BlockIEBase<E> setMetaHammerHarvest(int meta)
	{
		canHammerHarvest[meta] = true;
		return this;
	}
	public BlockIEBase<E> setHammerHarvest()
	{
		for(int i = 0; i < metaNotNormalBlock.length; i++)
			canHammerHarvest[i] = true;
		return this;
	}
	public boolean allowHammerHarvest(IBlockState blockState)
	{
		int meta = func_176201_c(blockState);
		if(meta>=0&&meta<canHammerHarvest.length)
			return canHammerHarvest[meta];
		return false;
	}
	public boolean allowWirecutterHarvest(IBlockState blockState)
	{
		return false;
	}
	public boolean isOpaqueCube()
	{
		return opaqueCube;
	}
	public BlockIEBase<E> setOpaque(boolean isOpaque)
	{
		opaqueCube = isOpaque;
		field_149787_q = isOpaque;
		return this;
	}

	@Override
	public boolean isToolEffective(String type, IBlockState state)
	{
		if(allowHammerHarvest(state) && type.equals(Lib.TOOL_HAMMER))
			return true;
		if(allowWirecutterHarvest(state) && type.equals(Lib.TOOL_WIRECUTTER))
			return true;
		return super.isToolEffective(type, state);
	}
	public String createRegistryName()
	{
		return ImmersiveEngineering.MODID+":"+name;
	}

	public interface IBlockEnum extends IStringSerializable
	{
		int getMeta();
		boolean listForCreative();
	}
	public abstract static class IELadderBlock<E extends Enum<E> & IBlockEnum> extends BlockIEBase<E>
	{
		public IELadderBlock(String name, Material material, PropertyEnum<E> mainProperty,
							 Class<? extends ItemBlockIEBase> itemBlock, Object... additionalProperties)
		{
			super(name, material, mainProperty, itemBlock, additionalProperties);
		}

		@Override
		public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn)
		{
			super.func_180634_a(worldIn, pos, state, entityIn);
			if (entityIn instanceof EntityLivingBase&&!((EntityLivingBase) entityIn).func_70617_f_()&&isLadder(state, worldIn, pos, (EntityLivingBase)entityIn))
			{
				float f5 = 0.15F;
				if (entityIn.field_70159_w < -f5)
					entityIn.field_70159_w = -f5;
				if (entityIn.field_70159_w > f5)
					entityIn.field_70159_w = f5;
				if (entityIn.field_70179_y < -f5)
					entityIn.field_70179_y = -f5;
				if (entityIn.field_70179_y > f5)
					entityIn.field_70179_y = f5;

				entityIn.field_70143_R = 0.0F;
				if (entityIn.field_70181_x < -0.15D)
					entityIn.field_70181_x = -0.15D;

				if(entityIn.field_70181_x<0 && entityIn instanceof EntityPlayer && entityIn.func_70093_af())
				{
					entityIn.field_70181_x=0;
					return;
				}
				if(entityIn.field_70123_F)
					entityIn.field_70181_x=.2;
			}
		}
	}
}
