/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler.Connection;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.CapabilityShader.ShaderWrapper;
import blusunrize.immersiveengineering.api.shader.CapabilityShader.ShaderWrapper_Direct;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler.MineralMix;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.BlockIEMultiblock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IEntityProof;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.ISpawnInterdiction;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration2;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingThreadHandler;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.items.ItemIEShield;
import blusunrize.immersiveengineering.common.util.*;
import blusunrize.immersiveengineering.common.util.IEDamageSources.TeslaDamageSource;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.util.network.MessageMineralListSync;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.*;
import net.minecraftforge.event.entity.living.LivingEvent.LivingJumpEvent;
import net.minecraftforge.event.entity.living.LivingEvent.LivingUpdateEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent.PlayerLoggedInEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent.PlayerLoggedOutEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent.WorldTickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

import java.lang.reflect.Field;
import java.util.*;
import java.util.Map.Entry;

public class EventHandler
{
	public static ArrayList<ISpawnInterdiction> interdictionTiles = new ArrayList<ISpawnInterdiction>();
	public static boolean validateConnsNextTick = false;
	public static HashSet<IEExplosion> currentExplosions = new HashSet<IEExplosion>();
	public static final Queue<Pair<Integer, BlockPos>> requestedBlockUpdates = new LinkedList<>();
	public static final Set<TileEntity> REMOVE_FROM_TICKING = new HashSet<>();

	@SubscribeEvent
	public void onLoad(WorldEvent.Load event)
	{
		//		if(event.world.provider.dimensionId==0)
		//		{
		/*
		 if(ImmersiveNetHandler.INSTANCE==null)
		 ImmersiveNetHandler.INSTANCE = new ImmersiveNetHandler();
		 if(!event.world.isRemote && !IESaveData.loaded)
		 {
		 IELogger.info("[ImEng] - world data loading, dimension "+event.world.provider.dimensionId);
		 IESaveData worldData = (IESaveData) event.world.loadItemData(IESaveData.class, IESaveData.dataName);
		 if(worldData==null)
		 {
		 IELogger.info("[ImEng] - No World Data Found");
		 worldData = new IESaveData(IESaveData.dataName);
		 //				worldData.dimension = event.world.provider.dimensionId;
		 event.world.setItemData(IESaveData.dataName, worldData);
		 }
		 else
		 IELogger.info("World Data Retrieved");
		 IESaveData.setInstance(event.world.provider.dimensionId, worldData);
		 IESaveData.loaded = true;
		 }
		 */
		//		}
		ImmersiveEngineering.proxy.onWorldLoad();
		if (IEConfig.blocksBreakWires)
			event.getWorld().func_72954_a(ImmersiveNetHandler.INSTANCE.LISTENER);
	}
	//transferPerTick
	@SubscribeEvent
	public void onSave(WorldEvent.Save event)
	{
		IESaveData.setDirty(0);
	}
	@SubscribeEvent
	public void onUnload(WorldEvent.Unload event)
	{
		IESaveData.setDirty(0);
	}

	@SubscribeEvent
	public void onCapabilitiesAttach(AttachCapabilitiesEvent event)
	{
		if(event.getObject() instanceof EntityMinecart)
		{
			EntityMinecart entityMinecart = (EntityMinecart) event.getObject();
			event.addCapability(new ResourceLocation("immersiveengineering:shader"), new ShaderWrapper_Direct("immersiveengineering:minecart"));
		}
	}
	@SubscribeEvent
	public void onMinecartInteraction(MinecartInteractEvent event)
	{
		if(!event.getPlayer().field_70170_p.field_72995_K && !event.getItem().func_190926_b() && event.getItem().func_77973_b() instanceof IShaderItem)
			if(event.getMinecart().hasCapability(CapabilityShader.SHADER_CAPABILITY, null))
//				if(event.getMinecart().hasCapability(CapabilityHandler_CartShaders.SHADER_CAPABILITY, null))
			{
				ShaderWrapper handler = event.getMinecart().getCapability(CapabilityShader.SHADER_CAPABILITY, null);
				if(handler != null)
				{
					handler.setShaderItem(Utils.copyStackWithAmount(event.getItem(), 1));
					ImmersiveEngineering.packetHandler.sendTo(new MessageMinecartShaderSync(event.getMinecart(), handler), (EntityPlayerMP) event.getPlayer());
					event.setCanceled(true);
				}
			}
	}

	public static List<ResourceLocation> lootInjections = Arrays.asList(new ResourceLocation(ImmersiveEngineering.MODID, "chests/stronghold_library"),new ResourceLocation(ImmersiveEngineering.MODID, "chests/village_blacksmith"));
	static Field f_lootEntries;
	@SubscribeEvent
	public void lootLoad(LootTableLoadEvent event)
	{
		if(event.getName().func_110624_b().equals("minecraft"))
			for(ResourceLocation inject : lootInjections)
				if(event.getName().func_110623_a().equals(inject.func_110623_a()))
				{
					LootPool injectPool = Utils.loadBuiltinLootTable(inject, event.getLootTableManager()).getPool("immersiveengineering_loot_inject");
					LootPool mainPool = event.getTable().getPool("main");
					if(injectPool!=null && mainPool!=null)
						try
						{
							if(f_lootEntries==null)
							{
								f_lootEntries = LootPool.class.getDeclaredField(ObfuscationReflectionHelper.remapFieldNames(LootPool.class.getName(), "field_186453_a")[0]);//field_186453_a is srg for lootEntries
								f_lootEntries.setAccessible(true);
							}
							if(f_lootEntries!=null)
							{
								List<LootEntry> entryList = (List<LootEntry>) f_lootEntries.get(injectPool);
								for(LootEntry entry : entryList)
									mainPool.addEntry(entry);
							}
						}catch(Exception e){
							e.printStackTrace();
						}
				}
	}

	@SubscribeEvent
	public void onEntityJoiningWorld(EntityJoinWorldEvent event)
	{
		if(event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityMinecart && event.getEntity().hasCapability(CapabilityShader.SHADER_CAPABILITY,null))
			ImmersiveEngineering.packetHandler.sendToServer(new MessageMinecartShaderSync(event.getEntity(),null));
	}
//	@SubscribeEvent
//	public void onEntityInteract(EntityInteractEvent event)
//	{
//		if(event.target instanceof EntityLivingBase && OreDictionary.itemMatches(new ItemStack(IEContent.itemRevolver,1,OreDictionary.WILDCARD_VALUE), event.entityPlayer.getCurrentEquippedItem(), false))
//			event.setCanceled(true);
//	}



	@SubscribeEvent
	public void onWorldTick(WorldTickEvent event)
	{
		if (event.phase==TickEvent.Phase.START && validateConnsNextTick && FMLCommonHandler.instance().getEffectiveSide()==Side.SERVER)
		{
			boolean validateConnections = IEConfig.validateConnections;
			int invalidConnectionsDropped = 0;
			for (int dim:ImmersiveNetHandler.INSTANCE.getRelevantDimensions())
			{
				if (!validateConnections)
				{
					continue;
				}
				World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
				if (world==null) {
					ImmersiveNetHandler.INSTANCE.directConnections.remove(dim);
					continue;
				}
				for (Connection con:ImmersiveNetHandler.INSTANCE.getAllConnections(world))
				{
					if (!(world.func_175625_s(con.start) instanceof IImmersiveConnectable
							&& world.func_175625_s(con.end) instanceof IImmersiveConnectable))
					{
						ImmersiveNetHandler.INSTANCE.removeConnection(world, con);
						invalidConnectionsDropped++;
					}
				}
				IELogger.info("removed "+invalidConnectionsDropped+" invalid connections from world");
			}
			int invalidProxies = 0;
			Set<DimensionBlockPos> toRemove = new HashSet<>();
			for (Entry<DimensionBlockPos, IICProxy> e:ImmersiveNetHandler.INSTANCE.proxies.entrySet())
			{
				if (!validateConnections)
				{
					continue;
				}
				DimensionBlockPos p = e.getKey();
				World w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(p.dimension);
				if (w!=null&&w.func_175667_e(p))
					toRemove.add(p);
				if (validateConnections&&w==null)
				{
					invalidProxies++;
					toRemove.add(p);
					continue;
				}
				if (validateConnections&&!(w.func_175625_s(p) instanceof IImmersiveConnectable))
				{
					invalidProxies++;
					toRemove.add(p);
				}
			}
			if (invalidProxies>0)
				IELogger.info("Removed "+invalidProxies+" invalid connector proxies (used to transfer power through unloaded chunks)");
			validateConnsNextTick = false;
		}
		if (event.phase==TickEvent.Phase.END && ArcRecyclingThreadHandler.recipesToAdd!=null)
		{
			for(ArcFurnaceRecipe recipe : ArcRecyclingThreadHandler.recipesToAdd)
			{
				ArcFurnaceRecipe.recipeList.add(recipe);
				IECompatModule.jeiAddFunc.accept(recipe);
			}
			ArcRecyclingThreadHandler.recipesToAdd = null;
		}
		if(event.phase==TickEvent.Phase.END && FMLCommonHandler.instance().getEffectiveSide()==Side.SERVER)
		{
			int dim = event.world.field_73011_w.getDimension();
			for(Entry<Connection, Integer> e : ImmersiveNetHandler.INSTANCE.getTransferedRates(dim).entrySet())
				if(e.getValue()>e.getKey().cableType.getTransferRate())
				{
					if(event.world instanceof WorldServer)
						for(Vec3d vec : e.getKey().getSubVertices(event.world))
							((WorldServer)event.world).func_180505_a(EnumParticleTypes.FLAME, false, vec.field_72450_a,vec.field_72448_b,vec.field_72449_c, 0, 0,.02,0, 1, new int[0]);
					ImmersiveNetHandler.INSTANCE.removeConnection(event.world, e.getKey());
				}
			ImmersiveNetHandler.INSTANCE.getTransferedRates(dim).clear();

			if (!REMOVE_FROM_TICKING.isEmpty())
			{
				event.world.field_175730_i.removeAll(REMOVE_FROM_TICKING);
				REMOVE_FROM_TICKING.removeIf((te) -> te.func_145831_w().field_73011_w.getDimension() == dim);
			}
		}
		if(event.phase==TickEvent.Phase.START)
		{
			if(!currentExplosions.isEmpty())
			{
				Iterator<IEExplosion> itExplosion = currentExplosions.iterator();
				while(itExplosion.hasNext())
				{
					IEExplosion ex = itExplosion.next();
					ex.doExplosionTick();
					if(ex.isExplosionFinished)
						itExplosion.remove();
				}
			}
			synchronized (requestedBlockUpdates)
			{
				while (!requestedBlockUpdates.isEmpty())
				{
					Pair<Integer, BlockPos> curr = requestedBlockUpdates.poll();
					if(FMLCommonHandler.instance().getEffectiveSide()==Side.SERVER)
					{
						World w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(curr.getLeft());
						if(w!=null)
						{
							IBlockState state = w.func_180495_p(curr.getRight());
							w.func_184138_a(curr.getRight(), state,state, 3);
						}
					}
				}
			}
		}
	}

	@SubscribeEvent(priority = EventPriority.HIGH)
	public void onLogin(PlayerLoggedInEvent event)
	{
		ExcavatorHandler.allowPackets = true;
		if(!event.player.field_70170_p.field_72995_K)
		{
			HashMap<MineralMix,Integer> packetMap = new HashMap<MineralMix,Integer>();
			for(Entry<MineralMix,Integer> e: ExcavatorHandler.mineralList.entrySet())
				if(e.getKey()!=null && e.getValue()!=null)
					packetMap.put(e.getKey(), e.getValue());
			ImmersiveEngineering.packetHandler.sendToAll(new MessageMineralListSync(packetMap));
		}
	}
	@SubscribeEvent(priority = EventPriority.HIGH)
	public void onLogout(PlayerLoggedOutEvent event)
	{
		ExcavatorHandler.allowPackets = false;
	}

	@SubscribeEvent
	public void harvestCheck(PlayerEvent.HarvestCheck event)
	{
		if(event.getTargetBlock().func_177230_c() instanceof BlockIEBase)
		{
			if(!event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_190926_b()&&event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b().getToolClasses(event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND)).contains(Lib.TOOL_HAMMER))
			{
				RayTraceResult mop = Utils.getMovingObjectPositionFromPlayer(event.getEntityPlayer().field_70170_p, event.getEntityPlayer(), true);
				if(mop!=null&&mop.field_72313_a==RayTraceResult.Type.BLOCK)
					if(((BlockIEBase)event.getTargetBlock().func_177230_c()).allowHammerHarvest(event.getTargetBlock()))
						event.setCanHarvest(true);
			}
			if(!event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_190926_b()&&event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b().getToolClasses(event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND)).contains(Lib.TOOL_WIRECUTTER))
			{
				RayTraceResult mop = Utils.getMovingObjectPositionFromPlayer(event.getEntityPlayer().field_70170_p, event.getEntityPlayer(), true);
				if(mop!=null&&mop.field_72313_a==RayTraceResult.Type.BLOCK)
					if(((BlockIEBase)event.getTargetBlock().func_177230_c()).allowWirecutterHarvest(event.getTargetBlock()))
						event.setCanHarvest(true);
			}
		}
	}
	//	@SubscribeEvent
	//	public void bloodMagicTeleposer(TeleposeEvent event)
	//	{
	//		TileEntity tI = event.initialWorld.getTileEntity(event.initialX, event.initialY, event.initialZ);
	//		TileEntity tF = event.finalWorld.getTileEntity(event.finalX, event.finalY, event.finalZ);
	//		if(tI instanceof TileEntityImmersiveConnectable || tF instanceof TileEntityImmersiveConnectable)
	//			event.setCanceled(true);
	//		if(tI instanceof TileEntityMultiblockPart || tF instanceof TileEntityMultiblockPart)
	//			event.setCanceled(true);
	//	}

	public static HashMap<UUID, TileEntityCrusher> crusherMap = new HashMap<UUID, TileEntityCrusher>();
	public static HashSet<Class<? extends EntityLiving>> listOfBoringBosses = new HashSet();
	static{
		listOfBoringBosses.add(EntityWither.class);
	}
	@SubscribeEvent(priority=EventPriority.LOWEST)
	public void onLivingDropsLowest(LivingDropsEvent event)
	{
		if(!event.isCanceled() && Lib.DMG_Crusher.equals(event.getSource().func_76355_l()))
		{
			TileEntityCrusher crusher = crusherMap.get(event.getEntityLiving().func_110124_au());
			if(crusher!=null)
			{
				for(EntityItem item: event.getDrops())
					if(item!=null && !item.func_92059_d().func_190926_b())
						crusher.doProcessOutput(item.func_92059_d());
				crusherMap.remove(event.getEntityLiving().func_110124_au());
				event.setCanceled(true);
			}
		}
	}
	@SubscribeEvent
	public void onLivingDrops(LivingDropsEvent event)
	{
		if(!event.isCanceled() && !event.getEntityLiving().func_184222_aU())
		{
			EnumRarity r = EnumRarity.EPIC;
			for(Class<? extends EntityLiving> boring : listOfBoringBosses)
				if(boring.isAssignableFrom(event.getEntityLiving().getClass()))
					return;
			ItemStack bag = new ItemStack(IEContent.itemShaderBag);
			ItemNBTHelper.setString(bag, "rarity", r.toString());
			event.getDrops().add(new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, bag));
		}
	}

	@SubscribeEvent
	public void onLivingAttacked(LivingAttackEvent event)
	{
		if(event.getEntityLiving() instanceof EntityPlayer)
		{
			EntityPlayer player = (EntityPlayer) event.getEntityLiving();
			ItemStack activeStack = player.func_184607_cu();
			if(!activeStack.func_190926_b() && activeStack.func_77973_b() instanceof ItemIEShield && event.getAmount()>=3 && Utils.canBlockDamageSource(player, event.getSource()))
			{
				float amount = event.getAmount();
				((ItemIEShield)activeStack.func_77973_b()).hitShield(activeStack, player, event.getSource(), amount, event);
			}
		}
	}


	@SubscribeEvent(priority=EventPriority.LOWEST)
	public void onLivingHurt(LivingHurtEvent event)
	{
		if(event.getSource().func_76347_k() && event.getEntityLiving().func_70660_b(IEPotions.flammable)!=null)
		{
			int amp = event.getEntityLiving().func_70660_b(IEPotions.flammable).func_76458_c();
			float mod = 1.5f + ((amp*amp)*.5f);
			event.setAmount(event.getAmount()*mod);
		}
		if(("flux".equals(event.getSource().func_76355_l())||IEDamageSources.razorShock.equals(event.getSource())||event.getSource() instanceof TeslaDamageSource) && event.getEntityLiving().func_70660_b(IEPotions.conductive)!=null)
		{
			int amp = event.getEntityLiving().func_70660_b(IEPotions.conductive).func_76458_c();
			float mod = 1.5f + ((amp*amp)*.5f);
			event.setAmount(event.getAmount()*mod);
		}
	}
	@SubscribeEvent
	public void onLivingJump(LivingJumpEvent event)
	{
		if(event.getEntityLiving().func_70660_b(IEPotions.sticky)!=null)
			event.getEntityLiving().field_70181_x -= (event.getEntityLiving().func_70660_b(IEPotions.sticky).func_76458_c()+1)*0.3F;
		else if(event.getEntityLiving().func_70660_b(IEPotions.concreteFeet)!=null)
		{
			event.getEntityLiving().field_70159_w = 0;
			event.getEntityLiving().field_70181_x = 0;
			event.getEntityLiving().field_70179_y = 0;
		}
	}
	@SubscribeEvent
	public void onLivingUpdate(LivingUpdateEvent event)
	{
		if(event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && ItemNBTHelper.hasKey(event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST), Lib.NBT_Powerpack))
		{
			ItemStack powerpack = ItemNBTHelper.getItemStack(event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST), Lib.NBT_Powerpack);
			if(!powerpack.func_190926_b())
				powerpack.func_77973_b().onArmorTick(event.getEntityLiving().func_130014_f_(), (EntityPlayer)event.getEntityLiving(), powerpack);
		}
	}


	@SubscribeEvent
	public void onEnderTeleport(EnderTeleportEvent event)
	{
		if(event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false))
		{
			synchronized (interdictionTiles) {
				Iterator<ISpawnInterdiction> it = interdictionTiles.iterator();
				while(it.hasNext())
				{
					ISpawnInterdiction interdictor = it.next();
					if(interdictor instanceof TileEntity)
					{
						if(((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w()==null)
							it.remove();
						else if( ((TileEntity)interdictor).func_145831_w().field_73011_w.getDimension()== event.getEntity().field_70170_p.field_73011_w.getDimension() && ((TileEntity)interdictor).func_145835_a(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v)<=interdictor.getInterdictionRangeSquared())
							event.setCanceled(true);
					}
					else if(interdictor instanceof Entity)
					{
						if(((Entity)interdictor).field_70128_L || ((Entity)interdictor).field_70170_p==null)
							it.remove();
						else if(((Entity)interdictor).field_70170_p.field_73011_w.getDimension()== event.getEntity().field_70170_p.field_73011_w.getDimension() && ((Entity)interdictor).func_70068_e(event.getEntity())<=interdictor.getInterdictionRangeSquared())
							event.setCanceled(true);
					}
				}
			}
		}
		if(event.getEntityLiving().func_70660_b(IEPotions.stunned)!=null)
			event.setCanceled(true);
	}
	@SubscribeEvent
	public void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event)
	{
		if(event.getResult() == Event.Result.ALLOW||event.getResult() == Event.Result.DENY)
			return;
		if(event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false))
		{
			synchronized (interdictionTiles) {
				Iterator<ISpawnInterdiction> it = interdictionTiles.iterator();
				while(it.hasNext())
				{
					ISpawnInterdiction interdictor = it.next();
					if(interdictor instanceof TileEntity)
					{
						if(((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w()==null)
							it.remove();
						else if( ((TileEntity)interdictor).func_145831_w().field_73011_w.getDimension()== event.getEntity().field_70170_p.field_73011_w.getDimension() && ((TileEntity)interdictor).func_145835_a(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v)<=interdictor.getInterdictionRangeSquared())
							event.setResult(Event.Result.DENY);
					}
					else if(interdictor instanceof Entity)
					{
						if(((Entity)interdictor).field_70128_L || ((Entity)interdictor).field_70170_p==null)
							it.remove();
						else if(((Entity)interdictor).field_70170_p.field_73011_w.getDimension()== event.getEntity().field_70170_p.field_73011_w.getDimension() && ((Entity)interdictor).func_70068_e(event.getEntity())<=interdictor.getInterdictionRangeSquared())
							event.setResult(Event.Result.DENY);
					}
				}
			}
		}
	}

	@SubscribeEvent()
	public void digSpeedEvent(PlayerEvent.BreakSpeed event)
	{
		ItemStack current = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
		//Stop the combustion drill from working underwater
		if(!current.func_190926_b() && current.func_77973_b().equals(IEContent.itemDrill) && current.func_77952_i()==0 && event.getEntityPlayer().func_70055_a(Material.field_151586_h))
			if( ((ItemDrill)IEContent.itemDrill).getUpgrades(current).func_74767_n("waterproof"))
				event.setNewSpeed(event.getOriginalSpeed()*5);
			else
				event.setCanceled(true);
		if(event.getState().func_177230_c()==IEContent.blockMetalDecoration2 && IEContent.blockMetalDecoration2.func_176201_c(event.getState())==BlockTypes_MetalDecoration2.RAZOR_WIRE.getMeta())
			if(!OreDictionary.itemMatches(new ItemStack(IEContent.itemTool,1,1), current, false))
				event.setCanceled(true);
		TileEntity te = event.getEntityPlayer().func_130014_f_().func_175625_s(event.getPos());
		if(te instanceof IEntityProof && !((IEntityProof)te).canEntityDestroy(event.getEntityPlayer()))
			event.setCanceled(true);
	}
	@SubscribeEvent
	public void onAnvilChange(AnvilUpdateEvent event)
	{
		if(!event.getLeft().func_190926_b() && event.getLeft().func_77973_b() instanceof IDrillHead && ((IDrillHead) event.getLeft().func_77973_b()).getHeadDamage(event.getLeft())>0)
		{
			if(!event.getRight().func_190926_b() && event.getLeft().func_77973_b().func_82789_a(event.getLeft(), event.getRight()))
			{
				event.setOutput(event.getLeft().func_77946_l());
				int repair = Math.min(
						((IDrillHead)event.getOutput().func_77973_b()).getHeadDamage(event.getOutput()),
						((IDrillHead) event.getOutput().func_77973_b()).getMaximumHeadDamage(event.getOutput())/4);
				int cost = 0;
				for(; repair>0&& cost < event.getRight().func_190916_E(); ++cost)
				{
					((IDrillHead) event.getOutput().func_77973_b()).damageHead(event.getOutput(), -repair);
					event.setCost(Math.max(1, repair/200));
					repair = Math.min(
							((IDrillHead) event.getOutput().func_77973_b()).getHeadDamage(event.getOutput()),
							((IDrillHead) event.getOutput().func_77973_b()).getMaximumHeadDamage(event.getOutput())/4);
				}
				event.setMaterialCost(cost);

				if(event.getName()==null || event.getName().isEmpty())
				{
					if(event.getLeft().func_82837_s())
					{
						event.setCost(event.getCost()+5);
						event.getOutput().func_135074_t();
					}
				}
				else if (!event.getName().equals(event.getLeft().func_82833_r()))
				{
					event.setCost(event.getCost()+5);
					if(event.getLeft().func_82837_s())
						event.setCost(event.getCost()+2);
					event.getOutput().func_151001_c(event.getName());
				}
			}
		}
	}
	@SubscribeEvent(priority = EventPriority.LOWEST)
	public void breakLast(BlockEvent.BreakEvent event) {
		if (event.getState().func_177230_c() instanceof BlockIEMultiblock) {
			TileEntity te = event.getWorld().func_175625_s(event.getPos());
			if (te instanceof TileEntityMultiblockPart) {
				((TileEntityMultiblockPart) te).onlyLocalDissassembly = event.getWorld().func_82737_E();
			}
		}
	}

	@SubscribeEvent
	public void remap(RegistryEvent.MissingMappings<?> ev)
	{
		NameRemapper.remap(ev);
	}
}
