/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.IGuiTile;
import blusunrize.immersiveengineering.common.blocks.metal.*;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityAlloySmelter;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnace;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityCokeOven;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityFluidSorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntitySorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenCrate;
import blusunrize.immersiveengineering.common.gui.*;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces.IGuiItem;
import blusunrize.immersiveengineering.common.items.ItemToolbox;
import com.mojang.authlib.GameProfile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.IGuiHandler;

import javax.annotation.Nonnull;
import java.util.UUID;

public class CommonProxy implements IGuiHandler
{
	public void preInit(){}

	public void preInitEnd()
	{
	}
	public void init(){}

	public void initEnd()
	{
	}
	public void postInit(){}

	public void postInitEnd()
	{
	}
	public void serverStarting(){}
	public void onWorldLoad(){}

	public static <T extends TileEntity & IGuiTile> void openGuiForTile(@Nonnull EntityPlayer player, @Nonnull T tile)
	{
		player.openGui(ImmersiveEngineering.instance, tile.getGuiID(), tile.func_145831_w(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p());
	}

	public static void openGuiForItem(@Nonnull EntityPlayer player, @Nonnull EntityEquipmentSlot slot)
	{
		ItemStack stack = player.func_184582_a(slot);
		if(stack.func_190926_b() || !(stack.func_77973_b() instanceof IGuiItem))
			return;
		IGuiItem gui = (IGuiItem)stack.func_77973_b();
		player.openGui(ImmersiveEngineering.instance, 100*slot.ordinal() + gui.getGuiID(stack), player.field_70170_p, (int)player.field_70165_t,(int)player.field_70163_u,(int)player.field_70161_v);
	}

	@Override
	public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
	{
		if(ID>=Lib.GUIID_Base_Item)
		{
			EntityEquipmentSlot slot = EntityEquipmentSlot.values()[ID/100];
			ID %= 100;//Slot determined, get actual ID
			ItemStack item = player.func_184582_a(slot);
			if(!item.func_190926_b() && item.func_77973_b() instanceof IGuiItem && ((IGuiItem)item.func_77973_b()).getGuiID(item)==ID)
			{
				if(ID == Lib.GUIID_Revolver && item.func_77973_b() instanceof IEItemInterfaces.IBulletContainer)
					return new ContainerRevolver(player.field_71071_by, world, slot, item);
				if(ID == Lib.GUIID_Toolbox && item.func_77973_b() instanceof ItemToolbox)
					return new ContainerToolbox(player.field_71071_by, world, slot, item);
			}
		}
		else
		{
			TileEntity te = world.func_175625_s(new BlockPos(x,y,z));
			if(te instanceof IGuiTile)
			{
				Object gui = null;
				if(ID==Lib.GUIID_CokeOven && te instanceof TileEntityCokeOven)
					gui = new ContainerCokeOven(player.field_71071_by, (TileEntityCokeOven) te);
				if(ID==Lib.GUIID_AlloySmelter && te instanceof TileEntityAlloySmelter)
					gui = new ContainerAlloySmelter(player.field_71071_by, (TileEntityAlloySmelter) te);
				if(ID==Lib.GUIID_BlastFurnace && te instanceof TileEntityBlastFurnace)
					gui = new ContainerBlastFurnace(player.field_71071_by, (TileEntityBlastFurnace) te);
				if(ID==Lib.GUIID_WoodenCrate && te instanceof TileEntityWoodenCrate)
					gui = new ContainerCrate(player.field_71071_by, (TileEntityWoodenCrate) te);
				if(ID==Lib.GUIID_Workbench && te instanceof TileEntityModWorkbench)
					gui = new ContainerModWorkbench(player.field_71071_by, (TileEntityModWorkbench) te);
				if(ID==Lib.GUIID_Sorter && te instanceof TileEntitySorter)
					gui = new ContainerSorter(player.field_71071_by, (TileEntitySorter) te);
				if(ID==Lib.GUIID_Squeezer && te instanceof TileEntitySqueezer)
					gui = new ContainerSqueezer(player.field_71071_by, (TileEntitySqueezer) te);
				if(ID==Lib.GUIID_Fermenter && te instanceof TileEntityFermenter)
					gui = new ContainerFermenter(player.field_71071_by, (TileEntityFermenter) te);
				if(ID==Lib.GUIID_Refinery && te instanceof TileEntityRefinery)
					gui = new ContainerRefinery(player.field_71071_by, (TileEntityRefinery) te);
				if(ID==Lib.GUIID_ArcFurnace && te instanceof TileEntityArcFurnace)
					gui = new ContainerArcFurnace(player.field_71071_by, (TileEntityArcFurnace) te);
				if(ID==Lib.GUIID_Assembler && te instanceof TileEntityAssembler)
					gui = new ContainerAssembler(player.field_71071_by, (TileEntityAssembler) te);
				if(ID==Lib.GUIID_AutoWorkbench && te instanceof TileEntityAutoWorkbench)
					gui = new ContainerAutoWorkbench(player.field_71071_by, (TileEntityAutoWorkbench) te);
				if(ID==Lib.GUIID_Mixer && te instanceof TileEntityMixer)
					gui = new ContainerMixer(player.field_71071_by, (TileEntityMixer) te);
				if(ID==Lib.GUIID_Turret && te instanceof TileEntityTurret)
					gui = new ContainerTurret(player.field_71071_by, (TileEntityTurret) te);
				if(ID==Lib.GUIID_FluidSorter && te instanceof TileEntityFluidSorter)
					gui = new ContainerFluidSorter(player.field_71071_by, (TileEntityFluidSorter) te);
				if(ID==Lib.GUIID_Belljar && te instanceof TileEntityBelljar)
					gui = new ContainerBelljar(player.field_71071_by, (TileEntityBelljar) te);
				if(ID==Lib.GUIID_ToolboxBlock && te instanceof TileEntityToolbox)
					gui = new ContainerToolboxBlock(player.field_71071_by, (TileEntityToolbox) te);
				if(gui!=null)
					((IGuiTile)te).onGuiOpened(player, false);
				return gui;
			}
		}
		return null;
	}

	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
	{
		return null;
	}

	public void handleTileSound(SoundEvent soundEvent, TileEntity tile, boolean tileActive, float volume, float pitch)
	{
	}
	public void stopTileSound(String soundName, TileEntity tile)
	{
	}
	public void spawnBucketWheelFX(TileEntityBucketWheel tile, ItemStack stack)
	{
	}
	public void spawnSparkFX(World world, double x, double y, double z, double mx, double my, double mz)
	{
	}
	public void spawnRedstoneFX(World world, double x, double y, double z, double mx, double my, double mz, float size, float r, float g, float b)
	{
	}
	public void spawnFluidSplashFX(World world, FluidStack fs, double x, double y, double z, double mx, double my, double mz)
	{
	}
	public void spawnBubbleFX(World world, FluidStack fs, double x, double y, double z, double mx, double my, double mz)
	{
	}
	public void draw3DBlockCauldron()
	{
	}
	public void drawSpecificFluidPipe(String configuration)
	{
	}
	public boolean armorHasCustomModel(ItemStack stack)
	{
		return false;
	}

	public boolean drawConveyorInGui(String conveyor, EnumFacing facing)
	{
		return false;
	}

	public void drawFluidPumpTop()
	{
	}

	public String[] splitStringOnWidth(String s, int w)
	{
		return new String[]{s};
	}
	public World getClientWorld()
	{
		return null;
	}
	public EntityPlayer getClientPlayer()
	{
		return null;
	}
	public String getNameFromUUID(String uuid)
	{
		return FMLCommonHandler.instance().getMinecraftServerInstance().func_147130_as().fillProfileProperties(new GameProfile(UUID.fromString(uuid.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")), null), false).getName();
	}
	public void reInitGui()
	{
	}

	public void removeStateFromSmartModelCache(IExtendedBlockState state)
	{
	}
	public void removeStateFromConnectionModelCache(IExtendedBlockState state)
	{
	}
	public void clearConnectionModelCache()
	{
	}
	public void clearRenderCaches()
	{
	}
}
