/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmill;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.obj.OBJModel.OBJState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class TileRenderWindmill extends TileEntitySpecialRenderer<TileEntityWindmill>
{
	private static List<BakedQuad>[] quads = new List[9];
	@Override
	public void func_192841_a(TileEntityWindmill tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(!tile.func_145831_w().func_175668_a(tile.func_174877_v(), false))
			return;
		final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
		BlockPos blockPos = tile.func_174877_v();
		if(quads[tile.sails]==null)
		{
			IBlockState state = func_178459_a().func_180495_p(blockPos);
			if(state.func_177230_c() != IEContent.blockWoodenDevice1)
				return;
			state = state.func_185899_b(func_178459_a(), blockPos);
			state = state.func_177226_a(IEProperties.FACING_ALL, EnumFacing.NORTH);
			IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
			if(state instanceof IExtendedBlockState)
			{
				List<String> parts = new ArrayList<>();
				parts.add("base");
				for(int i=1; i<=tile.sails; i++)
					parts.add("sail_"+i);
				state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, new OBJState(parts, true));
			}
			quads[tile.sails] = model.func_188616_a(state, null, 0);
		}
		Tessellator tessellator = Tessellator.func_178181_a();
		GlStateManager.func_179112_b(770, 771);
		GlStateManager.func_179147_l();
		GlStateManager.func_179129_p();
		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(x + .5, y + .5, z + .5);

		float dir = tile.facing == EnumFacing.SOUTH ? 0 : tile.facing == EnumFacing.NORTH ? 180 : tile.facing == EnumFacing.EAST ? 90 : -90;
		float rot = 360 * (tile.rotation + (!tile.canTurn || tile.rotation == 0 ? 0 : partialTicks)*tile.perTick);

		GlStateManager.func_179114_b(rot, tile.facing.func_176740_k() == Axis.X ? 1 : 0, 0, tile.facing.func_176740_k() == Axis.Z ? 1 : 0);
		GlStateManager.func_179114_b(dir, 0, 1, 0);

		RenderHelper.func_74518_a();
		Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
		BufferBuilder worldRenderer = tessellator.func_178180_c();
		worldRenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
		worldRenderer.func_178969_c(-.5, -.5, -.5);
		ClientUtils.renderModelTESRFast(quads[tile.sails], worldRenderer, tile.func_145831_w(), blockPos);
		worldRenderer.func_178969_c(0, 0, 0);
		tessellator.func_78381_a();
		GlStateManager.func_179121_F();
		RenderHelper.func_74519_b();
		GlStateManager.func_179084_k();
		GlStateManager.func_179089_o();
	}
	public static void reset()
	{
		for(int i=0; i<quads.length; i++)
			quads[i] = null;
	}
}
