/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWatermill;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import org.lwjgl.opengl.GL11;

import java.util.List;

public class TileRenderWatermill extends TileEntitySpecialRenderer<TileEntityWatermill>
{
	private static List<BakedQuad> quads;
	@Override
	public void func_192841_a(TileEntityWatermill tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if (tile.isDummy()||!tile.func_145831_w().func_175668_a(tile.func_174877_v(), false))
			return;
		if (quads==null)
		{
			final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
			IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
			if(state.func_177230_c() != IEContent.blockWoodenDevice1)
				return;
			state = state.func_177226_a(IEProperties.FACING_ALL, EnumFacing.NORTH);
			quads = blockRenderer.func_184389_a(state).func_188616_a(state, null, 0);
		}
		Tessellator tessellator = Tessellator.func_178181_a();
		GlStateManager.func_179094_E();

		GlStateManager.func_179137_b(x + .5, y + .5, z + .5);
		GlStateManager.func_179112_b(770, 771);
		GlStateManager.func_179147_l();
		GlStateManager.func_179129_p();
		final float dir = (tile.facing.func_185119_l()+180)%180;
		float wheelRotation = 360 * (tile.rotation + (!tile.canTurn || tile.rotation == 0 ? 0 : partialTicks)*(float)tile.perTick);
		GlStateManager.func_179114_b(dir, 0, 1, 0);
		GlStateManager.func_179114_b(wheelRotation, 0, 0, 1);
		RenderHelper.func_74518_a();
		Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
		BufferBuilder worldRenderer = tessellator.func_178180_c();
		worldRenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
		worldRenderer.func_178969_c(-.5, -.5, -.5);
		ClientUtils.renderModelTESRFast(quads, worldRenderer, tile.func_145831_w(), tile.func_174877_v());
		worldRenderer.func_178969_c(0, 0, 0);
		tessellator.func_78381_a();
		GlStateManager.func_179121_F();
		RenderHelper.func_74519_b();
		GlStateManager.func_179084_k();
		GlStateManager.func_179089_o();
	}
	public static void reset()
	{
		quads = null;
	}
}
