/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurret;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurretGun;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel.OBJState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import org.lwjgl.opengl.GL11;

import java.util.Arrays;
import java.util.List;

public class TileRenderTurret extends TileEntitySpecialRenderer<TileEntityTurret>
{
	@Override
	public void func_192841_a(TileEntityTurret tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(tile.isDummy()||!tile.func_145831_w().func_175668_a(tile.func_174877_v(), false))
			return;

		//Grab model + correct eextended state
		final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
		BlockPos blockPos = tile.func_174877_v();
		IBlockState state = func_178459_a().func_180495_p(blockPos);
		if(state.func_177230_c() != IEContent.blockMetalDevice1)
			return;
		state = state.func_177230_c().func_176221_a(state, func_178459_a(), blockPos);
		IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);

		//Initialize Tesselator and BufferBuilder
		Tessellator tessellator = Tessellator.func_178181_a();
		BufferBuilder worldRenderer = tessellator.func_178180_c();
		//Outer GL Wrapping, initial translation
		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(x+.5, y+.5, z+.5);

		GlStateManager.func_179114_b(tile.rotationYaw, 0,1,0);
		GlStateManager.func_179114_b(tile.rotationPitch, tile.facing.func_82599_e(),0,-tile.facing.func_82601_c());

		renderModelPart(blockRenderer, tessellator, worldRenderer, tile.func_145831_w(), state, model, tile.func_174877_v(), true, "gun");
		if(tile instanceof TileEntityTurretGun)
		{
			if(((TileEntityTurretGun)tile).cycleRender>0)
			{
				float cycle = 0;
				if(((TileEntityTurretGun)tile).cycleRender>3)
					cycle = (5-((TileEntityTurretGun)tile).cycleRender)/2f;
				else
					cycle = ((TileEntityTurretGun)tile).cycleRender/3f;

				GlStateManager.func_179137_b(-tile.facing.func_82601_c()*cycle*.3125, 0, -tile.facing.func_82599_e()*cycle*.3125);
			}
			renderModelPart(blockRenderer, tessellator, worldRenderer, tile.func_145831_w(), state, model, tile.func_174877_v(), false, "action");
		}

		GlStateManager.func_179121_F();
	}

	public static void renderModelPart(final BlockRendererDispatcher blockRenderer, Tessellator tessellator, BufferBuilder worldRenderer, World world, IBlockState state, IBakedModel model, BlockPos pos, boolean isFirst, String... parts)
	{
		pos = pos.func_177984_a();
		if(state instanceof IExtendedBlockState)
			state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, new OBJState(Arrays.asList(parts), true));

		RenderHelper.func_74518_a();
		GlStateManager.func_179112_b(770, 771);
		GlStateManager.func_179147_l();
		GlStateManager.func_179129_p();
		Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
		if(Minecraft.func_71379_u())
			GlStateManager.func_179103_j(7425);
		else
			GlStateManager.func_179103_j(7424);
		worldRenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
		worldRenderer.func_178969_c(-.5, 0, -.5);
		long randomLong = MathHelper.func_180186_a(pos);
		int light = world.func_175626_b(pos, 0);
		List<BakedQuad> quads = model.func_188616_a(state, null, randomLong);
		ClientUtils.renderModelTESRFancy(quads, worldRenderer, world, pos, !isFirst);
		worldRenderer.func_178969_c(0.0D, 0.0D, 0.0D);
		tessellator.func_78381_a();
		RenderHelper.func_74519_b();
		GlStateManager.func_179084_k();
		GlStateManager.func_179089_o();
	}

}
