/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTeslaCoil;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTeslaCoil.LightningAnimation;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

import java.util.Iterator;
import java.util.List;

public class TileRenderTeslaCoil extends TileEntitySpecialRenderer<TileEntityTeslaCoil>
{
	@Override
	public void func_192841_a(TileEntityTeslaCoil tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(tile.isDummy()||!tile.func_145831_w().func_175668_a(tile.func_174877_v(), false))
			return;
		Iterator<LightningAnimation> animationIt = TileEntityTeslaCoil.effectMap.get(tile.func_174877_v()).iterator();

		func_190053_a(true);
		GL11.glPushAttrib(GL11.GL_LIGHTING);
		GlStateManager.func_179140_f();
		GlStateManager.func_179112_b(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		while(animationIt.hasNext())
		{
			LightningAnimation animation = animationIt.next();
			if(animation.shoudlRecalculateLightning())
				animation.createLightning(Utils.RAND);

			GlStateManager.func_179094_E();
			GlStateManager.func_179137_b(x, y, z);

			GlStateManager.func_179090_x();
			GlStateManager.func_179147_l();


			double tx = tile.func_174877_v().func_177958_n();
			double ty = tile.func_174877_v().func_177956_o();
			double tz = tile.func_174877_v().func_177952_p();
			float curWidth = GL11.glGetFloat(GL11.GL_LINE_WIDTH);
			drawAnimation(animation, tx,ty,tz, new float[]{77/255f,74/255f,152/255f, .75f}, 4f);
			drawAnimation(animation, tx,ty,tz, new float[]{1,1,1,1}, 1f);
			GL11.glLineWidth(curWidth);
			
			GlStateManager.func_179098_w();
			GlStateManager.func_179084_k();

			GlStateManager.func_179121_F();
		}
		GL11.glPopAttrib();
		func_190053_a(false);
	}
	
	public static void drawAnimation(LightningAnimation animation, double tileX, double tileY, double tileZ, float[] rgba, float lineWidth)
	{
		GlStateManager.func_179131_c(rgba[0],rgba[1],rgba[2],rgba[3]);
		GL11.glLineWidth(lineWidth);
		Tessellator tes = ClientUtils.tes();
		BufferBuilder worldrenderer = tes.func_178180_c();
		worldrenderer.func_181668_a(GL11.GL_LINE_STRIP, DefaultVertexFormats.field_181705_e);
		List<Vec3d> subs = animation.subPoints;
		worldrenderer.func_181662_b(animation.startPos.field_72450_a-tileX,animation.startPos.field_72448_b-tileY,animation.startPos.field_72449_c-tileZ).func_181675_d();
		
		for(int i=0; i<subs.size(); i++)
			worldrenderer.func_181662_b(subs.get(i).field_72450_a-tileX,subs.get(i).field_72448_b-tileY,subs.get(i).field_72449_c-tileZ).func_181675_d();

		Vec3d end = (animation.targetEntity!=null?animation.targetEntity.func_174791_d():animation.targetPos).func_72441_c(-tileX,-tileY,-tileZ);
		worldrenderer.func_181662_b(end.field_72450_a,end.field_72448_b,end.field_72449_c).func_181675_d();

		tes.func_78381_a();
	}
}
