/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySilo;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;

public class TileRenderSilo extends TileEntitySpecialRenderer<TileEntitySilo>
{
	@Override
	public void func_192841_a(TileEntitySilo tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(!tile.formed || tile.pos!=4||!tile.func_145831_w().func_175668_a(tile.func_174877_v(), false))
			return;
		GlStateManager.func_179094_E();

		GlStateManager.func_179137_b(x+.5, y, z+.5);

		if(!tile.identStack.func_190926_b())
		{
			GlStateManager.func_179109_b(0,5,0);
			float baseScale = .0625f;
			float itemScale = .75f;
			float flatScale = .001f;
			baseScale *= itemScale;
			float textScale = .375f;
			GlStateManager.func_179152_a(baseScale,-baseScale,baseScale);
			ItemStack stack = Utils.copyStackWithAmount(tile.identStack, tile.storageAmount);
			String s = "" + stack.func_190916_E();
			float w = this.func_147498_b().func_78256_a(s);

			float xx = -.5f*itemScale;
			float zz = 1.501f;
			xx/=baseScale;
			zz/=baseScale;
			w*=textScale;
			for(int i=0; i<4; i++)
			{
				GlStateManager.func_179094_E();
				GlStateManager.func_179109_b(xx,0,zz);
				GlStateManager.func_179152_a(1,1,flatScale);
				ClientUtils.mc().func_175599_af().func_180450_b(stack, 0, 0);
				GlStateManager.func_179152_a(1,1,1/flatScale);
				
				GlStateManager.func_179140_f();
				GlStateManager.func_179132_a(false);
				GlStateManager.func_179109_b(8-w/2,17,.001f);
				GlStateManager.func_179152_a(textScale,textScale,1);
				ClientUtils.font().func_175065_a("" + stack.func_190916_E(), 0,0,0x888888, true);
				GlStateManager.func_179152_a(1/textScale,1/textScale,1);
				GlStateManager.func_179109_b(-(8-w/2),-17,-.001f);
				GlStateManager.func_179132_a(true);
				GlStateManager.func_179145_e();

				GlStateManager.func_179109_b(-xx,0,-zz);
				GlStateManager.func_179121_F();
				GlStateManager.func_179114_b(90, 0,1,0);

				GlStateManager.func_179141_d();
				GlStateManager.func_179092_a(516, 0.1F);
				GlStateManager.func_179147_l();
				OpenGlHelper.func_148821_a(770, 771, 1, 0);
			}
		}
		GlStateManager.func_179121_F();
	}

}
