/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySheetmetalTank;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TileRenderSheetmetalTank extends TileEntitySpecialRenderer<TileEntitySheetmetalTank>
{
	@Override
	public void func_192841_a(TileEntitySheetmetalTank tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(!tile.formed || tile.pos!=4||!tile.func_145831_w().func_175668_a(tile.func_174877_v(), false))
			return;
		GlStateManager.func_179094_E();

		GlStateManager.func_179137_b(x+.5, y, z+.5);

		FluidStack fs = tile.tank.getFluid();
		GlStateManager.func_179109_b(0,3.5f,0);
		float baseScale = .0625f;
		GlStateManager.func_179152_a(baseScale,-baseScale,baseScale);

		float xx = -.5f;
		float zz = 1.5f-.004f;
		xx/=baseScale;
		zz/=baseScale;
		for(int i=0; i<4; i++)
		{
			GlStateManager.func_179109_b(xx,0,zz);

			GlStateManager.func_179090_x();
			GlStateManager.func_179147_l();
			GlStateManager.func_179118_c();
			OpenGlHelper.func_148821_a(770, 771, 1, 0);
			GlStateManager.func_179103_j(GL11.GL_SMOOTH);
			GlStateManager.func_179140_f();
			
			BufferBuilder worldrenderer = ClientUtils.tes().func_178180_c();
			worldrenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181706_f);
			worldrenderer.func_181662_b(-4, -4, 0).func_181669_b(0x22,0x22,0x22,0xff).func_181675_d();
			worldrenderer.func_181662_b(-4, 20, 0).func_181669_b(0x22,0x22,0x22,0xff).func_181675_d();
			worldrenderer.func_181662_b(20, 20, 0).func_181669_b(0x22,0x22,0x22,0xff).func_181675_d();
			worldrenderer.func_181662_b(20, -4, 0).func_181669_b(0x22,0x22,0x22,0xff).func_181675_d();
			ClientUtils.tes().func_78381_a();
			GlStateManager.func_179103_j(GL11.GL_FLAT);
			GlStateManager.func_179084_k();
			GlStateManager.func_179141_d();
			GlStateManager.func_179098_w();

			if(fs!=null)
			{
				float h = fs.amount/(float)tile.tank.getCapacity();
				GlStateManager.func_179132_a(false);
				GlStateManager.func_179109_b(0,0,.004f);
				ClientUtils.drawRepeatedFluidSprite(fs, 0,0+(1-h)*16, 16,h*16);
				GlStateManager.func_179109_b(0,0,-.004f);
				GlStateManager.func_179132_a(true);
			}

			GlStateManager.func_179109_b(-xx,0,-zz);
			GlStateManager.func_179114_b(90, 0,1,0);
			GlStateManager.func_179141_d();
			GlStateManager.func_179092_a(516, 0.1F);
			GlStateManager.func_179147_l();
			OpenGlHelper.func_148821_a(770, 771, 1, 0);
		}
		GlStateManager.func_179121_F();
	}

}
