/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySampleDrill;
import com.google.common.collect.Lists;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.obj.OBJModel.OBJState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import org.lwjgl.opengl.GL11;

public class TileRenderSampleDrill extends TileEntitySpecialRenderer<TileEntitySampleDrill>
{
	@Override
	public void func_192841_a(TileEntitySampleDrill tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(tile.isDummy()||!tile.func_145831_w().func_175668_a(tile.func_174877_v(), false))
			return;

		final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
		IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
		BlockPos blockPos = tile.func_174877_v();
		IBakedModel model = blockRenderer.func_184389_a(state);
		if(state.func_177230_c() != IEContent.blockMetalDevice0)
			return;
//				.getModelFromBlockState(state, getWorld(), blockPos);
		if(state instanceof IExtendedBlockState)
			state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, new OBJState(Lists.newArrayList("drill"), true));

		Tessellator tessellator = Tessellator.func_178181_a();
		BufferBuilder worldRenderer = tessellator.func_178180_c();
		func_147499_a(TextureMap.field_110575_b);
		RenderHelper.func_74518_a();
		GlStateManager.func_179112_b(770, 771);
		GlStateManager.func_179147_l();
		GlStateManager.func_179129_p();
		if(Minecraft.func_71379_u())
			GlStateManager.func_179103_j(7425);
		else
			GlStateManager.func_179103_j(7424);
		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(x+.5, y+.5, z+.5);

		//		float rot = 360*tile.rotation-(!tile.canTurn||tile.rotation==0||tile.rotation-tile.prevRotation<4?0:tile.facing.getAxis()==Axis.X?-f:f);
		//		GlStateManager.rotate(rot, 0,0,1);

		int max = IEConfig.Machines.coredrill_time;
		if(tile.process>0 && tile.process<max)
		{
			GL11.glRotatef( ((tile.process+partialTicks)*22.5f)%360f, 0,1,0);
			float push = tile.process/(float)max;
			if(tile.process>max/2)
				push = 1-push;
			GL11.glTranslated(0,-2.8f*push,0);
		}

		worldRenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
		worldRenderer.func_178969_c( -.5-blockPos.func_177958_n(), -.5- blockPos.func_177956_o(),  -.5-blockPos.func_177952_p());
		worldRenderer.func_181669_b(255, 255, 255, 255);
		blockRenderer.func_175019_b().func_178267_a(tile.func_145831_w(), model, state, tile.func_174877_v(), worldRenderer, true);
		worldRenderer.func_178969_c(0.0D, 0.0D, 0.0D);
		tessellator.func_78381_a();
		GlStateManager.func_179121_F();
		RenderHelper.func_74519_b();
	}
}
