/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalPress;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal.MultiblockProcessInWorld;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

import java.util.List;

public class TileRenderMetalPress extends TileEntitySpecialRenderer<TileEntityMetalPress>
{
	@Override
	public void func_192841_a(TileEntityMetalPress te, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(!te.formed || te.isDummy() || !te.func_145831_w().func_175668_a(te.func_174877_v(), false))
			return;

		final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
		BlockPos blockPos = te.func_174877_v();
		IBlockState state = func_178459_a().func_180495_p(blockPos);
		if(state.func_177230_c() != IEContent.blockMetalMultiblock)
			return;
		state = state.func_177230_c().func_176221_a(state, func_178459_a(), blockPos);
		state = state.func_177226_a(IEProperties.DYNAMICRENDER, true);
		IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);

		Tessellator tessellator = Tessellator.func_178181_a();
		BufferBuilder worldRenderer = tessellator.func_178180_c();

		ClientUtils.bindAtlas();
		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(x+.5, y+.5, z+.5);
		float piston = 0;
		float shift[] = new float[te.processQueue.size()];
		for(int i=0; i<shift.length; i++)
		{
			MultiblockProcess process = te.processQueue.get(i);
			if(process==null)
				continue;
			float transportTime = 52.5f/(float)process.maxTicks;
			float pressTime = 3.75f/(float)process.maxTicks;
			float fProcess = (process.processTick+(te.shouldRenderAsActive()?partialTicks:0))/(float)process.maxTicks;

			if(fProcess<transportTime)
				shift[i] = fProcess/transportTime*.5f;
			else if(fProcess<(1-transportTime))
				shift[i] = .5f;
			else
				shift[i] = .5f+ (fProcess-(1-transportTime))/transportTime*.5f;
			if(!te.mold.func_190926_b())
				if(fProcess>=transportTime&&fProcess<(1-transportTime))
				{
					if(fProcess<(transportTime+pressTime))
						piston = (fProcess-transportTime)/pressTime;
					else if(fProcess<(1-transportTime-pressTime))
						piston = 1;
					else
						piston = 1 - (fProcess-(1-transportTime-pressTime))/pressTime;
				}
		}
		GlStateManager.func_179109_b(0,-piston*.6875f,0);

		RenderHelper.func_74518_a();
		GlStateManager.func_179112_b(770, 771);
		GlStateManager.func_179147_l();
		GlStateManager.func_179129_p();
		if(Minecraft.func_71379_u())
			GlStateManager.func_179103_j(7425);
		else
			GlStateManager.func_179103_j(7424);
		worldRenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
		worldRenderer.func_178969_c( -.5-blockPos.func_177958_n(), -.5- blockPos.func_177956_o(),  -.5-blockPos.func_177952_p());
		worldRenderer.func_181669_b(255, 255, 255, 255);
		blockRenderer.func_175019_b().func_178267_a(te.func_145831_w(), model, state, blockPos, worldRenderer, true);
		worldRenderer.func_178969_c(0.0D, 0.0D, 0.0D);
		tessellator.func_78381_a();
		RenderHelper.func_74519_b();

		GlStateManager.func_179114_b(te.facing==EnumFacing.SOUTH?180: te.facing==EnumFacing.WEST?90: te.facing==EnumFacing.EAST?-90: 0, 0,1,0);
		if(!te.mold.func_190926_b())
		{
			GlStateManager.func_179094_E();
			GlStateManager.func_179137_b(0,.34,0);
			GlStateManager.func_179114_b(-90, 1,0,0);
			float scale = .75f;
			GlStateManager.func_179152_a(scale,scale,1);
			ClientUtils.mc().func_175599_af().func_181564_a(te.mold, ItemCameraTransforms.TransformType.FIXED);
			GlStateManager.func_179152_a(1/scale,1/scale,1);
			GlStateManager.func_179121_F();
		}
		GlStateManager.func_179109_b(0,piston*.6875f,0);
		GlStateManager.func_179137_b(0,-.35,1.25);
		for(int i=0; i<shift.length; i++)
		{
			MultiblockProcess process = te.processQueue.get(i);
			if(process==null || !(process instanceof MultiblockProcessInWorld))
				continue;
			GlStateManager.func_179094_E();
			GlStateManager.func_179137_b(0,0,-2.5*shift[i]);
			if(piston>.92)
				GlStateManager.func_179137_b(0,.92-piston,0);

			List<ItemStack> displays = ((MultiblockProcessInWorld)process).getDisplayItem();
			if(!displays.isEmpty())
			{
				GlStateManager.func_179114_b(-90, 1, 0, 0);
				float scale = .625f;
				GlStateManager.func_179152_a(scale, scale, 1);
				ClientUtils.mc().func_175599_af().func_181564_a(displays.get(0), ItemCameraTransforms.TransformType.FIXED);
				GlStateManager.func_179121_F();
			}
		}
		GlStateManager.func_179121_F();
	}
}
