/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBucketWheel;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumFacing.Axis;
import net.minecraftforge.client.model.obj.OBJModel.OBJState;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@SuppressWarnings("deprecation")
public class TileRenderBucketWheel extends TileEntitySpecialRenderer<TileEntityBucketWheel>
{
	private static IBakedModel model = null;
	@Override
	public void func_192841_a(TileEntityBucketWheel tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(!tile.formed || !tile.func_145831_w().func_175668_a(tile.func_174877_v(), false) || tile.isDummy())
			return;
		final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
		IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
		if(state.func_177230_c() != IEContent.blockMetalMultiblock)
			return;
		if (model==null)
		{
			state = state.func_177226_a(IEProperties.DYNAMICRENDER, true);
			state = state.func_177226_a(IEProperties.FACING_HORIZONTAL, EnumFacing.NORTH);
			model = blockRenderer.func_184389_a(state);
		}
		OBJState objState = null;
		HashMap<String,String> texMap = new HashMap<>();
		if(state instanceof IExtendedBlockState)
		{
			ArrayList<String> list = Lists.newArrayList("bucketWheel");
			synchronized (tile.digStacks)
			{
				for(int i=0; i<tile.digStacks.size(); i++)
					if(!tile.digStacks.get(i).func_190926_b())
					{
						list.add("dig"+i);
						Block b = Block.func_149634_a(tile.digStacks.get(i).func_77973_b());
						IBlockState digState = b!=Blocks.field_150350_a?b.func_176203_a(tile.digStacks.get(i).func_77960_j()): Blocks.field_150347_e.func_176223_P();
						IBakedModel digModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(digState);
						if(digModel!=null && digModel.func_177554_e()!=null)
							texMap.put("dig"+i, digModel.func_177554_e().func_94215_i());
					}
			}
			objState = new OBJState(list, true);
		}

		Tessellator tessellator = Tessellator.func_178181_a();
		GlStateManager.func_179094_E();

		GlStateManager.func_179137_b(x + .5, y + .5, z + .5);
		GlStateManager.func_179112_b(770, 771);
		GlStateManager.func_179147_l();
		GlStateManager.func_179129_p();
		EnumFacing facing = tile.facing;
		if(tile.mirrored)
		{
			GlStateManager.func_179152_a(facing.func_176740_k()== Axis.X?-1:1,1,facing.func_176740_k()== Axis.Z?-1:1);
			GlStateManager.func_179129_p();
		}
		float dir = tile.facing == EnumFacing.SOUTH ? 90 : tile.facing == EnumFacing.NORTH ? -90 : tile.facing == EnumFacing.EAST ? 180 : 0;
		GlStateManager.func_179114_b(dir, 0, 1, 0);
		float rot = tile.rotation + (float)(tile.active ? IEConfig.Machines.excavator_speed * partialTicks : 0);
		GlStateManager.func_179114_b(rot, 1, 0, 0);

		RenderHelper.func_74518_a();
		Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
		BufferBuilder worldRenderer = tessellator.func_178180_c();
		worldRenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
		worldRenderer.func_178969_c(-.5, -.5, -.5);
		List<BakedQuad> quads;
		if (model instanceof IESmartObjModel)
			quads = ((IESmartObjModel) model).getQuads(state, null, 0, objState, texMap, true);
		else
			quads = model.func_188616_a(state, null, 0);
		ClientUtils.renderModelTESRFast(quads, worldRenderer, tile.func_145831_w(), tile.func_174877_v());
		worldRenderer.func_178969_c(0, 0, 0);
		tessellator.func_78381_a();
		GlStateManager.func_179121_F();
		RenderHelper.func_74519_b();
		GlStateManager.func_179084_k();
		GlStateManager.func_179089_o();
		if(tile.mirrored)
		{
			GlStateManager.func_179089_o();
		}
	}

	//	@Override
	//	public void renderTileEntityAt(TileEntity tile, double x, double y, double z, float f)
	//	{
	//		TileEntityBucketWheel wheel = (TileEntityBucketWheel)tile;
	//		if(!wheel.formed || wheel.pos!=24)
	//			return;
	//		GL11.glPushMatrix();
	//
	//		GL11.glTranslated(x+.5, y+.5, z+.5);
	//		GL11.glRotatef(wheel.facing==3?180: wheel.facing==5?-90: wheel.facing==4?90: 0, 0,1,0);
	//
	//		if(wheel.mirrored)
	//		{
	//			GL11.glScalef(1,1,-1);
	//			GL11.glDisable(GL11.GL_CULL_FACE);
	//		}
	//
	//		float rot =  wheel.rotation+(float)(wheel.active?Config.getDouble("excavator_speed")*f:0);
	//		GL11.glRotatef(rot, 0,0,-1);
	//		ClientUtils.bindTexture("immersiveengineering:textures/models/bucketWheel.png");
	//		model.renderOnly("bucketWheel");
	//
	//		for(int i=0; i<8; i++)
	//		{
	//			ItemStack stack = wheel.digStacks[i];
	//			//			String ss = ClientUtils.getResourceNameForItemStack(stack);
	//			//			if(!ss.isEmpty())
	//			if(stack==null || stack.getItem()==null)
	//				continue;
	//			IIcon ic = null;
	//			Block b = Block.getBlockFromItem(stack.getItem());
	//			if(b!=null&&b!=Blocks.air)
	//				ic = b.getIcon(2, stack.getItemDamage());
	//			else
	//				ic = stack.getIconIndex();
	//			if(ic!=null)
	//			{
	//				ClientUtils.bindAtlas(stack.getItemSpriteNumber());
	//				ClientUtils.tes().startDrawingQuads();
	//				for(GroupObject go : model.groupObjects)
	//				{
	//					if(go.name.equals("dig"+i))
	//					{
	//						for(Face face : go.faces)
	//						{
	//							float minU = ic.getMinU();
	//							float sizeU = ic.getMaxU() - minU;
	//							float minV = ic.getMinV();
	//							float sizeV = ic.getMaxV() - minV;
	//
	//							TextureCoordinate[] oldUVs = new TextureCoordinate[face.textureCoordinates.length];
	//							for(int v=0; v<face.vertices.length; ++v)
	//							{
	//								oldUVs[v] = face.textureCoordinates[v]; 
	//								TextureCoordinate textureCoordinate = face.textureCoordinates[v];
	//								face.textureCoordinates[v] = new TextureCoordinate(
	//										minU + sizeU * textureCoordinate.u,
	//										minV + sizeV * textureCoordinate.v
	//										);
	//							}
	//							face.addFaceForRender(ClientUtils.tes(),0);
	//							for(int v=0; v<face.vertices.length; ++v)
	//								face.textureCoordinates[v] = new TextureCoordinate(oldUVs[v].u,oldUVs[v].v);
	////							face.textureCoordinates = oldUVs;
	//						}
	////						go.render();
	//					}
	//				}
	//				ClientUtils.tes().draw();
	//			}
	//		}
	//
	//		if(wheel.mirrored)
	//		{
	//			GL11.glScalef(1,1,-1);
	//			GL11.glEnable(GL11.GL_CULL_FACE);
	//		}
	//
	//		GL11.glPopMatrix();
	//	}

}
