/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine.BottlingProcess;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel.OBJState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

import java.util.Arrays;

public class TileRenderBottlingMachine extends TileEntitySpecialRenderer<TileEntityBottlingMachine>
{
	@Override
	public void func_192841_a(TileEntityBottlingMachine te, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(!te.formed || te.isDummy() || !te.func_145831_w().func_175668_a(te.func_174877_v(), false))
			return;

		//Grab model + correct eextended state
		final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
		BlockPos blockPos = te.func_174877_v();
		IBlockState state = func_178459_a().func_180495_p(blockPos);
		if(state.func_177230_c() != IEContent.blockMetalMultiblock)
			return;
		state = state.func_177230_c().func_176221_a(state, func_178459_a(), blockPos);
		state = state.func_177226_a(IEProperties.DYNAMICRENDER, true);
		IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);

		//Initialize Tesselator and BufferBuilder
		Tessellator tessellator = Tessellator.func_178181_a();
		BufferBuilder worldRenderer = tessellator.func_178180_c();
		//Outer GL Wrapping, initial translation
		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(x+.5, y+.5, z+.5);
		if(te.mirrored)
			GlStateManager.func_179152_a(te.facing.func_82601_c()==0?-1:1,1,te.facing.func_82599_e()==0?-1:1);

		//Item Displacement
		float[][] itemDisplays = new float[te.bottlingProcessQueue.size()][];
		//Animations
		float lift = 0;

		for(int i=0; i<itemDisplays.length; i++)
		{
			BottlingProcess process = te.bottlingProcessQueue.get(i);
			if(process==null || process.processTick==process.maxProcessTick)
				continue;

			//+partialTicks
			float processTimer = ((float)process.processTick)/process.maxProcessTick * 120;

			float itemX = -1.5f;//-1;
			float itemY = -.15625f;// -.34375f;
			float itemZ = 1;//-.9375f;
			float itemFill = 0;//ClientUtils.mc().player.ticksExisted%100; //0f;

			if(processTimer <= 35)//slide
			{
				itemX += processTimer/35f*1.5;
			}
			else if(processTimer <= 85)//slide
			{
				itemX = 0;
				if(processTimer<=55)
					lift=(processTimer-35)/20f*.125f;
				else if(processTimer<=65)
				{
					lift = .125f;
					itemFill = (processTimer-55)/10f;
				}
				else
				{
					lift =(85-processTimer)/20f*.125f;
					itemFill = 1;
				}
				itemY += lift;
				lift+=.0625;
			}
			else
			{
				itemX = (processTimer-85)/35f*1.5f;
				itemFill = 1;
			}
			itemDisplays[i] = new float[]{processTimer,itemX,itemY,itemZ,itemFill};

		}

		ClientUtils.bindAtlas();
		GlStateManager.func_179094_E();

		GlStateManager.func_179109_b(0, lift, 0);
		renderModelPart(blockRenderer, tessellator, worldRenderer, te.func_145831_w(), state, model, blockPos, "lift");
		GlStateManager.func_179109_b(0, -lift, 0);

		RenderHelper.func_74519_b();
		GlStateManager.func_179121_F();

		switch(te.facing)
		{
			case NORTH:
				break;
			case SOUTH:
				GlStateManager.func_179114_b(180, 0, 1, 0);
				break;
			case WEST:
				GlStateManager.func_179114_b(90, 0, 1, 0);
				break;
			case EAST:
				GlStateManager.func_179114_b(-90, 0, 1, 0);
				break;
		}

		float scale = .0625f;
		FluidStack fs = te.tanks[0].getFluid();
		if(fs!=null)
		{
			GlStateManager.func_179094_E();
			float level = fs.amount/(float)te.tanks[0].getCapacity();
			GlStateManager.func_179137_b(-.21875,.376,1.21875);
			GlStateManager.func_179152_a(scale, scale, scale);
			float h = level*9;
			ClientUtils.drawRepeatedFluidSprite(fs, 0,0, 7,h);
			GlStateManager.func_179114_b(90,0,1,0);
			ClientUtils.drawRepeatedFluidSprite(fs, 0,0, 7,h);
			GlStateManager.func_179114_b(90,0,1,0);
			GlStateManager.func_179109_b(-7,0,7);
			ClientUtils.drawRepeatedFluidSprite(fs, 0,0, 7,h);
			GlStateManager.func_179114_b(90,0,1,0);
			ClientUtils.drawRepeatedFluidSprite(fs, 0,0, 7,h);

			GlStateManager.func_179114_b(90,1,0,0);
			ClientUtils.drawRepeatedFluidSprite(fs, 0,0, 7,7);
			GlStateManager.func_179109_b(0,0,-h);
			ClientUtils.drawRepeatedFluidSprite(fs, 0,0, 7,7);

			GlStateManager.func_179152_a(1/scale, 1/scale, 1/scale);
			GlStateManager.func_179109_b(0,-1,-1);
			GlStateManager.func_179121_F();
		}


		//DRAW ITEMS HERE
		for(int i=0; i<itemDisplays.length; i++)
			if(itemDisplays[i]!=null)
			{
				BottlingProcess process = te.bottlingProcessQueue.get(i);
				if(process==null)
					continue;

				ItemStack display = itemDisplays[i][4]==0||process.items.get(1).func_190926_b()?process.items.get(0):process.items.get(1);
				scale = .4375f;

				GlStateManager.func_179109_b(itemDisplays[i][1], itemDisplays[i][2], itemDisplays[i][3]);
				GlStateManager.func_179152_a(scale, scale, scale);

				if(itemDisplays[i][4]==0)
					ClientUtils.mc().func_175599_af().func_181564_a(process.items.get(0), ItemCameraTransforms.TransformType.FIXED);
				else if(itemDisplays[i][4]==1)
					ClientUtils.mc().func_175599_af().func_181564_a(display, ItemCameraTransforms.TransformType.FIXED);
				else
				{
					float h0 = -.5f;
					float h1 = h0+itemDisplays[i][4];

					BufferBuilder worldrenderer = tessellator.func_178180_c();

					GL11.glEnable(GL11.GL_STENCIL_TEST);

					GlStateManager.func_179135_a(false, false, false, false);
					GlStateManager.func_179132_a(false);

					GL11.glStencilFunc(GL11.GL_NEVER, 1, 0xFF);
					GL11.glStencilOp(GL11.GL_REPLACE, GL11.GL_KEEP, GL11.GL_KEEP);

					GL11.glStencilMask(0xFF);
					GlStateManager.func_179086_m(GL11.GL_STENCIL_BUFFER_BIT);

					GlStateManager.func_179114_b(90.0F-ClientUtils.mc().func_175598_ae().field_78735_i, 0.0F, 1.0F, 0.0F);

					GlStateManager.func_179090_x();
					worldrenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181705_e);
					ClientUtils.renderBox(worldrenderer, -.5,h0,-.5, .5,h1,.5);
					tessellator.func_78381_a();
					GlStateManager.func_179098_w();

					GlStateManager.func_179114_b(-(90.0F-ClientUtils.mc().func_175598_ae().field_78735_i), 0.0F, 1.0F, 0.0F);

					GlStateManager.func_179135_a(true, true, true, true);
					GlStateManager.func_179132_a(true);

					GL11.glStencilMask(0x00);

					GL11.glStencilFunc(GL11.GL_EQUAL, 0, 0xFF);
					ClientUtils.mc().func_175599_af().func_181564_a(process.items.get(0), ItemCameraTransforms.TransformType.FIXED);

					GL11.glStencilFunc(GL11.GL_EQUAL, 1, 0xFF);
					ClientUtils.mc().func_175599_af().func_181564_a(display, ItemCameraTransforms.TransformType.FIXED);

					GL11.glDisable(GL11.GL_STENCIL_TEST);
				}

				GlStateManager.func_179152_a(1/scale, 1/scale, 1/scale);
				GlStateManager.func_179109_b(-itemDisplays[i][1], -itemDisplays[i][2], -itemDisplays[i][3]);
			}
		GlStateManager.func_179121_F();
	}

	public static void renderModelPart(final BlockRendererDispatcher blockRenderer, Tessellator tessellator, BufferBuilder worldRenderer, World world, IBlockState state, IBakedModel model, BlockPos pos, String... parts)
	{
		if(state instanceof IExtendedBlockState)
			state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, new OBJState(Arrays.asList(parts), true));

		RenderHelper.func_74518_a();
		GlStateManager.func_179112_b(770, 771);
		GlStateManager.func_179147_l();
		GlStateManager.func_179129_p();
		GlStateManager.func_179131_c(1,0,0,1);
		if(Minecraft.func_71379_u())
			GlStateManager.func_179103_j(7425);
		else
			GlStateManager.func_179103_j(7424);
		worldRenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
		worldRenderer.func_178969_c(-.5 - pos.func_177958_n(), -.5 - pos.func_177956_o(), -.5 - pos.func_177952_p());
		worldRenderer.func_181669_b(255, 255, 255, 255);
		blockRenderer.func_175019_b().func_178267_a(world, model, state, pos, worldRenderer, true);
		worldRenderer.func_178969_c(0.0D, 0.0D, 0.0D);
		tessellator.func_78381_a();
	}
}
