/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import com.google.common.collect.Lists;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.obj.OBJModel.OBJState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

import java.util.List;

public class TileRenderArcFurnace extends TileEntitySpecialRenderer<TileEntityArcFurnace>
{
	private TextureAtlasSprite hotMetal_flow = null;
	private TextureAtlasSprite hotMetal_still = null;
	@Override
	public void func_192841_a(TileEntityArcFurnace te, double x, double y, double z, float partialTicks, int destroyStage, float alpha)
	{
		if(!te.formed || te.isDummy() || !te.func_145831_w().func_175668_a(te.func_174877_v(), false))
			return;
		List<String> renderedParts = null;
		for(int i=0; i<3; i++)
			if(!te.getInventory().get(23+i).func_190926_b())
			{
				if(renderedParts==null)
					renderedParts = Lists.newArrayList("electrode"+(i+1));
				else
					renderedParts.add("electrode"+(i+1));
			}
		if(renderedParts==null)
			return;
		if(te.shouldRenderAsActive())
			renderedParts.add("active");
		
		final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
		BlockPos blockPos = te.func_174877_v();
		IBlockState state = func_178459_a().func_180495_p(blockPos);
		if(state.func_177230_c() != IEContent.blockMetalMultiblock)
			return;
		state = state.func_177230_c().func_176221_a(state, func_178459_a(), blockPos);
		state = state.func_177226_a(IEProperties.DYNAMICRENDER, true);
		IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
		if(state instanceof IExtendedBlockState)
			state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, new OBJState(renderedParts, true));

		Tessellator tessellator = Tessellator.func_178181_a();
		BufferBuilder worldRenderer = tessellator.func_178180_c();

		ClientUtils.bindAtlas();
		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(x, y, z);
		GlStateManager.func_179137_b(.5, .5, .5);

		RenderHelper.func_74518_a();
		GlStateManager.func_179112_b(770, 771);
		GlStateManager.func_179147_l();
		GlStateManager.func_179129_p();
		if(Minecraft.func_71379_u())
			GlStateManager.func_179103_j(7425);
		else
			GlStateManager.func_179103_j(7424);
		worldRenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
		worldRenderer.func_178969_c( -.5-blockPos.func_177958_n(), -.5- blockPos.func_177956_o(),  -.5-blockPos.func_177952_p());
		worldRenderer.func_181669_b(255, 255, 255, 255);
		blockRenderer.func_175019_b().func_178267_a(te.func_145831_w(), model, state, blockPos, worldRenderer, true);
		worldRenderer.func_178969_c(0.0D, 0.0D, 0.0D);
		tessellator.func_78381_a();

		RenderHelper.func_74519_b();
		if(te.pouringMetal>0)
		{
			if (hotMetal_flow==null) {
				hotMetal_still = ApiUtils.getRegisterSprite(ClientUtils.mc().func_147117_R(), "immersiveengineering:blocks/fluid/hot_metal_still");
				hotMetal_flow = ApiUtils.getRegisterSprite(ClientUtils.mc().func_147117_R(), "immersiveengineering:blocks/fluid/hot_metal_flow");
			}
			GlStateManager.func_179114_b(-te.facing.func_185119_l()+180, 0,1,0);
			int process= 40;
			float speed = 5f;
			int pour = process-te.pouringMetal;
			Vector3f tmp = new Vector3f();
			float h = (pour>(process-speed)?((process-pour)/speed*27): pour>speed?27: (pour/speed*27))/16f;
			GlStateManager.func_179137_b(-.5f,1.25-.6875f,1.5f);
			worldRenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181707_g);
			GlStateManager.func_179140_f();
			func_190053_a(true);
			if(pour>(process-speed))
				addTranslation(tmp, worldRenderer, 0,-1.6875f+h,0);
			if(h>1)
			{
				addTranslation(tmp, worldRenderer, 0,-h,0);
				ClientUtils.renderTexturedBox(worldRenderer, .375,0,.375, .625, 1,.625, hotMetal_flow, true);
				addTranslation(tmp, worldRenderer, 0,1,0);
				ClientUtils.renderTexturedBox(worldRenderer, .375,0,.375, .625,h-1,.625, hotMetal_flow, true);
				addTranslation(tmp, worldRenderer, 0,-1,0);
				addTranslation(tmp, worldRenderer, 0,h,0);
			}
			else
			{
				addTranslation(tmp, worldRenderer, 0,-h,0);
				ClientUtils.renderTexturedBox(worldRenderer, .375,0,.375, .625,h,.625, hotMetal_flow, true);
				addTranslation(tmp, worldRenderer, 0,h,0);
			}
			if(pour>(process-speed))
				addTranslation(tmp, worldRenderer, 0,1.6875f-h,0);
			if(pour>speed)
			{
				float h2 = (pour>(process-speed)?.625f: pour/(process-speed)*.625f);
				addTranslation(tmp, worldRenderer, 0,-1.6875f,0);
				ClientUtils.renderTexturedBox(worldRenderer, .125,0,.125, .875,h2,.875, hotMetal_still, false);
				addTranslation(tmp, worldRenderer, 0,1.6875f,0);
			}
			worldRenderer.func_178969_c(0, 0, 0);
			tessellator.func_78381_a();
			func_190053_a(false);
			GlStateManager.func_179145_e();
		}
		GlStateManager.func_179121_F();
	}

	private void addTranslation(Vector3f tmp, BufferBuilder bb, float x, float y, float z)
	{
		tmp.translate(x, y, z);
		bb.func_178969_c(tmp.x, tmp.y, tmp.z);
	}
}
