/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces.IColouredItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class IEBipedLayerRenderer implements LayerRenderer<EntityLivingBase>
{
	public static boolean rendersAssigned = false;

	@Override
	public void func_177141_a(EntityLivingBase living, float limbSwing, float prevLimbSwing, float partialTicks, float rotation, float yaw, float pitch, float scale)
	{
//		if(Lib.BAUBLES && living instanceof EntityPlayer)
//		{
//			ItemStack belt = BaublesHelper.getBauble((EntityPlayer)living,3);
//			if(belt!=null && belt.getItem().equals(IEContent.itemManeuverGear))
//			{
//				GlStateManager.pushMatrix();
//				ModelBiped model = IEContent.itemManeuverGear.getArmorModel((EntityPlayer)living, belt, 2, null);
//				ClientUtils.bindTexture(IEContent.itemManeuverGear.getArmorTexture(belt, (EntityPlayer)living, 2, null));
//				model.render(living, limbSwing, prevLimbSwing, rotation, yaw, pitch, scale);
//				GlStateManager.popMatrix();
//			}
//		}

		if(!living.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && ItemNBTHelper.hasKey(living.func_184582_a(EntityEquipmentSlot.HEAD), "IE:Earmuffs"))
		{
			ItemStack earmuffs = ItemNBTHelper.getItemStack(living.func_184582_a(EntityEquipmentSlot.HEAD), Lib.NBT_Earmuffs);
			if(!earmuffs.func_190926_b())
			{
				GlStateManager.func_179094_E();
				ModelBiped model = IEContent.itemEarmuffs.getArmorModel(living, earmuffs, EntityEquipmentSlot.HEAD, null);
				ClientUtils.bindTexture(IEContent.itemEarmuffs.getArmorTexture(earmuffs, living, EntityEquipmentSlot.HEAD, "overlay"));
				model.func_78088_a(living, limbSwing, prevLimbSwing, rotation, yaw, pitch, scale);
				int colour = ((IColouredItem)earmuffs.func_77973_b()).getColourForIEItem(earmuffs, 0);
				GlStateManager.func_179124_c((colour >> 16 & 255) / 255f, (colour >> 8 & 255) / 255f, (colour & 255) / 255f);
				ClientUtils.bindTexture(IEContent.itemEarmuffs.getArmorTexture(earmuffs, living, EntityEquipmentSlot.HEAD, null));
				model.func_78088_a(living, limbSwing, prevLimbSwing, rotation, yaw, pitch, scale);
				GlStateManager.func_179121_F();
			}
		}

		if(!living.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && ItemNBTHelper.hasKey(living.func_184582_a(EntityEquipmentSlot.CHEST), "IE:Powerpack"))
		{
			ItemStack powerpack = ItemNBTHelper.getItemStack(living.func_184582_a(EntityEquipmentSlot.CHEST), Lib.NBT_Powerpack);
			if(!powerpack.func_190926_b())
			{
				GlStateManager.func_179094_E();
				ModelBiped model = IEContent.itemPowerpack.getArmorModel(living, powerpack, EntityEquipmentSlot.CHEST, null);
				ClientUtils.bindTexture(IEContent.itemPowerpack.getArmorTexture(powerpack, living, EntityEquipmentSlot.CHEST, null));
				model.func_78088_a(living, limbSwing, prevLimbSwing, rotation, yaw, pitch, scale);
				GlStateManager.func_179121_F();
			}
		}
	}

	@Override
	public boolean func_177142_b()
	{
		return false;
	}
}
