/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class EntityRenderRailgunShot extends Render
{
	public EntityRenderRailgunShot(RenderManager renderManager)
	{
		super(renderManager);
	}

	@Override
	public void func_76986_a(Entity entity, double x, double y, double z, float f0, float f1)
	{
		double yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * f1 - 90.0F;
		double pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * f1;

		ItemStack ammo = ((EntityRailgunShot)entity).getAmmo();
		int[][] colourMap = {{0x777777,0xa4a4a4}};
		if(!ammo.func_190926_b())
		{
			RailgunHandler.RailgunProjectileProperties prop = RailgunHandler.getProjectileProperties(ammo);
			colourMap = prop!=null?prop.colourMap:colourMap;
		}
		
		renderRailgunProjectile(x,y,z, yaw, pitch, colourMap);
	}

	public static void renderRailgunProjectile(double x, double y, double z, double yaw, double pitch, int[][] colourMap)
	{
		GlStateManager.func_179094_E();
		GlStateManager.func_179137_b(x, y, z);
		GlStateManager.func_179091_B();
		Tessellator tes = ClientUtils.tes();
		BufferBuilder worldrenderer = ClientUtils.tes().func_178180_c();

		GlStateManager.func_179090_x();
		GlStateManager.func_179147_l();
		GlStateManager.func_179118_c();
		OpenGlHelper.func_148821_a(770, 771, 1, 0);

		GlStateManager.func_179129_p();
		GlStateManager.func_179114_b((float)yaw, 0.0F, 1.0F, 0.0F);
		GlStateManager.func_179114_b((float)pitch, 0.0F, 0.0F, 1.0F);

		GlStateManager.func_179152_a(.25f, .25f, .25f);

		if(colourMap.length==1)
		{
			colourMap = new int[][]{colourMap[0],colourMap[0]};
		}

		float height = .1875f;
		float halfWidth = height/2;
		float length = 2;
		int colWidth = colourMap[0].length;
		for(int i=0; i<colourMap.length; i++)
			colWidth = Math.min(colWidth, colourMap[i].length);
		int colLength = colourMap.length;
		float widthStep = height/colWidth;
		float lengthStep = length/colLength;

		GlStateManager.func_179109_b(-length*.85f,0,0);
		worldrenderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181706_f);
		int colR;
		int colG;
		int colB;
		//Front&Back
		GlStateManager.func_179131_c(1f, 1f, 1f, 1f);
		for(int i=0; i<colWidth; i++)
		{
			colR = (colourMap[0][i]>>16)&255;
			colG = (colourMap[0][i]>>8)&255;
			colB = colourMap[0][i]&255;
			worldrenderer.func_181662_b(0,height,-halfWidth+widthStep*i).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(0,0     ,-halfWidth+widthStep*i).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(0,0     ,-halfWidth+widthStep*(i+1)).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(0,height,-halfWidth+widthStep*(i+1)).func_181669_b(colR,colG,colB,255).func_181675_d();

			colR = colourMap[colLength-1][i]>>16&255;
			colG = colourMap[colLength-1][i]>>8&255;
			colB = colourMap[colLength-1][i]&255;
			worldrenderer.func_181662_b(length,0     ,-halfWidth+widthStep*i).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(length,height,-halfWidth+widthStep*i).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(length,height,-halfWidth+widthStep*(i+1)).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(length,0     ,-halfWidth+widthStep*(i+1)).func_181669_b(colR,colG,colB,255).func_181675_d();
		}
		//Sides
		for(int i=0; i<colLength; i++)
		{
			colR = colourMap[i][0]>>16&255;
			colG = colourMap[i][0]>>8&255;
			colB = colourMap[i][0]&255;
			worldrenderer.func_181662_b(lengthStep*i    ,0     ,-halfWidth).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(lengthStep*i    ,height,-halfWidth).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(lengthStep*(i+1),height,-halfWidth).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(lengthStep*(i+1),0     ,-halfWidth).func_181669_b(colR,colG,colB,255).func_181675_d();

			colR = colourMap[i][colWidth-1]>>16&255;
			colG = colourMap[i][colWidth-1]>>8&255;
			colB = colourMap[i][colWidth-1]&255;
			worldrenderer.func_181662_b(lengthStep*i    ,height,halfWidth).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(lengthStep*i    ,0     ,halfWidth).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(lengthStep*(i+1),0     ,halfWidth).func_181669_b(colR,colG,colB,255).func_181675_d();
			worldrenderer.func_181662_b(lengthStep*(i+1),height,halfWidth).func_181669_b(colR,colG,colB,255).func_181675_d();
		}
		//Top&Bottom
		for(int i=0; i<colLength; i++)
			for(int j=0; j<colWidth; j++)
			{
				colR = colourMap[i][j]>>16&255;
				colG = colourMap[i][j]>>8&255;
				colB = colourMap[i][j]&255;
				worldrenderer.func_181662_b(lengthStep*(i+1),height,-halfWidth+widthStep*j).func_181669_b(colR,colG,colB,255).func_181675_d();
				worldrenderer.func_181662_b(lengthStep*i    ,height,-halfWidth+widthStep*j).func_181669_b(colR,colG,colB,255).func_181675_d();
				worldrenderer.func_181662_b(lengthStep*i    ,height,-halfWidth+widthStep*(j+1)).func_181669_b(colR,colG,colB,255).func_181675_d();
				worldrenderer.func_181662_b(lengthStep*(i+1),height,-halfWidth+widthStep*(j+1)).func_181669_b(colR,colG,colB,255).func_181675_d();

				worldrenderer.func_181662_b(lengthStep*i    ,0     ,-halfWidth+widthStep*j).func_181669_b(colR,colG,colB,255).func_181675_d();
				worldrenderer.func_181662_b(lengthStep*(i+1),0     ,-halfWidth+widthStep*j).func_181669_b(colR,colG,colB,255).func_181675_d();
				worldrenderer.func_181662_b(lengthStep*(i+1),0     ,-halfWidth+widthStep*(j+1)).func_181669_b(colR,colG,colB,255).func_181675_d();
				worldrenderer.func_181662_b(lengthStep*i    ,0     ,-halfWidth+widthStep*(j+1)).func_181669_b(colR,colG,colB,255).func_181675_d();
			}
		tes.func_78381_a();

		GlStateManager.func_179147_l();
		GlStateManager.func_179141_d();
		GlStateManager.func_179098_w();

		GlStateManager.func_179089_o();
		GlStateManager.func_179101_C();
		GlStateManager.func_179121_F();
	}


	@Override
	protected ResourceLocation func_110775_a(Entity p_110775_1_)
	{
		return new ResourceLocation("immersiveengineering:textures/models/white.png");
	}

}
