/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.common.entities.EntityIEExplosive;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class EntityRenderIEExplosive extends Render<EntityIEExplosive>
{
	public EntityRenderIEExplosive(RenderManager renderManager)
	{
		super(renderManager);
		this.field_76989_e = .5f;
	}

	@Override
	public void func_76986_a(EntityIEExplosive entity, double x, double y, double z, float entityYaw, float partialTicks)
	{
		if(entity.block==null)
			return;
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y + 0.5F, (float)z);

        if(entity.func_184536_l()-partialTicks+1 < 10)
        {
            float f = 1.0F - ((float)entity.func_184536_l() - partialTicks + 1.0F) / 10.0F;
            f = MathHelper.func_76131_a(f, 0.0F, 1.0F);
            f = f * f;
            f = f * f;
            float f1 = 1.0F + f * 0.3F;
            GlStateManager.func_179152_a(f1, f1, f1);
        }
        
        float f2 = (1-(entity.func_184536_l()-partialTicks+1)/100F) * .8F;
        this.func_180548_c(entity);
        GlStateManager.func_179109_b(-0.5F, -0.5F, 0.5F);
        blockrendererdispatcher.func_175016_a(entity.block, entity.func_70013_c());
        GlStateManager.func_179109_b(0.0F, 0.0F, 1.0F);

        if(entity.func_184536_l()/5%2 == 0)
        {
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b(770, 772);
            GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, f2);
            GlStateManager.func_179136_a(-3.0F, -3.0F);
            GlStateManager.func_179088_q();
            blockrendererdispatcher.func_175016_a(entity.block, 1.0F);
            GlStateManager.func_179136_a(0.0F, 0.0F);
            GlStateManager.func_179113_r();
            GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
        }

        GlStateManager.func_179121_F();
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
	}

	@Override
    protected ResourceLocation func_110775_a(EntityIEExplosive entity)
    {
        return TextureMap.field_110575_b;
    }
}
